<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRatePlanType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides detailed information for how this rate is derived. | The Start and End date of the rate plan or a season within a rate plan. | All details pertaining to a specific rate plan.
 * @subpackage Structs
 */
class HotelRatePlanType extends AbstractStructBase
{
    /**
     * The DestinationSystemsCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DestinationSystemsCode
     */
    public $DestinationSystemsCode;
    /**
     * The BookingRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingRules
     */
    public $BookingRules;
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Rates
     */
    public $Rates;
    /**
     * The Supplements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplements
     */
    public $Supplements;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Offers
     */
    public $Offers;
    /**
     * The RatePlanShoulders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlanShoulders
     */
    public $RatePlanShoulders;
    /**
     * The SellableProducts
     * Meta information extracted from the WSDL
     * - documentation: A collection of Sellable Products.
     * - minOccurs: 0
     * @var mixed
     */
    public $SellableProducts;
    /**
     * The RatePlanLevelFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlanLevelFee
     */
    public $RatePlanLevelFee;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: Commission assoiciated with the RatePlan. This can be a percentage or a flat amount.
     * - minOccurs: 0
     * @var mixed
     */
    public $Commission;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the RatePlan being Uploaded.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier element allows the trading partners to uniquely identify each Rate being uploaded, for transaction tracability.
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The RatePlanNotifType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RatePlanNotifType;
    /**
     * The RatePlanStatusType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RatePlanStatusType;
    /**
     * The RatePlanNotifScopeType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RatePlanNotifScopeType;
    /**
     * The IsCommissionable
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $IsCommissionable;
    /**
     * The RateReturn
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $RateReturn;
    /**
     * The YieldableIndicator
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate the rate plan is subject to yield management logic. When true, the rate plan is yieldable. When false, the rate plan is not yieldable.
     * - use: optional
     * @var bool
     */
    public $YieldableIndicator;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - documentation: The code that relates to the market being sold to (e.g., the corporate market, packages).
     * - use: optional
     * @var string
     */
    public $MarketCode;
    /**
     * The YieldDeltaAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount to be added or subtracted from the rate. The new calulated value is then used by the yield management logic.
     * - use: optional
     * @var float
     */
    public $YieldDeltaAmount;
    /**
     * The InventoryAllocatedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the inventory associated with the rate plan is removed from the house inventory. When false, the inventory associated to the rate plan is not removed from the house inventory.
     * - use: optional
     * @var bool
     */
    public $InventoryAllocatedInd;
    /**
     * The RestrictedDisplayIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, used to indicate the rate should not be displayed. When false, indicates the rate may be displayed.
     * - use: optional
     * @var bool
     */
    public $RestrictedDisplayIndicator;
    /**
     * The EarliestStartIndicator
     * Meta information extracted from the WSDL
     * - documentation: This is used in conjunction with the Start attribute. When true, it indicates that the Start date is both the beginning of a season as well as the first date the rate plan is valid.
     * - use: optional
     * @var bool
     */
    public $EarliestStartIndicator;
    /**
     * The LatestEndIndicator
     * Meta information extracted from the WSDL
     * - documentation: This is used in conjunction with the End attribute. When true, it indicates that the End date is both the end of a season as well as the last date the rate plan is valid.
     * - use: optional
     * @var bool
     */
    public $LatestEndIndicator;
    /**
     * The ExtraNightRatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate what rate plan is used for shoulder night(s) booked in addition to the base nights.
     * - use: optional
     * @var string
     */
    public $ExtraNightRatePlanCode;
    /**
     * The ChargeTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Describes how the charge is applied. Refer to OpenTravel Code List Charge Type (CHG).
     * - use: optional
     * @var string
     */
    public $ChargeTypeCode;
    /**
     * Constructor method for HotelRatePlanType
     * @uses HotelRatePlanType::setDestinationSystemsCode()
     * @uses HotelRatePlanType::setBookingRules()
     * @uses HotelRatePlanType::setRates()
     * @uses HotelRatePlanType::setSupplements()
     * @uses HotelRatePlanType::setOffers()
     * @uses HotelRatePlanType::setRatePlanShoulders()
     * @uses HotelRatePlanType::setSellableProducts()
     * @uses HotelRatePlanType::setRatePlanLevelFee()
     * @uses HotelRatePlanType::setCommission()
     * @uses HotelRatePlanType::setDescription()
     * @uses HotelRatePlanType::setUniqueID()
     * @uses HotelRatePlanType::setHotelRef()
     * @uses HotelRatePlanType::setRatePlanNotifType()
     * @uses HotelRatePlanType::setRatePlanStatusType()
     * @uses HotelRatePlanType::setRatePlanNotifScopeType()
     * @uses HotelRatePlanType::setIsCommissionable()
     * @uses HotelRatePlanType::setRateReturn()
     * @uses HotelRatePlanType::setYieldableIndicator()
     * @uses HotelRatePlanType::setMarketCode()
     * @uses HotelRatePlanType::setYieldDeltaAmount()
     * @uses HotelRatePlanType::setInventoryAllocatedInd()
     * @uses HotelRatePlanType::setRestrictedDisplayIndicator()
     * @uses HotelRatePlanType::setEarliestStartIndicator()
     * @uses HotelRatePlanType::setLatestEndIndicator()
     * @uses HotelRatePlanType::setExtraNightRatePlanCode()
     * @uses HotelRatePlanType::setChargeTypeCode()
     * @param \StructType\DestinationSystemsCode $destinationSystemsCode
     * @param \StructType\BookingRules $bookingRules
     * @param \StructType\Rates $rates
     * @param \StructType\Supplements $supplements
     * @param \StructType\Offers $offers
     * @param \StructType\RatePlanShoulders $ratePlanShoulders
     * @param mixed $sellableProducts
     * @param \StructType\RatePlanLevelFee $ratePlanLevelFee
     * @param mixed $commission
     * @param mixed[] $description
     * @param mixed $uniqueID
     * @param \StructType\HotelRef $hotelRef
     * @param string $ratePlanNotifType
     * @param string $ratePlanStatusType
     * @param string $ratePlanNotifScopeType
     * @param bool $isCommissionable
     * @param bool $rateReturn
     * @param bool $yieldableIndicator
     * @param string $marketCode
     * @param float $yieldDeltaAmount
     * @param bool $inventoryAllocatedInd
     * @param bool $restrictedDisplayIndicator
     * @param bool $earliestStartIndicator
     * @param bool $latestEndIndicator
     * @param string $extraNightRatePlanCode
     * @param string $chargeTypeCode
     */
    public function __construct(\StructType\DestinationSystemsCode $destinationSystemsCode = null, \StructType\BookingRules $bookingRules = null, \StructType\Rates $rates = null, \StructType\Supplements $supplements = null, \StructType\Offers $offers = null, \StructType\RatePlanShoulders $ratePlanShoulders = null, $sellableProducts = null, \StructType\RatePlanLevelFee $ratePlanLevelFee = null, $commission = null, array $description = array(), $uniqueID = null, \StructType\HotelRef $hotelRef = null, $ratePlanNotifType = null, $ratePlanStatusType = null, $ratePlanNotifScopeType = null, $isCommissionable = null, $rateReturn = null, $yieldableIndicator = null, $marketCode = null, $yieldDeltaAmount = null, $inventoryAllocatedInd = null, $restrictedDisplayIndicator = null, $earliestStartIndicator = null, $latestEndIndicator = null, $extraNightRatePlanCode = null, $chargeTypeCode = null)
    {
        $this
            ->setDestinationSystemsCode($destinationSystemsCode)
            ->setBookingRules($bookingRules)
            ->setRates($rates)
            ->setSupplements($supplements)
            ->setOffers($offers)
            ->setRatePlanShoulders($ratePlanShoulders)
            ->setSellableProducts($sellableProducts)
            ->setRatePlanLevelFee($ratePlanLevelFee)
            ->setCommission($commission)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setHotelRef($hotelRef)
            ->setRatePlanNotifType($ratePlanNotifType)
            ->setRatePlanStatusType($ratePlanStatusType)
            ->setRatePlanNotifScopeType($ratePlanNotifScopeType)
            ->setIsCommissionable($isCommissionable)
            ->setRateReturn($rateReturn)
            ->setYieldableIndicator($yieldableIndicator)
            ->setMarketCode($marketCode)
            ->setYieldDeltaAmount($yieldDeltaAmount)
            ->setInventoryAllocatedInd($inventoryAllocatedInd)
            ->setRestrictedDisplayIndicator($restrictedDisplayIndicator)
            ->setEarliestStartIndicator($earliestStartIndicator)
            ->setLatestEndIndicator($latestEndIndicator)
            ->setExtraNightRatePlanCode($extraNightRatePlanCode)
            ->setChargeTypeCode($chargeTypeCode);
    }
    /**
     * Get DestinationSystemsCode value
     * @return \StructType\DestinationSystemsCode|null
     */
    public function getDestinationSystemsCode()
    {
        return $this->DestinationSystemsCode;
    }
    /**
     * Set DestinationSystemsCode value
     * @param \StructType\DestinationSystemsCode $destinationSystemsCode
     * @return \StructType\HotelRatePlanType
     */
    public function setDestinationSystemsCode(\StructType\DestinationSystemsCode $destinationSystemsCode = null)
    {
        $this->DestinationSystemsCode = $destinationSystemsCode;
        return $this;
    }
    /**
     * Get BookingRules value
     * @return \StructType\BookingRules|null
     */
    public function getBookingRules()
    {
        return $this->BookingRules;
    }
    /**
     * Set BookingRules value
     * @param \StructType\BookingRules $bookingRules
     * @return \StructType\HotelRatePlanType
     */
    public function setBookingRules(\StructType\BookingRules $bookingRules = null)
    {
        $this->BookingRules = $bookingRules;
        return $this;
    }
    /**
     * Get Rates value
     * @return \StructType\Rates|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \StructType\Rates $rates
     * @return \StructType\HotelRatePlanType
     */
    public function setRates(\StructType\Rates $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get Supplements value
     * @return \StructType\Supplements|null
     */
    public function getSupplements()
    {
        return $this->Supplements;
    }
    /**
     * Set Supplements value
     * @param \StructType\Supplements $supplements
     * @return \StructType\HotelRatePlanType
     */
    public function setSupplements(\StructType\Supplements $supplements = null)
    {
        $this->Supplements = $supplements;
        return $this;
    }
    /**
     * Get Offers value
     * @return \StructType\Offers|null
     */
    public function getOffers()
    {
        return $this->Offers;
    }
    /**
     * Set Offers value
     * @param \StructType\Offers $offers
     * @return \StructType\HotelRatePlanType
     */
    public function setOffers(\StructType\Offers $offers = null)
    {
        $this->Offers = $offers;
        return $this;
    }
    /**
     * Get RatePlanShoulders value
     * @return \StructType\RatePlanShoulders|null
     */
    public function getRatePlanShoulders()
    {
        return $this->RatePlanShoulders;
    }
    /**
     * Set RatePlanShoulders value
     * @param \StructType\RatePlanShoulders $ratePlanShoulders
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanShoulders(\StructType\RatePlanShoulders $ratePlanShoulders = null)
    {
        $this->RatePlanShoulders = $ratePlanShoulders;
        return $this;
    }
    /**
     * Get SellableProducts value
     * @return mixed|null
     */
    public function getSellableProducts()
    {
        return $this->SellableProducts;
    }
    /**
     * Set SellableProducts value
     * @param mixed $sellableProducts
     * @return \StructType\HotelRatePlanType
     */
    public function setSellableProducts($sellableProducts = null)
    {
        $this->SellableProducts = $sellableProducts;
        return $this;
    }
    /**
     * Get RatePlanLevelFee value
     * @return \StructType\RatePlanLevelFee|null
     */
    public function getRatePlanLevelFee()
    {
        return $this->RatePlanLevelFee;
    }
    /**
     * Set RatePlanLevelFee value
     * @param \StructType\RatePlanLevelFee $ratePlanLevelFee
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanLevelFee(\StructType\RatePlanLevelFee $ratePlanLevelFee = null)
    {
        $this->RatePlanLevelFee = $ratePlanLevelFee;
        return $this;
    }
    /**
     * Get Commission value
     * @return mixed|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param mixed $commission
     * @return \StructType\HotelRatePlanType
     */
    public function setCommission($commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelRatePlanTypeDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelRatePlanTypeDescriptionItem) ? get_class($hotelRatePlanTypeDescriptionItem) : sprintf('%s(%s)', gettype($hotelRatePlanTypeDescriptionItem), var_export($hotelRatePlanTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\HotelRatePlanType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelRatePlanType
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\HotelRatePlanType
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\HotelRatePlanType
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get RatePlanNotifType value
     * @return string|null
     */
    public function getRatePlanNotifType()
    {
        return $this->RatePlanNotifType;
    }
    /**
     * Set RatePlanNotifType value
     * @param string $ratePlanNotifType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanNotifType($ratePlanNotifType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanNotifType) && !is_string($ratePlanNotifType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanNotifType, true), gettype($ratePlanNotifType)), __LINE__);
        }
        $this->RatePlanNotifType = $ratePlanNotifType;
        return $this;
    }
    /**
     * Get RatePlanStatusType value
     * @return string|null
     */
    public function getRatePlanStatusType()
    {
        return $this->RatePlanStatusType;
    }
    /**
     * Set RatePlanStatusType value
     * @param string $ratePlanStatusType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanStatusType($ratePlanStatusType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanStatusType) && !is_string($ratePlanStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanStatusType, true), gettype($ratePlanStatusType)), __LINE__);
        }
        $this->RatePlanStatusType = $ratePlanStatusType;
        return $this;
    }
    /**
     * Get RatePlanNotifScopeType value
     * @return string|null
     */
    public function getRatePlanNotifScopeType()
    {
        return $this->RatePlanNotifScopeType;
    }
    /**
     * Set RatePlanNotifScopeType value
     * @param string $ratePlanNotifScopeType
     * @return \StructType\HotelRatePlanType
     */
    public function setRatePlanNotifScopeType($ratePlanNotifScopeType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanNotifScopeType) && !is_string($ratePlanNotifScopeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanNotifScopeType, true), gettype($ratePlanNotifScopeType)), __LINE__);
        }
        $this->RatePlanNotifScopeType = $ratePlanNotifScopeType;
        return $this;
    }
    /**
     * Get IsCommissionable value
     * @return bool|null
     */
    public function getIsCommissionable()
    {
        return $this->IsCommissionable;
    }
    /**
     * Set IsCommissionable value
     * @param bool $isCommissionable
     * @return \StructType\HotelRatePlanType
     */
    public function setIsCommissionable($isCommissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommissionable) && !is_bool($isCommissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommissionable, true), gettype($isCommissionable)), __LINE__);
        }
        $this->IsCommissionable = $isCommissionable;
        return $this;
    }
    /**
     * Get RateReturn value
     * @return bool|null
     */
    public function getRateReturn()
    {
        return $this->RateReturn;
    }
    /**
     * Set RateReturn value
     * @param bool $rateReturn
     * @return \StructType\HotelRatePlanType
     */
    public function setRateReturn($rateReturn = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateReturn) && !is_bool($rateReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateReturn, true), gettype($rateReturn)), __LINE__);
        }
        $this->RateReturn = $rateReturn;
        return $this;
    }
    /**
     * Get YieldableIndicator value
     * @return bool|null
     */
    public function getYieldableIndicator()
    {
        return $this->YieldableIndicator;
    }
    /**
     * Set YieldableIndicator value
     * @param bool $yieldableIndicator
     * @return \StructType\HotelRatePlanType
     */
    public function setYieldableIndicator($yieldableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($yieldableIndicator) && !is_bool($yieldableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($yieldableIndicator, true), gettype($yieldableIndicator)), __LINE__);
        }
        $this->YieldableIndicator = $yieldableIndicator;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \StructType\HotelRatePlanType
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get YieldDeltaAmount value
     * @return float|null
     */
    public function getYieldDeltaAmount()
    {
        return $this->YieldDeltaAmount;
    }
    /**
     * Set YieldDeltaAmount value
     * @param float $yieldDeltaAmount
     * @return \StructType\HotelRatePlanType
     */
    public function setYieldDeltaAmount($yieldDeltaAmount = null)
    {
        // validation for constraint: float
        if (!is_null($yieldDeltaAmount) && !(is_float($yieldDeltaAmount) || is_numeric($yieldDeltaAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yieldDeltaAmount, true), gettype($yieldDeltaAmount)), __LINE__);
        }
        $this->YieldDeltaAmount = $yieldDeltaAmount;
        return $this;
    }
    /**
     * Get InventoryAllocatedInd value
     * @return bool|null
     */
    public function getInventoryAllocatedInd()
    {
        return $this->InventoryAllocatedInd;
    }
    /**
     * Set InventoryAllocatedInd value
     * @param bool $inventoryAllocatedInd
     * @return \StructType\HotelRatePlanType
     */
    public function setInventoryAllocatedInd($inventoryAllocatedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($inventoryAllocatedInd) && !is_bool($inventoryAllocatedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inventoryAllocatedInd, true), gettype($inventoryAllocatedInd)), __LINE__);
        }
        $this->InventoryAllocatedInd = $inventoryAllocatedInd;
        return $this;
    }
    /**
     * Get RestrictedDisplayIndicator value
     * @return bool|null
     */
    public function getRestrictedDisplayIndicator()
    {
        return $this->RestrictedDisplayIndicator;
    }
    /**
     * Set RestrictedDisplayIndicator value
     * @param bool $restrictedDisplayIndicator
     * @return \StructType\HotelRatePlanType
     */
    public function setRestrictedDisplayIndicator($restrictedDisplayIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedDisplayIndicator) && !is_bool($restrictedDisplayIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictedDisplayIndicator, true), gettype($restrictedDisplayIndicator)), __LINE__);
        }
        $this->RestrictedDisplayIndicator = $restrictedDisplayIndicator;
        return $this;
    }
    /**
     * Get EarliestStartIndicator value
     * @return bool|null
     */
    public function getEarliestStartIndicator()
    {
        return $this->EarliestStartIndicator;
    }
    /**
     * Set EarliestStartIndicator value
     * @param bool $earliestStartIndicator
     * @return \StructType\HotelRatePlanType
     */
    public function setEarliestStartIndicator($earliestStartIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($earliestStartIndicator) && !is_bool($earliestStartIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($earliestStartIndicator, true), gettype($earliestStartIndicator)), __LINE__);
        }
        $this->EarliestStartIndicator = $earliestStartIndicator;
        return $this;
    }
    /**
     * Get LatestEndIndicator value
     * @return bool|null
     */
    public function getLatestEndIndicator()
    {
        return $this->LatestEndIndicator;
    }
    /**
     * Set LatestEndIndicator value
     * @param bool $latestEndIndicator
     * @return \StructType\HotelRatePlanType
     */
    public function setLatestEndIndicator($latestEndIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($latestEndIndicator) && !is_bool($latestEndIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($latestEndIndicator, true), gettype($latestEndIndicator)), __LINE__);
        }
        $this->LatestEndIndicator = $latestEndIndicator;
        return $this;
    }
    /**
     * Get ExtraNightRatePlanCode value
     * @return string|null
     */
    public function getExtraNightRatePlanCode()
    {
        return $this->ExtraNightRatePlanCode;
    }
    /**
     * Set ExtraNightRatePlanCode value
     * @param string $extraNightRatePlanCode
     * @return \StructType\HotelRatePlanType
     */
    public function setExtraNightRatePlanCode($extraNightRatePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($extraNightRatePlanCode) && !is_string($extraNightRatePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraNightRatePlanCode, true), gettype($extraNightRatePlanCode)), __LINE__);
        }
        $this->ExtraNightRatePlanCode = $extraNightRatePlanCode;
        return $this;
    }
    /**
     * Get ChargeTypeCode value
     * @return string|null
     */
    public function getChargeTypeCode()
    {
        return $this->ChargeTypeCode;
    }
    /**
     * Set ChargeTypeCode value
     * @param string $chargeTypeCode
     * @return \StructType\HotelRatePlanType
     */
    public function setChargeTypeCode($chargeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeTypeCode) && !is_string($chargeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeTypeCode, true), gettype($chargeTypeCode)), __LINE__);
        }
        $this->ChargeTypeCode = $chargeTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRatePlanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
