<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: These are the hotel preference elements used on an instance of a profile.
 * @subpackage Structs
 */
class HotelPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PaymentFormPref;
    /**
     * The HotelChainPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $HotelChainPref;
    /**
     * The PropertyNamePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PropertyNamePref;
    /**
     * The PropertyLocationPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PropertyLocationPref;
    /**
     * The PropertyTypePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PropertyTypePref;
    /**
     * The PropertyClassPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PropertyClassPref;
    /**
     * The PropertyAmenityPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PropertyAmenityPref;
    /**
     * The RoomAmenityPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RoomAmenityPref;
    /**
     * The RoomLocationPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RoomLocationPref;
    /**
     * The BedTypePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $BedTypePref;
    /**
     * The FoodSrvcPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $FoodSrvcPref;
    /**
     * The MediaEntertainPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MealPref;
    /**
     * The RecreationSrvcPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RecreationSrvcPref;
    /**
     * The BusinessSrvcPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $BusinessSrvcPref;
    /**
     * The PersonalSrvcPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PersonalSrvcPref;
    /**
     * The SecurityFeaturePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SecurityFeaturePref;
    /**
     * The PhysChallFeaturePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PhysChallFeaturePref;
    /**
     * The SpecRequestPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SpecRequestPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: Code identifying preferred hotel rate plan for this travel situation
     * @var string
     */
    public $RatePlanCode;
    /**
     * The HotelGuestType
     * Meta information extracted from the WSDL
     * - documentation: Category of hotel guest. Refer to OpenTravel Code List Hotel Guest Type (GUE).
     * @var string
     */
    public $HotelGuestType;
    /**
     * Constructor method for HotelPrefType
     * @uses HotelPrefType::setLoyaltyPref()
     * @uses HotelPrefType::setPaymentFormPref()
     * @uses HotelPrefType::setHotelChainPref()
     * @uses HotelPrefType::setPropertyNamePref()
     * @uses HotelPrefType::setPropertyLocationPref()
     * @uses HotelPrefType::setPropertyTypePref()
     * @uses HotelPrefType::setPropertyClassPref()
     * @uses HotelPrefType::setPropertyAmenityPref()
     * @uses HotelPrefType::setRoomAmenityPref()
     * @uses HotelPrefType::setRoomLocationPref()
     * @uses HotelPrefType::setBedTypePref()
     * @uses HotelPrefType::setFoodSrvcPref()
     * @uses HotelPrefType::setMediaEntertainPref()
     * @uses HotelPrefType::setPetInfoPref()
     * @uses HotelPrefType::setMealPref()
     * @uses HotelPrefType::setRecreationSrvcPref()
     * @uses HotelPrefType::setBusinessSrvcPref()
     * @uses HotelPrefType::setPersonalSrvcPref()
     * @uses HotelPrefType::setSecurityFeaturePref()
     * @uses HotelPrefType::setPhysChallFeaturePref()
     * @uses HotelPrefType::setSpecRequestPref()
     * @uses HotelPrefType::setTPA_Extensions()
     * @uses HotelPrefType::setRatePlanCode()
     * @uses HotelPrefType::setHotelGuestType()
     * @param mixed[] $loyaltyPref
     * @param mixed[] $paymentFormPref
     * @param mixed[] $hotelChainPref
     * @param mixed[] $propertyNamePref
     * @param mixed[] $propertyLocationPref
     * @param mixed[] $propertyTypePref
     * @param mixed[] $propertyClassPref
     * @param mixed[] $propertyAmenityPref
     * @param mixed[] $roomAmenityPref
     * @param mixed[] $roomLocationPref
     * @param mixed[] $bedTypePref
     * @param mixed[] $foodSrvcPref
     * @param mixed[] $mediaEntertainPref
     * @param mixed[] $petInfoPref
     * @param mixed[] $mealPref
     * @param mixed[] $recreationSrvcPref
     * @param mixed[] $businessSrvcPref
     * @param mixed[] $personalSrvcPref
     * @param mixed[] $securityFeaturePref
     * @param mixed[] $physChallFeaturePref
     * @param mixed[] $specRequestPref
     * @param mixed $tPA_Extensions
     * @param string $ratePlanCode
     * @param string $hotelGuestType
     */
    public function __construct(array $loyaltyPref = array(), array $paymentFormPref = array(), array $hotelChainPref = array(), array $propertyNamePref = array(), array $propertyLocationPref = array(), array $propertyTypePref = array(), array $propertyClassPref = array(), array $propertyAmenityPref = array(), array $roomAmenityPref = array(), array $roomLocationPref = array(), array $bedTypePref = array(), array $foodSrvcPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $recreationSrvcPref = array(), array $businessSrvcPref = array(), array $personalSrvcPref = array(), array $securityFeaturePref = array(), array $physChallFeaturePref = array(), array $specRequestPref = array(), $tPA_Extensions = null, $ratePlanCode = null, $hotelGuestType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setHotelChainPref($hotelChainPref)
            ->setPropertyNamePref($propertyNamePref)
            ->setPropertyLocationPref($propertyLocationPref)
            ->setPropertyTypePref($propertyTypePref)
            ->setPropertyClassPref($propertyClassPref)
            ->setPropertyAmenityPref($propertyAmenityPref)
            ->setRoomAmenityPref($roomAmenityPref)
            ->setRoomLocationPref($roomLocationPref)
            ->setBedTypePref($bedTypePref)
            ->setFoodSrvcPref($foodSrvcPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setRecreationSrvcPref($recreationSrvcPref)
            ->setBusinessSrvcPref($businessSrvcPref)
            ->setPersonalSrvcPref($personalSrvcPref)
            ->setSecurityFeaturePref($securityFeaturePref)
            ->setPhysChallFeaturePref($physChallFeaturePref)
            ->setSpecRequestPref($specRequestPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRatePlanCode($ratePlanCode)
            ->setHotelGuestType($hotelGuestType);
    }
    /**
     * Get LoyaltyPref value
     * @return mixed[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeLoyaltyPrefItem) ? get_class($hotelPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeLoyaltyPrefItem), var_export($hotelPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyPref
     * @return \StructType\HotelPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToLoyaltyPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return mixed[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePaymentFormPrefItem) ? get_class($hotelPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePaymentFormPrefItem), var_export($hotelPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentFormPref
     * @return \StructType\HotelPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPaymentFormPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get HotelChainPref value
     * @return mixed[]|null
     */
    public function getHotelChainPref()
    {
        return $this->HotelChainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelChainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelChainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelChainPrefForArrayConstraintsFromSetHotelChainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeHotelChainPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeHotelChainPrefItem) ? get_class($hotelPrefTypeHotelChainPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeHotelChainPrefItem), var_export($hotelPrefTypeHotelChainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelChainPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelChainPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $hotelChainPref
     * @return \StructType\HotelPrefType
     */
    public function setHotelChainPref(array $hotelChainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelChainPrefArrayErrorMessage = self::validateHotelChainPrefForArrayConstraintsFromSetHotelChainPref($hotelChainPref))) {
            throw new \InvalidArgumentException($hotelChainPrefArrayErrorMessage, __LINE__);
        }
        $this->HotelChainPref = $hotelChainPref;
        return $this;
    }
    /**
     * Add item to HotelChainPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToHotelChainPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The HotelChainPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelChainPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyNamePref value
     * @return mixed[]|null
     */
    public function getPropertyNamePref()
    {
        return $this->PropertyNamePref;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyNamePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyNamePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyNamePrefForArrayConstraintsFromSetPropertyNamePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePropertyNamePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePropertyNamePrefItem) ? get_class($hotelPrefTypePropertyNamePrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePropertyNamePrefItem), var_export($hotelPrefTypePropertyNamePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyNamePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyNamePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $propertyNamePref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyNamePref(array $propertyNamePref = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyNamePrefArrayErrorMessage = self::validatePropertyNamePrefForArrayConstraintsFromSetPropertyNamePref($propertyNamePref))) {
            throw new \InvalidArgumentException($propertyNamePrefArrayErrorMessage, __LINE__);
        }
        $this->PropertyNamePref = $propertyNamePref;
        return $this;
    }
    /**
     * Add item to PropertyNamePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyNamePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PropertyNamePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyNamePref[] = $item;
        return $this;
    }
    /**
     * Get PropertyLocationPref value
     * @return mixed[]|null
     */
    public function getPropertyLocationPref()
    {
        return $this->PropertyLocationPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyLocationPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyLocationPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyLocationPrefForArrayConstraintsFromSetPropertyLocationPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePropertyLocationPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePropertyLocationPrefItem) ? get_class($hotelPrefTypePropertyLocationPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePropertyLocationPrefItem), var_export($hotelPrefTypePropertyLocationPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyLocationPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyLocationPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $propertyLocationPref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyLocationPref(array $propertyLocationPref = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyLocationPrefArrayErrorMessage = self::validatePropertyLocationPrefForArrayConstraintsFromSetPropertyLocationPref($propertyLocationPref))) {
            throw new \InvalidArgumentException($propertyLocationPrefArrayErrorMessage, __LINE__);
        }
        $this->PropertyLocationPref = $propertyLocationPref;
        return $this;
    }
    /**
     * Add item to PropertyLocationPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyLocationPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PropertyLocationPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyLocationPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyTypePref value
     * @return mixed[]|null
     */
    public function getPropertyTypePref()
    {
        return $this->PropertyTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyTypePrefForArrayConstraintsFromSetPropertyTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePropertyTypePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePropertyTypePrefItem) ? get_class($hotelPrefTypePropertyTypePrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePropertyTypePrefItem), var_export($hotelPrefTypePropertyTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyTypePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyTypePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $propertyTypePref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyTypePref(array $propertyTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyTypePrefArrayErrorMessage = self::validatePropertyTypePrefForArrayConstraintsFromSetPropertyTypePref($propertyTypePref))) {
            throw new \InvalidArgumentException($propertyTypePrefArrayErrorMessage, __LINE__);
        }
        $this->PropertyTypePref = $propertyTypePref;
        return $this;
    }
    /**
     * Add item to PropertyTypePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyTypePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PropertyTypePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyTypePref[] = $item;
        return $this;
    }
    /**
     * Get PropertyClassPref value
     * @return mixed[]|null
     */
    public function getPropertyClassPref()
    {
        return $this->PropertyClassPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyClassPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyClassPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyClassPrefForArrayConstraintsFromSetPropertyClassPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePropertyClassPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePropertyClassPrefItem) ? get_class($hotelPrefTypePropertyClassPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePropertyClassPrefItem), var_export($hotelPrefTypePropertyClassPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyClassPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyClassPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $propertyClassPref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyClassPref(array $propertyClassPref = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyClassPrefArrayErrorMessage = self::validatePropertyClassPrefForArrayConstraintsFromSetPropertyClassPref($propertyClassPref))) {
            throw new \InvalidArgumentException($propertyClassPrefArrayErrorMessage, __LINE__);
        }
        $this->PropertyClassPref = $propertyClassPref;
        return $this;
    }
    /**
     * Add item to PropertyClassPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyClassPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PropertyClassPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyClassPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyAmenityPref value
     * @return mixed[]|null
     */
    public function getPropertyAmenityPref()
    {
        return $this->PropertyAmenityPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyAmenityPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyAmenityPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyAmenityPrefForArrayConstraintsFromSetPropertyAmenityPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePropertyAmenityPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePropertyAmenityPrefItem) ? get_class($hotelPrefTypePropertyAmenityPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePropertyAmenityPrefItem), var_export($hotelPrefTypePropertyAmenityPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyAmenityPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyAmenityPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $propertyAmenityPref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyAmenityPref(array $propertyAmenityPref = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyAmenityPrefArrayErrorMessage = self::validatePropertyAmenityPrefForArrayConstraintsFromSetPropertyAmenityPref($propertyAmenityPref))) {
            throw new \InvalidArgumentException($propertyAmenityPrefArrayErrorMessage, __LINE__);
        }
        $this->PropertyAmenityPref = $propertyAmenityPref;
        return $this;
    }
    /**
     * Add item to PropertyAmenityPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyAmenityPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PropertyAmenityPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyAmenityPref[] = $item;
        return $this;
    }
    /**
     * Get RoomAmenityPref value
     * @return mixed[]|null
     */
    public function getRoomAmenityPref()
    {
        return $this->RoomAmenityPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomAmenityPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomAmenityPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomAmenityPrefForArrayConstraintsFromSetRoomAmenityPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeRoomAmenityPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeRoomAmenityPrefItem) ? get_class($hotelPrefTypeRoomAmenityPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeRoomAmenityPrefItem), var_export($hotelPrefTypeRoomAmenityPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomAmenityPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomAmenityPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $roomAmenityPref
     * @return \StructType\HotelPrefType
     */
    public function setRoomAmenityPref(array $roomAmenityPref = array())
    {
        // validation for constraint: array
        if ('' !== ($roomAmenityPrefArrayErrorMessage = self::validateRoomAmenityPrefForArrayConstraintsFromSetRoomAmenityPref($roomAmenityPref))) {
            throw new \InvalidArgumentException($roomAmenityPrefArrayErrorMessage, __LINE__);
        }
        $this->RoomAmenityPref = $roomAmenityPref;
        return $this;
    }
    /**
     * Add item to RoomAmenityPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToRoomAmenityPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenityPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomAmenityPref[] = $item;
        return $this;
    }
    /**
     * Get RoomLocationPref value
     * @return mixed[]|null
     */
    public function getRoomLocationPref()
    {
        return $this->RoomLocationPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomLocationPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomLocationPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomLocationPrefForArrayConstraintsFromSetRoomLocationPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeRoomLocationPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeRoomLocationPrefItem) ? get_class($hotelPrefTypeRoomLocationPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeRoomLocationPrefItem), var_export($hotelPrefTypeRoomLocationPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomLocationPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomLocationPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $roomLocationPref
     * @return \StructType\HotelPrefType
     */
    public function setRoomLocationPref(array $roomLocationPref = array())
    {
        // validation for constraint: array
        if ('' !== ($roomLocationPrefArrayErrorMessage = self::validateRoomLocationPrefForArrayConstraintsFromSetRoomLocationPref($roomLocationPref))) {
            throw new \InvalidArgumentException($roomLocationPrefArrayErrorMessage, __LINE__);
        }
        $this->RoomLocationPref = $roomLocationPref;
        return $this;
    }
    /**
     * Add item to RoomLocationPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToRoomLocationPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RoomLocationPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomLocationPref[] = $item;
        return $this;
    }
    /**
     * Get BedTypePref value
     * @return mixed[]|null
     */
    public function getBedTypePref()
    {
        return $this->BedTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setBedTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedTypePrefForArrayConstraintsFromSetBedTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeBedTypePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeBedTypePrefItem) ? get_class($hotelPrefTypeBedTypePrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeBedTypePrefItem), var_export($hotelPrefTypeBedTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BedTypePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BedTypePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $bedTypePref
     * @return \StructType\HotelPrefType
     */
    public function setBedTypePref(array $bedTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($bedTypePrefArrayErrorMessage = self::validateBedTypePrefForArrayConstraintsFromSetBedTypePref($bedTypePref))) {
            throw new \InvalidArgumentException($bedTypePrefArrayErrorMessage, __LINE__);
        }
        $this->BedTypePref = $bedTypePref;
        return $this;
    }
    /**
     * Add item to BedTypePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToBedTypePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The BedTypePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BedTypePref[] = $item;
        return $this;
    }
    /**
     * Get FoodSrvcPref value
     * @return mixed[]|null
     */
    public function getFoodSrvcPref()
    {
        return $this->FoodSrvcPref;
    }
    /**
     * This method is responsible for validating the values passed to the setFoodSrvcPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFoodSrvcPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFoodSrvcPrefForArrayConstraintsFromSetFoodSrvcPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeFoodSrvcPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeFoodSrvcPrefItem) ? get_class($hotelPrefTypeFoodSrvcPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeFoodSrvcPrefItem), var_export($hotelPrefTypeFoodSrvcPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FoodSrvcPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FoodSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $foodSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setFoodSrvcPref(array $foodSrvcPref = array())
    {
        // validation for constraint: array
        if ('' !== ($foodSrvcPrefArrayErrorMessage = self::validateFoodSrvcPrefForArrayConstraintsFromSetFoodSrvcPref($foodSrvcPref))) {
            throw new \InvalidArgumentException($foodSrvcPrefArrayErrorMessage, __LINE__);
        }
        $this->FoodSrvcPref = $foodSrvcPref;
        return $this;
    }
    /**
     * Add item to FoodSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToFoodSrvcPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The FoodSrvcPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FoodSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return mixed[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEntertainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEntertainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeMediaEntertainPrefItem) ? get_class($hotelPrefTypeMediaEntertainPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeMediaEntertainPrefItem), var_export($hotelPrefTypeMediaEntertainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaEntertainPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $mediaEntertainPref
     * @return \StructType\HotelPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaEntertainPrefArrayErrorMessage = self::validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref($mediaEntertainPref))) {
            throw new \InvalidArgumentException($mediaEntertainPrefArrayErrorMessage, __LINE__);
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToMediaEntertainPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return mixed[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfoPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfoPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePetInfoPrefItem) ? get_class($hotelPrefTypePetInfoPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePetInfoPrefItem), var_export($hotelPrefTypePetInfoPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfoPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $petInfoPref
     * @return \StructType\HotelPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoPrefArrayErrorMessage = self::validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref($petInfoPref))) {
            throw new \InvalidArgumentException($petInfoPrefArrayErrorMessage, __LINE__);
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPetInfoPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return mixed[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPrefForArrayConstraintsFromSetMealPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeMealPrefItem) ? get_class($hotelPrefTypeMealPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeMealPrefItem), var_export($hotelPrefTypeMealPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $mealPref
     * @return \StructType\HotelPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPrefArrayErrorMessage = self::validateMealPrefForArrayConstraintsFromSetMealPref($mealPref))) {
            throw new \InvalidArgumentException($mealPrefArrayErrorMessage, __LINE__);
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToMealPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get RecreationSrvcPref value
     * @return mixed[]|null
     */
    public function getRecreationSrvcPref()
    {
        return $this->RecreationSrvcPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRecreationSrvcPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecreationSrvcPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecreationSrvcPrefForArrayConstraintsFromSetRecreationSrvcPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeRecreationSrvcPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeRecreationSrvcPrefItem) ? get_class($hotelPrefTypeRecreationSrvcPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeRecreationSrvcPrefItem), var_export($hotelPrefTypeRecreationSrvcPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecreationSrvcPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecreationSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $recreationSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setRecreationSrvcPref(array $recreationSrvcPref = array())
    {
        // validation for constraint: array
        if ('' !== ($recreationSrvcPrefArrayErrorMessage = self::validateRecreationSrvcPrefForArrayConstraintsFromSetRecreationSrvcPref($recreationSrvcPref))) {
            throw new \InvalidArgumentException($recreationSrvcPrefArrayErrorMessage, __LINE__);
        }
        $this->RecreationSrvcPref = $recreationSrvcPref;
        return $this;
    }
    /**
     * Add item to RecreationSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToRecreationSrvcPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RecreationSrvcPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecreationSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get BusinessSrvcPref value
     * @return mixed[]|null
     */
    public function getBusinessSrvcPref()
    {
        return $this->BusinessSrvcPref;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessSrvcPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessSrvcPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessSrvcPrefForArrayConstraintsFromSetBusinessSrvcPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeBusinessSrvcPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeBusinessSrvcPrefItem) ? get_class($hotelPrefTypeBusinessSrvcPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeBusinessSrvcPrefItem), var_export($hotelPrefTypeBusinessSrvcPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessSrvcPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $businessSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setBusinessSrvcPref(array $businessSrvcPref = array())
    {
        // validation for constraint: array
        if ('' !== ($businessSrvcPrefArrayErrorMessage = self::validateBusinessSrvcPrefForArrayConstraintsFromSetBusinessSrvcPref($businessSrvcPref))) {
            throw new \InvalidArgumentException($businessSrvcPrefArrayErrorMessage, __LINE__);
        }
        $this->BusinessSrvcPref = $businessSrvcPref;
        return $this;
    }
    /**
     * Add item to BusinessSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToBusinessSrvcPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The BusinessSrvcPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get PersonalSrvcPref value
     * @return mixed[]|null
     */
    public function getPersonalSrvcPref()
    {
        return $this->PersonalSrvcPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonalSrvcPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonalSrvcPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonalSrvcPrefForArrayConstraintsFromSetPersonalSrvcPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePersonalSrvcPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePersonalSrvcPrefItem) ? get_class($hotelPrefTypePersonalSrvcPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePersonalSrvcPrefItem), var_export($hotelPrefTypePersonalSrvcPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonalSrvcPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonalSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $personalSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setPersonalSrvcPref(array $personalSrvcPref = array())
    {
        // validation for constraint: array
        if ('' !== ($personalSrvcPrefArrayErrorMessage = self::validatePersonalSrvcPrefForArrayConstraintsFromSetPersonalSrvcPref($personalSrvcPref))) {
            throw new \InvalidArgumentException($personalSrvcPrefArrayErrorMessage, __LINE__);
        }
        $this->PersonalSrvcPref = $personalSrvcPref;
        return $this;
    }
    /**
     * Add item to PersonalSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPersonalSrvcPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PersonalSrvcPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonalSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get SecurityFeaturePref value
     * @return mixed[]|null
     */
    public function getSecurityFeaturePref()
    {
        return $this->SecurityFeaturePref;
    }
    /**
     * This method is responsible for validating the values passed to the setSecurityFeaturePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecurityFeaturePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSecurityFeaturePrefForArrayConstraintsFromSetSecurityFeaturePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeSecurityFeaturePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeSecurityFeaturePrefItem) ? get_class($hotelPrefTypeSecurityFeaturePrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeSecurityFeaturePrefItem), var_export($hotelPrefTypeSecurityFeaturePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SecurityFeaturePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SecurityFeaturePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $securityFeaturePref
     * @return \StructType\HotelPrefType
     */
    public function setSecurityFeaturePref(array $securityFeaturePref = array())
    {
        // validation for constraint: array
        if ('' !== ($securityFeaturePrefArrayErrorMessage = self::validateSecurityFeaturePrefForArrayConstraintsFromSetSecurityFeaturePref($securityFeaturePref))) {
            throw new \InvalidArgumentException($securityFeaturePrefArrayErrorMessage, __LINE__);
        }
        $this->SecurityFeaturePref = $securityFeaturePref;
        return $this;
    }
    /**
     * Add item to SecurityFeaturePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToSecurityFeaturePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SecurityFeaturePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SecurityFeaturePref[] = $item;
        return $this;
    }
    /**
     * Get PhysChallFeaturePref value
     * @return mixed[]|null
     */
    public function getPhysChallFeaturePref()
    {
        return $this->PhysChallFeaturePref;
    }
    /**
     * This method is responsible for validating the values passed to the setPhysChallFeaturePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysChallFeaturePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhysChallFeaturePrefForArrayConstraintsFromSetPhysChallFeaturePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypePhysChallFeaturePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypePhysChallFeaturePrefItem) ? get_class($hotelPrefTypePhysChallFeaturePrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypePhysChallFeaturePrefItem), var_export($hotelPrefTypePhysChallFeaturePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhysChallFeaturePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhysChallFeaturePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $physChallFeaturePref
     * @return \StructType\HotelPrefType
     */
    public function setPhysChallFeaturePref(array $physChallFeaturePref = array())
    {
        // validation for constraint: array
        if ('' !== ($physChallFeaturePrefArrayErrorMessage = self::validatePhysChallFeaturePrefForArrayConstraintsFromSetPhysChallFeaturePref($physChallFeaturePref))) {
            throw new \InvalidArgumentException($physChallFeaturePrefArrayErrorMessage, __LINE__);
        }
        $this->PhysChallFeaturePref = $physChallFeaturePref;
        return $this;
    }
    /**
     * Add item to PhysChallFeaturePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToPhysChallFeaturePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PhysChallFeaturePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhysChallFeaturePref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return mixed[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecRequestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecRequestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelPrefTypeSpecRequestPrefItem) ? get_class($hotelPrefTypeSpecRequestPrefItem) : sprintf('%s(%s)', gettype($hotelPrefTypeSpecRequestPrefItem), var_export($hotelPrefTypeSpecRequestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $specRequestPref
     * @return \StructType\HotelPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specRequestPrefArrayErrorMessage = self::validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref($specRequestPref))) {
            throw new \InvalidArgumentException($specRequestPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelPrefType
     */
    public function addToSpecRequestPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\HotelPrefType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\HotelPrefType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get HotelGuestType value
     * @return string|null
     */
    public function getHotelGuestType()
    {
        return $this->HotelGuestType;
    }
    /**
     * Set HotelGuestType value
     * @param string $hotelGuestType
     * @return \StructType\HotelPrefType
     */
    public function setHotelGuestType($hotelGuestType = null)
    {
        // validation for constraint: string
        if (!is_null($hotelGuestType) && !is_string($hotelGuestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelGuestType, true), gettype($hotelGuestType)), __LINE__);
        }
        $this->HotelGuestType = $hotelGuestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
