<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDescriptiveContents StructType
 * Meta information extracted from the WSDL
 * - documentation: The hotel reference identifies a specific hotel by using the chain code, the brand code, and the hotel code. The codes used are agreed upon by trading partners. | Collection of hotel descriptive contents.
 * @subpackage Structs
 */
class HotelDescriptiveContents extends AbstractStructBase
{
    /**
     * The HotelDescriptiveContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\HotelDescriptiveContent[]
     */
    public $HotelDescriptiveContent;
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * @var string
     */
    public $BrandName;
    /**
     * The AreaID
     * @var string
     */
    public $AreaID;
    /**
     * The TTIcode
     * @var int
     */
    public $TTIcode;
    /**
     * Constructor method for HotelDescriptiveContents
     * @uses HotelDescriptiveContents::setHotelDescriptiveContent()
     * @uses HotelDescriptiveContents::setChainCode()
     * @uses HotelDescriptiveContents::setBrandCode()
     * @uses HotelDescriptiveContents::setHotelCode()
     * @uses HotelDescriptiveContents::setHotelCityCode()
     * @uses HotelDescriptiveContents::setHotelName()
     * @uses HotelDescriptiveContents::setHotelCodeContext()
     * @uses HotelDescriptiveContents::setChainName()
     * @uses HotelDescriptiveContents::setBrandName()
     * @uses HotelDescriptiveContents::setAreaID()
     * @uses HotelDescriptiveContents::setTTIcode()
     * @param \StructType\HotelDescriptiveContent[] $hotelDescriptiveContent
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $areaID
     * @param int $tTIcode
     */
    public function __construct(array $hotelDescriptiveContent = array(), $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $areaID = null, $tTIcode = null)
    {
        $this
            ->setHotelDescriptiveContent($hotelDescriptiveContent)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setAreaID($areaID)
            ->setTTIcode($tTIcode);
    }
    /**
     * Get HotelDescriptiveContent value
     * @return \StructType\HotelDescriptiveContent[]|null
     */
    public function getHotelDescriptiveContent()
    {
        return $this->HotelDescriptiveContent;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelDescriptiveContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelDescriptiveContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelDescriptiveContentForArrayConstraintsFromSetHotelDescriptiveContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelDescriptiveContentsHotelDescriptiveContentItem) {
            // validation for constraint: itemType
            if (!$hotelDescriptiveContentsHotelDescriptiveContentItem instanceof \StructType\HotelDescriptiveContent) {
                $invalidValues[] = is_object($hotelDescriptiveContentsHotelDescriptiveContentItem) ? get_class($hotelDescriptiveContentsHotelDescriptiveContentItem) : sprintf('%s(%s)', gettype($hotelDescriptiveContentsHotelDescriptiveContentItem), var_export($hotelDescriptiveContentsHotelDescriptiveContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelDescriptiveContent property can only contain items of type \StructType\HotelDescriptiveContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelDescriptiveContent[] $hotelDescriptiveContent
     * @return \StructType\HotelDescriptiveContents
     */
    public function setHotelDescriptiveContent(array $hotelDescriptiveContent = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelDescriptiveContentArrayErrorMessage = self::validateHotelDescriptiveContentForArrayConstraintsFromSetHotelDescriptiveContent($hotelDescriptiveContent))) {
            throw new \InvalidArgumentException($hotelDescriptiveContentArrayErrorMessage, __LINE__);
        }
        $this->HotelDescriptiveContent = $hotelDescriptiveContent;
        return $this;
    }
    /**
     * Add item to HotelDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelDescriptiveContent $item
     * @return \StructType\HotelDescriptiveContents
     */
    public function addToHotelDescriptiveContent(\StructType\HotelDescriptiveContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelDescriptiveContent) {
            throw new \InvalidArgumentException(sprintf('The HotelDescriptiveContent property can only contain items of type \StructType\HotelDescriptiveContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelDescriptiveContent[] = $item;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\HotelDescriptiveContents
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\HotelDescriptiveContents
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelDescriptiveContents
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \StructType\HotelDescriptiveContents
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCityCode, true), gettype($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelDescriptiveContents
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\HotelDescriptiveContents
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \StructType\HotelDescriptiveContents
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainName, true), gettype($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\HotelDescriptiveContents
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\HotelDescriptiveContents
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get TTIcode value
     * @return int|null
     */
    public function getTTIcode()
    {
        return $this->TTIcode;
    }
    /**
     * Set TTIcode value
     * @param int $tTIcode
     * @return \StructType\HotelDescriptiveContents
     */
    public function setTTIcode($tTIcode = null)
    {
        // validation for constraint: int
        if (!is_null($tTIcode) && !(is_int($tTIcode) || ctype_digit($tTIcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tTIcode, true), gettype($tTIcode)), __LINE__);
        }
        $this->TTIcode = $tTIcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelDescriptiveContents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
