<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guests StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Guest. | Collection of guests.
 * @subpackage Structs
 */
class Guests extends AbstractStructBase
{
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Guest[]
     */
    public $Guest;
    /**
     * Constructor method for Guests
     * @uses Guests::setGuest()
     * @param \StructType\Guest[] $guest
     */
    public function __construct(array $guest = array())
    {
        $this
            ->setGuest($guest);
    }
    /**
     * Get Guest value
     * @return \StructType\Guest[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestForArrayConstraintsFromSetGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestsGuestItem) {
            // validation for constraint: itemType
            if (!$guestsGuestItem instanceof \StructType\Guest) {
                $invalidValues[] = is_object($guestsGuestItem) ? get_class($guestsGuestItem) : sprintf('%s(%s)', gettype($guestsGuestItem), var_export($guestsGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest property can only contain items of type \StructType\Guest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest[] $guest
     * @return \StructType\Guests
     */
    public function setGuest(array $guest = array())
    {
        // validation for constraint: array
        if ('' !== ($guestArrayErrorMessage = self::validateGuestForArrayConstraintsFromSetGuest($guest))) {
            throw new \InvalidArgumentException($guestArrayErrorMessage, __LINE__);
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest $item
     * @return \StructType\Guests
     */
    public function addToGuest(\StructType\Guest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of type \StructType\Guest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Guests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
