<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information about the guest. | Provides information regarding the guest name and the guest's mode of transportation.
 * @subpackage Structs
 */
class GuestType extends AbstractStructBase
{
    /**
     * The GuestName
     * Meta information extracted from the WSDL
     * - documentation: Name of the guest.
     * - minOccurs: 0
     * @var mixed
     */
    public $GuestName;
    /**
     * The GuestTransportation
     * Meta information extracted from the WSDL
     * - documentation: Selected guest mode of transportation.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $GuestTransportation;
    /**
     * Constructor method for GuestType
     * @uses GuestType::setGuestName()
     * @uses GuestType::setGuestTransportation()
     * @param mixed $guestName
     * @param mixed[] $guestTransportation
     */
    public function __construct($guestName = null, array $guestTransportation = array())
    {
        $this
            ->setGuestName($guestName)
            ->setGuestTransportation($guestTransportation);
    }
    /**
     * Get GuestName value
     * @return mixed|null
     */
    public function getGuestName()
    {
        return $this->GuestName;
    }
    /**
     * Set GuestName value
     * @param mixed $guestName
     * @return \StructType\GuestType
     */
    public function setGuestName($guestName = null)
    {
        $this->GuestName = $guestName;
        return $this;
    }
    /**
     * Get GuestTransportation value
     * @return mixed[]|null
     */
    public function getGuestTransportation()
    {
        return $this->GuestTransportation;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestTransportation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestTransportation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestTransportationForArrayConstraintsFromSetGuestTransportation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestTypeGuestTransportationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($guestTypeGuestTransportationItem) ? get_class($guestTypeGuestTransportationItem) : sprintf('%s(%s)', gettype($guestTypeGuestTransportationItem), var_export($guestTypeGuestTransportationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestTransportation property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestTransportation value
     * @throws \InvalidArgumentException
     * @param mixed[] $guestTransportation
     * @return \StructType\GuestType
     */
    public function setGuestTransportation(array $guestTransportation = array())
    {
        // validation for constraint: array
        if ('' !== ($guestTransportationArrayErrorMessage = self::validateGuestTransportationForArrayConstraintsFromSetGuestTransportation($guestTransportation))) {
            throw new \InvalidArgumentException($guestTransportationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($guestTransportation) && count($guestTransportation) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($guestTransportation)), __LINE__);
        }
        $this->GuestTransportation = $guestTransportation;
        return $this;
    }
    /**
     * Add item to GuestTransportation value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\GuestType
     */
    public function addToGuestTransportation($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The GuestTransportation property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->GuestTransportation) && count($this->GuestTransportation) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->GuestTransportation)), __LINE__);
        }
        $this->GuestTransportation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
