<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestRooms StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of guest room types that are comprised within the hotel.
 * @subpackage Structs
 */
class GuestRooms extends AbstractStructBase
{
    /**
     * The GuestRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestRoom[]
     */
    public $GuestRoom;
    /**
     * The MaxOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of guests the hotel can accommodate at one time.
     * - use: optional
     * @var int
     */
    public $MaxOccupancy;
    /**
     * Constructor method for GuestRooms
     * @uses GuestRooms::setGuestRoom()
     * @uses GuestRooms::setMaxOccupancy()
     * @param \StructType\GuestRoom[] $guestRoom
     * @param int $maxOccupancy
     */
    public function __construct(array $guestRoom = array(), $maxOccupancy = null)
    {
        $this
            ->setGuestRoom($guestRoom)
            ->setMaxOccupancy($maxOccupancy);
    }
    /**
     * Get GuestRoom value
     * @return \StructType\GuestRoom[]|null
     */
    public function getGuestRoom()
    {
        return $this->GuestRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestRoomForArrayConstraintsFromSetGuestRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRoomsGuestRoomItem) {
            // validation for constraint: itemType
            if (!$guestRoomsGuestRoomItem instanceof \StructType\GuestRoom) {
                $invalidValues[] = is_object($guestRoomsGuestRoomItem) ? get_class($guestRoomsGuestRoomItem) : sprintf('%s(%s)', gettype($guestRoomsGuestRoomItem), var_export($guestRoomsGuestRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestRoom property can only contain items of type \StructType\GuestRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRoom[] $guestRoom
     * @return \StructType\GuestRooms
     */
    public function setGuestRoom(array $guestRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($guestRoomArrayErrorMessage = self::validateGuestRoomForArrayConstraintsFromSetGuestRoom($guestRoom))) {
            throw new \InvalidArgumentException($guestRoomArrayErrorMessage, __LINE__);
        }
        $this->GuestRoom = $guestRoom;
        return $this;
    }
    /**
     * Add item to GuestRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRoom $item
     * @return \StructType\GuestRooms
     */
    public function addToGuestRoom(\StructType\GuestRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestRoom) {
            throw new \InvalidArgumentException(sprintf('The GuestRoom property can only contain items of type \StructType\GuestRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestRoom[] = $item;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\GuestRooms
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestRooms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
