<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the guests' information.
 * @subpackage Structs
 */
class GuestDetails extends AbstractStructBase
{
    /**
     * The GuestDetail
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Guest information.
     * - maxOccurs: 9
     * @var mixed[]
     */
    public $GuestDetail;
    /**
     * Constructor method for GuestDetails
     * @uses GuestDetails::setGuestDetail()
     * @param mixed[] $guestDetail
     */
    public function __construct(array $guestDetail = array())
    {
        $this
            ->setGuestDetail($guestDetail);
    }
    /**
     * Get GuestDetail value
     * @return mixed[]|null
     */
    public function getGuestDetail()
    {
        return $this->GuestDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestDetailForArrayConstraintsFromSetGuestDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestDetailsGuestDetailItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($guestDetailsGuestDetailItem) ? get_class($guestDetailsGuestDetailItem) : sprintf('%s(%s)', gettype($guestDetailsGuestDetailItem), var_export($guestDetailsGuestDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestDetail property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestDetail value
     * @throws \InvalidArgumentException
     * @param mixed[] $guestDetail
     * @return \StructType\GuestDetails
     */
    public function setGuestDetail(array $guestDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($guestDetailArrayErrorMessage = self::validateGuestDetailForArrayConstraintsFromSetGuestDetail($guestDetail))) {
            throw new \InvalidArgumentException($guestDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($guestDetail) && count($guestDetail) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($guestDetail)), __LINE__);
        }
        $this->GuestDetail = $guestDetail;
        return $this;
    }
    /**
     * Add item to GuestDetail value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\GuestDetails
     */
    public function addToGuestDetail($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The GuestDetail property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->GuestDetail) && count($this->GuestDetail) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->GuestDetail)), __LINE__);
        }
        $this->GuestDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
