<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest StructType
 * Meta information extracted from the WSDL
 * - documentation: A person staying in a room. | Specifies the age requirements for this offer. | Defines the guest(s) to which the offer applies.
 * @subpackage Structs
 */
class Guest extends ContactPersonType
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The confirmation number for a particular guest. This is used with the 'GuestAction' attribute value of 'Add-Update' to indicate an update.
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The Loyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Loyalty[]
     */
    public $Loyalty;
    /**
     * The GuaranteePayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\GuaranteePayment[]
     */
    public $GuaranteePayment;
    /**
     * The AdditionalDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $AdditionalDetails;
    /**
     * The GuestAction
     * Meta information extracted from the WSDL
     * - documentation: This attributes indicates the change in status of the guest.
     * - use: optional
     * @var string
     */
    public $GuestAction;
    /**
     * The PrintConfoInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether to send the printed confirmation.
     * - use: optional
     * @var bool
     */
    public $PrintConfoInd;
    /**
     * The MinCount
     * Meta information extracted from the WSDL
     * - documentation: Minimum number of guests of this age group needed to qualify for this offer.
     * - use: optional
     * @var int
     */
    public $MinCount;
    /**
     * The MaxCount
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of guests of this age group allowed to qualify for this offer.
     * - use: optional
     * @var int
     */
    public $MaxCount;
    /**
     * The FirstQualifyingPosition
     * Meta information extracted from the WSDL
     * - documentation: First person in this age group to which this offer applies.
     * - use: optional
     * @var int
     */
    public $FirstQualifyingPosition;
    /**
     * The LastQualifyingPosition
     * Meta information extracted from the WSDL
     * - documentation: Last person in this age group to which this offer applies.
     * - use: optional
     * @var int
     */
    public $LastQualifyingPosition;
    /**
     * Constructor method for Guest
     * @uses Guest::setUniqueID()
     * @uses Guest::setLoyalty()
     * @uses Guest::setGuaranteePayment()
     * @uses Guest::setAdditionalDetails()
     * @uses Guest::setGuestAction()
     * @uses Guest::setPrintConfoInd()
     * @uses Guest::setMinCount()
     * @uses Guest::setMaxCount()
     * @uses Guest::setFirstQualifyingPosition()
     * @uses Guest::setLastQualifyingPosition()
     * @param mixed $uniqueID
     * @param \StructType\Loyalty[] $loyalty
     * @param \StructType\GuaranteePayment[] $guaranteePayment
     * @param mixed $additionalDetails
     * @param string $guestAction
     * @param bool $printConfoInd
     * @param int $minCount
     * @param int $maxCount
     * @param int $firstQualifyingPosition
     * @param int $lastQualifyingPosition
     */
    public function __construct($uniqueID = null, array $loyalty = array(), array $guaranteePayment = array(), $additionalDetails = null, $guestAction = null, $printConfoInd = null, $minCount = null, $maxCount = null, $firstQualifyingPosition = null, $lastQualifyingPosition = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setLoyalty($loyalty)
            ->setGuaranteePayment($guaranteePayment)
            ->setAdditionalDetails($additionalDetails)
            ->setGuestAction($guestAction)
            ->setPrintConfoInd($printConfoInd)
            ->setMinCount($minCount)
            ->setMaxCount($maxCount)
            ->setFirstQualifyingPosition($firstQualifyingPosition)
            ->setLastQualifyingPosition($lastQualifyingPosition);
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\Guest
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Loyalty value
     * @return \StructType\Loyalty[]|null
     */
    public function getLoyalty()
    {
        return $this->Loyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyForArrayConstraintsFromSetLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestLoyaltyItem) {
            // validation for constraint: itemType
            if (!$guestLoyaltyItem instanceof \StructType\Loyalty) {
                $invalidValues[] = is_object($guestLoyaltyItem) ? get_class($guestLoyaltyItem) : sprintf('%s(%s)', gettype($guestLoyaltyItem), var_export($guestLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Loyalty property can only contain items of type \StructType\Loyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Loyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\Loyalty[] $loyalty
     * @return \StructType\Guest
     */
    public function setLoyalty(array $loyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyArrayErrorMessage = self::validateLoyaltyForArrayConstraintsFromSetLoyalty($loyalty))) {
            throw new \InvalidArgumentException($loyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($loyalty) && count($loyalty) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($loyalty)), __LINE__);
        }
        $this->Loyalty = $loyalty;
        return $this;
    }
    /**
     * Add item to Loyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\Loyalty $item
     * @return \StructType\Guest
     */
    public function addToLoyalty(\StructType\Loyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Loyalty) {
            throw new \InvalidArgumentException(sprintf('The Loyalty property can only contain items of type \StructType\Loyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Loyalty) && count($this->Loyalty) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Loyalty)), __LINE__);
        }
        $this->Loyalty[] = $item;
        return $this;
    }
    /**
     * Get GuaranteePayment value
     * @return \StructType\GuaranteePayment[]|null
     */
    public function getGuaranteePayment()
    {
        return $this->GuaranteePayment;
    }
    /**
     * This method is responsible for validating the values passed to the setGuaranteePayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuaranteePayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteePaymentForArrayConstraintsFromSetGuaranteePayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestGuaranteePaymentItem) {
            // validation for constraint: itemType
            if (!$guestGuaranteePaymentItem instanceof \StructType\GuaranteePayment) {
                $invalidValues[] = is_object($guestGuaranteePaymentItem) ? get_class($guestGuaranteePaymentItem) : sprintf('%s(%s)', gettype($guestGuaranteePaymentItem), var_export($guestGuaranteePaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuaranteePayment property can only contain items of type \StructType\GuaranteePayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuaranteePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteePayment[] $guaranteePayment
     * @return \StructType\Guest
     */
    public function setGuaranteePayment(array $guaranteePayment = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteePaymentArrayErrorMessage = self::validateGuaranteePaymentForArrayConstraintsFromSetGuaranteePayment($guaranteePayment))) {
            throw new \InvalidArgumentException($guaranteePaymentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($guaranteePayment) && count($guaranteePayment) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($guaranteePayment)), __LINE__);
        }
        $this->GuaranteePayment = $guaranteePayment;
        return $this;
    }
    /**
     * Add item to GuaranteePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteePayment $item
     * @return \StructType\Guest
     */
    public function addToGuaranteePayment(\StructType\GuaranteePayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuaranteePayment) {
            throw new \InvalidArgumentException(sprintf('The GuaranteePayment property can only contain items of type \StructType\GuaranteePayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->GuaranteePayment) && count($this->GuaranteePayment) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->GuaranteePayment)), __LINE__);
        }
        $this->GuaranteePayment[] = $item;
        return $this;
    }
    /**
     * Get AdditionalDetails value
     * @return mixed|null
     */
    public function getAdditionalDetails()
    {
        return $this->AdditionalDetails;
    }
    /**
     * Set AdditionalDetails value
     * @param mixed $additionalDetails
     * @return \StructType\Guest
     */
    public function setAdditionalDetails($additionalDetails = null)
    {
        $this->AdditionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get GuestAction value
     * @return string|null
     */
    public function getGuestAction()
    {
        return $this->GuestAction;
    }
    /**
     * Set GuestAction value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guestAction
     * @return \StructType\Guest
     */
    public function setGuestAction($guestAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($guestAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($guestAction) ? implode(', ', $guestAction) : var_export($guestAction, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->GuestAction = $guestAction;
        return $this;
    }
    /**
     * Get PrintConfoInd value
     * @return bool|null
     */
    public function getPrintConfoInd()
    {
        return $this->PrintConfoInd;
    }
    /**
     * Set PrintConfoInd value
     * @param bool $printConfoInd
     * @return \StructType\Guest
     */
    public function setPrintConfoInd($printConfoInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($printConfoInd) && !is_bool($printConfoInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printConfoInd, true), gettype($printConfoInd)), __LINE__);
        }
        $this->PrintConfoInd = $printConfoInd;
        return $this;
    }
    /**
     * Get MinCount value
     * @return int|null
     */
    public function getMinCount()
    {
        return $this->MinCount;
    }
    /**
     * Set MinCount value
     * @param int $minCount
     * @return \StructType\Guest
     */
    public function setMinCount($minCount = null)
    {
        // validation for constraint: int
        if (!is_null($minCount) && !(is_int($minCount) || ctype_digit($minCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minCount, true), gettype($minCount)), __LINE__);
        }
        $this->MinCount = $minCount;
        return $this;
    }
    /**
     * Get MaxCount value
     * @return int|null
     */
    public function getMaxCount()
    {
        return $this->MaxCount;
    }
    /**
     * Set MaxCount value
     * @param int $maxCount
     * @return \StructType\Guest
     */
    public function setMaxCount($maxCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxCount) && !(is_int($maxCount) || ctype_digit($maxCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCount, true), gettype($maxCount)), __LINE__);
        }
        $this->MaxCount = $maxCount;
        return $this;
    }
    /**
     * Get FirstQualifyingPosition value
     * @return int|null
     */
    public function getFirstQualifyingPosition()
    {
        return $this->FirstQualifyingPosition;
    }
    /**
     * Set FirstQualifyingPosition value
     * @param int $firstQualifyingPosition
     * @return \StructType\Guest
     */
    public function setFirstQualifyingPosition($firstQualifyingPosition = null)
    {
        // validation for constraint: int
        if (!is_null($firstQualifyingPosition) && !(is_int($firstQualifyingPosition) || ctype_digit($firstQualifyingPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstQualifyingPosition, true), gettype($firstQualifyingPosition)), __LINE__);
        }
        $this->FirstQualifyingPosition = $firstQualifyingPosition;
        return $this;
    }
    /**
     * Get LastQualifyingPosition value
     * @return int|null
     */
    public function getLastQualifyingPosition()
    {
        return $this->LastQualifyingPosition;
    }
    /**
     * Set LastQualifyingPosition value
     * @param int $lastQualifyingPosition
     * @return \StructType\Guest
     */
    public function setLastQualifyingPosition($lastQualifyingPosition = null)
    {
        // validation for constraint: int
        if (!is_null($lastQualifyingPosition) && !(is_int($lastQualifyingPosition) || ctype_digit($lastQualifyingPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastQualifyingPosition, true), gettype($lastQualifyingPosition)), __LINE__);
        }
        $this->LastQualifyingPosition = $lastQualifyingPosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Guest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
