<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePayment StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define the deposit policy, guarantees policy, and/or accepted forms of payment. | Guarantee or Payment information for an individual guest.
 * @subpackage Structs
 */
class GuaranteePayment extends HotelPaymentFormType
{
    /**
     * The DetailType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DetailType;
    /**
     * The GuaranteeType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var mixed
     */
    public $GuaranteeType;
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - documentation: Collection of forms of payment accepted for payment.
     * - minOccurs: 0
     * @var mixed
     */
    public $AcceptedPayments;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AmountPercent
     */
    public $AmountPercent;
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\Deadline[]
     */
    public $Deadline;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Text description of the Payment in a given language.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RetributionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var mixed
     */
    public $RetributionType;
    /**
     * The PaymentCode
     * Meta information extracted from the WSDL
     * - documentation: This defines the form of payment. Recommended usage of this is with the Payment Type in OpenTravel Code List, this datatype will be updated in the future. In order to maintain forward compatability a change is not being made in this
     * publication. This will be corrected in a future version, when a major update is released.
     * - use: optional
     * @var string
     */
    public $PaymentCode;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The GuaranteeCode
     * Meta information extracted from the WSDL
     * - documentation: Guarantee Code
     * - use: optional
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The HoldTime
     * Meta information extracted from the WSDL
     * - documentation: The room will held up until this time without a guarantee.
     * - use: optional
     * @var string
     */
    public $HoldTime;
    /**
     * The NoCardHolderInfoReqInd
     * Meta information extracted from the WSDL
     * - documentation: If true, no credit cardholder information is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $NoCardHolderInfoReqInd;
    /**
     * The NameInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the credit cardholder name is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $NameInd;
    /**
     * The AddressInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the credit cardholder address is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $AddressInd;
    /**
     * The PhoneInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the credit cardholder phone number is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $PhoneInd;
    /**
     * The InterbankNbrInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the Interbank Card Association number is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $InterbankNbrInd;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A system specific room type to which this guarantee payment information applies.
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: To specify the source of the rate of exchange for a currency code.
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The NonRefundableIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that any prepayment for the reservation is non refundable, therefore a 100% penalty on the prepayment is applied, irrespective of deadline.
     * - use: optional
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * The PolicyCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the type of payment policy.
     * - use: optional
     * @var string
     */
    public $PolicyCode;
    /**
     * The AgencyNameAddrReqInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the agency name and address are required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $AgencyNameAddrReqInd;
    /**
     * The CompanyNameAddrReqInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the company name and address are required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $CompanyNameAddrReqInd;
    /**
     * The NoCardHolderInfoRetainInd
     * Meta information extracted from the WSDL
     * - documentation: If true, no card holder information is retained.
     * - use: optional
     * @var bool
     */
    public $NoCardHolderInfoRetainInd;
    /**
     * The NameRetainInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the card holder's name is retained.
     * - use: optional
     * @var bool
     */
    public $NameRetainInd;
    /**
     * The AddressRetainInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the card holder's address is retained.
     * - use: optional
     * @var bool
     */
    public $AddressRetainInd;
    /**
     * The PhoneRetainInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the card holder's phone number is retained.
     * - use: optional
     * @var bool
     */
    public $PhoneRetainInd;
    /**
     * Constructor method for GuaranteePayment
     * @uses GuaranteePayment::setDetailType()
     * @uses GuaranteePayment::setGuaranteeType()
     * @uses GuaranteePayment::setAcceptedPayments()
     * @uses GuaranteePayment::setAmountPercent()
     * @uses GuaranteePayment::setDeadline()
     * @uses GuaranteePayment::setDescription()
     * @uses GuaranteePayment::setAddress()
     * @uses GuaranteePayment::setTPA_Extensions()
     * @uses GuaranteePayment::setRetributionType()
     * @uses GuaranteePayment::setPaymentCode()
     * @uses GuaranteePayment::setType()
     * @uses GuaranteePayment::setGuaranteeCode()
     * @uses GuaranteePayment::setHoldTime()
     * @uses GuaranteePayment::setNoCardHolderInfoReqInd()
     * @uses GuaranteePayment::setNameInd()
     * @uses GuaranteePayment::setAddressInd()
     * @uses GuaranteePayment::setPhoneInd()
     * @uses GuaranteePayment::setInterbankNbrInd()
     * @uses GuaranteePayment::setRoomTypeCode()
     * @uses GuaranteePayment::setInfoSource()
     * @uses GuaranteePayment::setNonRefundableIndicator()
     * @uses GuaranteePayment::setPolicyCode()
     * @uses GuaranteePayment::setAgencyNameAddrReqInd()
     * @uses GuaranteePayment::setCompanyNameAddrReqInd()
     * @uses GuaranteePayment::setNoCardHolderInfoRetainInd()
     * @uses GuaranteePayment::setNameRetainInd()
     * @uses GuaranteePayment::setAddressRetainInd()
     * @uses GuaranteePayment::setPhoneRetainInd()
     * @param string $detailType
     * @param mixed $guaranteeType
     * @param mixed $acceptedPayments
     * @param \StructType\AmountPercent $amountPercent
     * @param \StructType\Deadline[] $deadline
     * @param mixed[] $description
     * @param \StructType\Address[] $address
     * @param mixed $tPA_Extensions
     * @param mixed $retributionType
     * @param string $paymentCode
     * @param string $type
     * @param string $guaranteeCode
     * @param string $holdTime
     * @param bool $noCardHolderInfoReqInd
     * @param bool $nameInd
     * @param bool $addressInd
     * @param bool $phoneInd
     * @param bool $interbankNbrInd
     * @param string $roomTypeCode
     * @param string $infoSource
     * @param bool $nonRefundableIndicator
     * @param string $policyCode
     * @param bool $agencyNameAddrReqInd
     * @param bool $companyNameAddrReqInd
     * @param bool $noCardHolderInfoRetainInd
     * @param bool $nameRetainInd
     * @param bool $addressRetainInd
     * @param bool $phoneRetainInd
     */
    public function __construct($detailType = null, $guaranteeType = null, $acceptedPayments = null, \StructType\AmountPercent $amountPercent = null, array $deadline = array(), array $description = array(), array $address = array(), $tPA_Extensions = null, $retributionType = null, $paymentCode = null, $type = null, $guaranteeCode = null, $holdTime = null, $noCardHolderInfoReqInd = null, $nameInd = null, $addressInd = null, $phoneInd = null, $interbankNbrInd = null, $roomTypeCode = null, $infoSource = null, $nonRefundableIndicator = null, $policyCode = null, $agencyNameAddrReqInd = null, $companyNameAddrReqInd = null, $noCardHolderInfoRetainInd = null, $nameRetainInd = null, $addressRetainInd = null, $phoneRetainInd = null)
    {
        $this
            ->setDetailType($detailType)
            ->setGuaranteeType($guaranteeType)
            ->setAcceptedPayments($acceptedPayments)
            ->setAmountPercent($amountPercent)
            ->setDeadline($deadline)
            ->setDescription($description)
            ->setAddress($address)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRetributionType($retributionType)
            ->setPaymentCode($paymentCode)
            ->setType($type)
            ->setGuaranteeCode($guaranteeCode)
            ->setHoldTime($holdTime)
            ->setNoCardHolderInfoReqInd($noCardHolderInfoReqInd)
            ->setNameInd($nameInd)
            ->setAddressInd($addressInd)
            ->setPhoneInd($phoneInd)
            ->setInterbankNbrInd($interbankNbrInd)
            ->setRoomTypeCode($roomTypeCode)
            ->setInfoSource($infoSource)
            ->setNonRefundableIndicator($nonRefundableIndicator)
            ->setPolicyCode($policyCode)
            ->setAgencyNameAddrReqInd($agencyNameAddrReqInd)
            ->setCompanyNameAddrReqInd($companyNameAddrReqInd)
            ->setNoCardHolderInfoRetainInd($noCardHolderInfoRetainInd)
            ->setNameRetainInd($nameRetainInd)
            ->setAddressRetainInd($addressRetainInd)
            ->setPhoneRetainInd($phoneRetainInd);
    }
    /**
     * Get DetailType value
     * @return string|null
     */
    public function getDetailType()
    {
        return $this->DetailType;
    }
    /**
     * Set DetailType value
     * @param string $detailType
     * @return \StructType\GuaranteePayment
     */
    public function setDetailType($detailType = null)
    {
        // validation for constraint: string
        if (!is_null($detailType) && !is_string($detailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailType, true), gettype($detailType)), __LINE__);
        }
        $this->DetailType = $detailType;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return mixed|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param mixed $guaranteeType
     * @return \StructType\GuaranteePayment
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get AcceptedPayments value
     * @return mixed|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param mixed $acceptedPayments
     * @return \StructType\GuaranteePayment
     */
    public function setAcceptedPayments($acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \StructType\AmountPercent|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \StructType\AmountPercent $amountPercent
     * @return \StructType\GuaranteePayment
     */
    public function setAmountPercent(\StructType\AmountPercent $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline[]|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * This method is responsible for validating the values passed to the setDeadline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeadline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeadlineForArrayConstraintsFromSetDeadline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentDeadlineItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentDeadlineItem instanceof \StructType\Deadline) {
                $invalidValues[] = is_object($guaranteePaymentDeadlineItem) ? get_class($guaranteePaymentDeadlineItem) : sprintf('%s(%s)', gettype($guaranteePaymentDeadlineItem), var_export($guaranteePaymentDeadlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline[] $deadline
     * @return \StructType\GuaranteePayment
     */
    public function setDeadline(array $deadline = array())
    {
        // validation for constraint: array
        if ('' !== ($deadlineArrayErrorMessage = self::validateDeadlineForArrayConstraintsFromSetDeadline($deadline))) {
            throw new \InvalidArgumentException($deadlineArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($deadline) && count($deadline) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($deadline)), __LINE__);
        }
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Add item to Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline $item
     * @return \StructType\GuaranteePayment
     */
    public function addToDeadline(\StructType\Deadline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Deadline) {
            throw new \InvalidArgumentException(sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Deadline) && count($this->Deadline) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Deadline)), __LINE__);
        }
        $this->Deadline[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($guaranteePaymentDescriptionItem) ? get_class($guaranteePaymentDescriptionItem) : sprintf('%s(%s)', gettype($guaranteePaymentDescriptionItem), var_export($guaranteePaymentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\GuaranteePayment
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\GuaranteePayment
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentAddressItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($guaranteePaymentAddressItem) ? get_class($guaranteePaymentAddressItem) : sprintf('%s(%s)', gettype($guaranteePaymentAddressItem), var_export($guaranteePaymentAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\GuaranteePayment
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($address) && count($address) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\GuaranteePayment
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Address) && count($this->Address) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\GuaranteePayment
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return mixed|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param mixed $retributionType
     * @return \StructType\GuaranteePayment
     */
    public function setRetributionType($retributionType = null)
    {
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \StructType\GuaranteePayment
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\GuaranteePayment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get GuaranteeCode value
     * @return string|null
     */
    public function getGuaranteeCode()
    {
        return $this->GuaranteeCode;
    }
    /**
     * Set GuaranteeCode value
     * @param string $guaranteeCode
     * @return \StructType\GuaranteePayment
     */
    public function setGuaranteeCode($guaranteeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeCode) && !is_string($guaranteeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeCode, true), gettype($guaranteeCode)), __LINE__);
        }
        $this->GuaranteeCode = $guaranteeCode;
        return $this;
    }
    /**
     * Get HoldTime value
     * @return string|null
     */
    public function getHoldTime()
    {
        return $this->HoldTime;
    }
    /**
     * Set HoldTime value
     * @param string $holdTime
     * @return \StructType\GuaranteePayment
     */
    public function setHoldTime($holdTime = null)
    {
        // validation for constraint: string
        if (!is_null($holdTime) && !is_string($holdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdTime, true), gettype($holdTime)), __LINE__);
        }
        $this->HoldTime = $holdTime;
        return $this;
    }
    /**
     * Get NoCardHolderInfoReqInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoReqInd()
    {
        return $this->NoCardHolderInfoReqInd;
    }
    /**
     * Set NoCardHolderInfoReqInd value
     * @param bool $noCardHolderInfoReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setNoCardHolderInfoReqInd($noCardHolderInfoReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCardHolderInfoReqInd) && !is_bool($noCardHolderInfoReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noCardHolderInfoReqInd, true), gettype($noCardHolderInfoReqInd)), __LINE__);
        }
        $this->NoCardHolderInfoReqInd = $noCardHolderInfoReqInd;
        return $this;
    }
    /**
     * Get NameInd value
     * @return bool|null
     */
    public function getNameInd()
    {
        return $this->NameInd;
    }
    /**
     * Set NameInd value
     * @param bool $nameInd
     * @return \StructType\GuaranteePayment
     */
    public function setNameInd($nameInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nameInd) && !is_bool($nameInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nameInd, true), gettype($nameInd)), __LINE__);
        }
        $this->NameInd = $nameInd;
        return $this;
    }
    /**
     * Get AddressInd value
     * @return bool|null
     */
    public function getAddressInd()
    {
        return $this->AddressInd;
    }
    /**
     * Set AddressInd value
     * @param bool $addressInd
     * @return \StructType\GuaranteePayment
     */
    public function setAddressInd($addressInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressInd) && !is_bool($addressInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressInd, true), gettype($addressInd)), __LINE__);
        }
        $this->AddressInd = $addressInd;
        return $this;
    }
    /**
     * Get PhoneInd value
     * @return bool|null
     */
    public function getPhoneInd()
    {
        return $this->PhoneInd;
    }
    /**
     * Set PhoneInd value
     * @param bool $phoneInd
     * @return \StructType\GuaranteePayment
     */
    public function setPhoneInd($phoneInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneInd) && !is_bool($phoneInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneInd, true), gettype($phoneInd)), __LINE__);
        }
        $this->PhoneInd = $phoneInd;
        return $this;
    }
    /**
     * Get InterbankNbrInd value
     * @return bool|null
     */
    public function getInterbankNbrInd()
    {
        return $this->InterbankNbrInd;
    }
    /**
     * Set InterbankNbrInd value
     * @param bool $interbankNbrInd
     * @return \StructType\GuaranteePayment
     */
    public function setInterbankNbrInd($interbankNbrInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($interbankNbrInd) && !is_bool($interbankNbrInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interbankNbrInd, true), gettype($interbankNbrInd)), __LINE__);
        }
        $this->InterbankNbrInd = $interbankNbrInd;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\GuaranteePayment
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\GuaranteePayment
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \StructType\GuaranteePayment
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableIndicator) && !is_bool($nonRefundableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundableIndicator, true), gettype($nonRefundableIndicator)), __LINE__);
        }
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \StructType\GuaranteePayment
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyCode, true), gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get AgencyNameAddrReqInd value
     * @return bool|null
     */
    public function getAgencyNameAddrReqInd()
    {
        return $this->AgencyNameAddrReqInd;
    }
    /**
     * Set AgencyNameAddrReqInd value
     * @param bool $agencyNameAddrReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setAgencyNameAddrReqInd($agencyNameAddrReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($agencyNameAddrReqInd) && !is_bool($agencyNameAddrReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($agencyNameAddrReqInd, true), gettype($agencyNameAddrReqInd)), __LINE__);
        }
        $this->AgencyNameAddrReqInd = $agencyNameAddrReqInd;
        return $this;
    }
    /**
     * Get CompanyNameAddrReqInd value
     * @return bool|null
     */
    public function getCompanyNameAddrReqInd()
    {
        return $this->CompanyNameAddrReqInd;
    }
    /**
     * Set CompanyNameAddrReqInd value
     * @param bool $companyNameAddrReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setCompanyNameAddrReqInd($companyNameAddrReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($companyNameAddrReqInd) && !is_bool($companyNameAddrReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($companyNameAddrReqInd, true), gettype($companyNameAddrReqInd)), __LINE__);
        }
        $this->CompanyNameAddrReqInd = $companyNameAddrReqInd;
        return $this;
    }
    /**
     * Get NoCardHolderInfoRetainInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoRetainInd()
    {
        return $this->NoCardHolderInfoRetainInd;
    }
    /**
     * Set NoCardHolderInfoRetainInd value
     * @param bool $noCardHolderInfoRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setNoCardHolderInfoRetainInd($noCardHolderInfoRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCardHolderInfoRetainInd) && !is_bool($noCardHolderInfoRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noCardHolderInfoRetainInd, true), gettype($noCardHolderInfoRetainInd)), __LINE__);
        }
        $this->NoCardHolderInfoRetainInd = $noCardHolderInfoRetainInd;
        return $this;
    }
    /**
     * Get NameRetainInd value
     * @return bool|null
     */
    public function getNameRetainInd()
    {
        return $this->NameRetainInd;
    }
    /**
     * Set NameRetainInd value
     * @param bool $nameRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setNameRetainInd($nameRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nameRetainInd) && !is_bool($nameRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nameRetainInd, true), gettype($nameRetainInd)), __LINE__);
        }
        $this->NameRetainInd = $nameRetainInd;
        return $this;
    }
    /**
     * Get AddressRetainInd value
     * @return bool|null
     */
    public function getAddressRetainInd()
    {
        return $this->AddressRetainInd;
    }
    /**
     * Set AddressRetainInd value
     * @param bool $addressRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setAddressRetainInd($addressRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressRetainInd) && !is_bool($addressRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressRetainInd, true), gettype($addressRetainInd)), __LINE__);
        }
        $this->AddressRetainInd = $addressRetainInd;
        return $this;
    }
    /**
     * Get PhoneRetainInd value
     * @return bool|null
     */
    public function getPhoneRetainInd()
    {
        return $this->PhoneRetainInd;
    }
    /**
     * Set PhoneRetainInd value
     * @param bool $phoneRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setPhoneRetainInd($phoneRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneRetainInd) && !is_bool($phoneRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneRetainInd, true), gettype($phoneRetainInd)), __LINE__);
        }
        $this->PhoneRetainInd = $phoneRetainInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuaranteePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
