<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupPolicy StructType
 * Meta information extracted from the WSDL
 * - documentation: Group policy information.
 * @subpackage Structs
 */
class GroupPolicy extends AbstractStructBase
{
    /**
     * The ContractCurrency
     * Meta information extracted from the WSDL
     * - documentation: Example: usd | Currency used for contracts.
     * @var string
     */
    public $ContractCurrency;
    /**
     * The ContractLanguage
     * Meta information extracted from the WSDL
     * - documentation: Example: en | Language used for contract.
     * @var string
     */
    public $ContractLanguage;
    /**
     * The LocalDMC_Role
     * @var string
     */
    public $LocalDMC_Role;
    /**
     * The MaxGroupSize
     * Meta information extracted from the WSDL
     * - documentation: Example: 500 | Maximum number of people that the property will accept as a group.
     * @var int
     */
    public $MaxGroupSize;
    /**
     * Constructor method for GroupPolicy
     * @uses GroupPolicy::setContractCurrency()
     * @uses GroupPolicy::setContractLanguage()
     * @uses GroupPolicy::setLocalDMC_Role()
     * @uses GroupPolicy::setMaxGroupSize()
     * @param string $contractCurrency
     * @param string $contractLanguage
     * @param string $localDMC_Role
     * @param int $maxGroupSize
     */
    public function __construct($contractCurrency = null, $contractLanguage = null, $localDMC_Role = null, $maxGroupSize = null)
    {
        $this
            ->setContractCurrency($contractCurrency)
            ->setContractLanguage($contractLanguage)
            ->setLocalDMC_Role($localDMC_Role)
            ->setMaxGroupSize($maxGroupSize);
    }
    /**
     * Get ContractCurrency value
     * @return string|null
     */
    public function getContractCurrency()
    {
        return $this->ContractCurrency;
    }
    /**
     * Set ContractCurrency value
     * @param string $contractCurrency
     * @return \StructType\GroupPolicy
     */
    public function setContractCurrency($contractCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($contractCurrency) && !is_string($contractCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractCurrency, true), gettype($contractCurrency)), __LINE__);
        }
        $this->ContractCurrency = $contractCurrency;
        return $this;
    }
    /**
     * Get ContractLanguage value
     * @return string|null
     */
    public function getContractLanguage()
    {
        return $this->ContractLanguage;
    }
    /**
     * Set ContractLanguage value
     * @param string $contractLanguage
     * @return \StructType\GroupPolicy
     */
    public function setContractLanguage($contractLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($contractLanguage) && !is_string($contractLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractLanguage, true), gettype($contractLanguage)), __LINE__);
        }
        $this->ContractLanguage = $contractLanguage;
        return $this;
    }
    /**
     * Get LocalDMC_Role value
     * @return string|null
     */
    public function getLocalDMC_Role()
    {
        return $this->LocalDMC_Role;
    }
    /**
     * Set LocalDMC_Role value
     * @param string $localDMC_Role
     * @return \StructType\GroupPolicy
     */
    public function setLocalDMC_Role($localDMC_Role = null)
    {
        // validation for constraint: string
        if (!is_null($localDMC_Role) && !is_string($localDMC_Role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDMC_Role, true), gettype($localDMC_Role)), __LINE__);
        }
        $this->LocalDMC_Role = $localDMC_Role;
        return $this;
    }
    /**
     * Get MaxGroupSize value
     * @return int|null
     */
    public function getMaxGroupSize()
    {
        return $this->MaxGroupSize;
    }
    /**
     * Set MaxGroupSize value
     * @param int $maxGroupSize
     * @return \StructType\GroupPolicy
     */
    public function setMaxGroupSize($maxGroupSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxGroupSize) && !(is_int($maxGroupSize) || ctype_digit($maxGroupSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxGroupSize, true), gettype($maxGroupSize)), __LINE__);
        }
        $this->MaxGroupSize = $maxGroupSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
