<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupPolicies StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of group policy information.
 * @subpackage Structs
 */
class GroupPolicies extends AbstractStructBase
{
    /**
     * The GroupPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\GroupPolicy[]
     */
    public $GroupPolicy;
    /**
     * Constructor method for GroupPolicies
     * @uses GroupPolicies::setGroupPolicy()
     * @param \StructType\GroupPolicy[] $groupPolicy
     */
    public function __construct(array $groupPolicy = array())
    {
        $this
            ->setGroupPolicy($groupPolicy);
    }
    /**
     * Get GroupPolicy value
     * @return \StructType\GroupPolicy[]|null
     */
    public function getGroupPolicy()
    {
        return $this->GroupPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupPolicyForArrayConstraintsFromSetGroupPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $groupPoliciesGroupPolicyItem) {
            // validation for constraint: itemType
            if (!$groupPoliciesGroupPolicyItem instanceof \StructType\GroupPolicy) {
                $invalidValues[] = is_object($groupPoliciesGroupPolicyItem) ? get_class($groupPoliciesGroupPolicyItem) : sprintf('%s(%s)', gettype($groupPoliciesGroupPolicyItem), var_export($groupPoliciesGroupPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GroupPolicy property can only contain items of type \StructType\GroupPolicy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupPolicy[] $groupPolicy
     * @return \StructType\GroupPolicies
     */
    public function setGroupPolicy(array $groupPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($groupPolicyArrayErrorMessage = self::validateGroupPolicyForArrayConstraintsFromSetGroupPolicy($groupPolicy))) {
            throw new \InvalidArgumentException($groupPolicyArrayErrorMessage, __LINE__);
        }
        $this->GroupPolicy = $groupPolicy;
        return $this;
    }
    /**
     * Add item to GroupPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupPolicy $item
     * @return \StructType\GroupPolicies
     */
    public function addToGroupPolicy(\StructType\GroupPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupPolicy) {
            throw new \InvalidArgumentException(sprintf('The GroupPolicy property can only contain items of type \StructType\GroupPolicy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GroupPolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
