<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GolfReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: The golf facility ID. | One line in a list of golf reservations. It contains the reservation id's, golf facility and round id, date and time of play, package id, membership info, and golfer name.
 * @subpackage Structs
 */
class GolfReservation extends AbstractStructBase
{
    /**
     * The RoundID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier applied to this tee time round.
     * - use: required
     * @var int
     */
    public $RoundID;
    /**
     * The PlayDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date for which the tee time round is reserved. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: required
     * @var string
     */
    public $PlayDateTime;
    /**
     * The ResponderResConfID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier assigned by the supplier. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $ResponderResConfID;
    /**
     * The Membership
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Membership
     */
    public $Membership;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the golfer for this reservation.
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - documentation: An identification of a package of which this tee time round is a part of. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PackageID;
    /**
     * The RequestorResID
     * Meta information extracted from the WSDL
     * - documentation: The unique Identifier used by the party booking the reservation. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RequestorResID;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for GolfReservation
     * @uses GolfReservation::setRoundID()
     * @uses GolfReservation::setPlayDateTime()
     * @uses GolfReservation::setResponderResConfID()
     * @uses GolfReservation::setMembership()
     * @uses GolfReservation::setName()
     * @uses GolfReservation::setPackageID()
     * @uses GolfReservation::setRequestorResID()
     * @uses GolfReservation::setID()
     * @param int $roundID
     * @param string $playDateTime
     * @param string $responderResConfID
     * @param \StructType\Membership $membership
     * @param \StructType\PersonNameType $name
     * @param string $packageID
     * @param string $requestorResID
     * @param string $iD
     */
    public function __construct($roundID = null, $playDateTime = null, $responderResConfID = null, \StructType\Membership $membership = null, \StructType\PersonNameType $name = null, $packageID = null, $requestorResID = null, $iD = null)
    {
        $this
            ->setRoundID($roundID)
            ->setPlayDateTime($playDateTime)
            ->setResponderResConfID($responderResConfID)
            ->setMembership($membership)
            ->setName($name)
            ->setPackageID($packageID)
            ->setRequestorResID($requestorResID)
            ->setID($iD);
    }
    /**
     * Get RoundID value
     * @return int
     */
    public function getRoundID()
    {
        return $this->RoundID;
    }
    /**
     * Set RoundID value
     * @param int $roundID
     * @return \StructType\GolfReservation
     */
    public function setRoundID($roundID = null)
    {
        // validation for constraint: int
        if (!is_null($roundID) && !(is_int($roundID) || ctype_digit($roundID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roundID, true), gettype($roundID)), __LINE__);
        }
        $this->RoundID = $roundID;
        return $this;
    }
    /**
     * Get PlayDateTime value
     * @return string
     */
    public function getPlayDateTime()
    {
        return $this->PlayDateTime;
    }
    /**
     * This method is responsible for validating the value passed to the setPlayDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlayDateTime method
     * This is a set of validation rules based on the union types associated to the property being set by the setPlayDateTime method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlayDateTimeForUnionConstraintsFromSetPlayDateTime($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set PlayDateTime value
     * @param string $playDateTime
     * @return \StructType\GolfReservation
     */
    public function setPlayDateTime($playDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($playDateTime) && !is_string($playDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($playDateTime, true), gettype($playDateTime)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($playDateTimeUnionErrorMessage = self::validatePlayDateTimeForUnionConstraintsFromSetPlayDateTime($playDateTime))) {
            throw new \InvalidArgumentException($playDateTimeUnionErrorMessage, __LINE__);
        }
        $this->PlayDateTime = $playDateTime;
        return $this;
    }
    /**
     * Get ResponderResConfID value
     * @return string
     */
    public function getResponderResConfID()
    {
        return $this->ResponderResConfID;
    }
    /**
     * Set ResponderResConfID value
     * @param string $responderResConfID
     * @return \StructType\GolfReservation
     */
    public function setResponderResConfID($responderResConfID = null)
    {
        // validation for constraint: string
        if (!is_null($responderResConfID) && !is_string($responderResConfID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responderResConfID, true), gettype($responderResConfID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($responderResConfID) && mb_strlen($responderResConfID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($responderResConfID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($responderResConfID) && mb_strlen($responderResConfID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($responderResConfID)), __LINE__);
        }
        $this->ResponderResConfID = $responderResConfID;
        return $this;
    }
    /**
     * Get Membership value
     * @return \StructType\Membership|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * Set Membership value
     * @param \StructType\Membership $membership
     * @return \StructType\GolfReservation
     */
    public function setMembership(\StructType\Membership $membership = null)
    {
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\GolfReservation
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \StructType\GolfReservation
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($packageID) && mb_strlen($packageID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($packageID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageID) && mb_strlen($packageID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get RequestorResID value
     * @return string|null
     */
    public function getRequestorResID()
    {
        return $this->RequestorResID;
    }
    /**
     * Set RequestorResID value
     * @param string $requestorResID
     * @return \StructType\GolfReservation
     */
    public function setRequestorResID($requestorResID = null)
    {
        // validation for constraint: string
        if (!is_null($requestorResID) && !is_string($requestorResID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorResID, true), gettype($requestorResID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($requestorResID) && mb_strlen($requestorResID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($requestorResID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($requestorResID) && mb_strlen($requestorResID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($requestorResID)), __LINE__);
        }
        $this->RequestorResID = $requestorResID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\GolfReservation
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GolfReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
