<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GlobalReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: One line in a list of reservations from a global distribution system. It may contain the booking reference, the person name, start date, and an itinerary name.
 * @subpackage Structs
 */
class GlobalReservation extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The booking reference ID.
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The TravelerName
     * Meta information extracted from the WSDL
     * - documentation: The name of the first traveler in the reservation.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $TravelerName;
    /**
     * The ItineraryName
     * Meta information extracted from the WSDL
     * - documentation: A name given to this itinerary. | Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $ItineraryName;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: The first date of the reservation, i.e., check-in date, departure date, pickup date, etc. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $Start;
    /**
     * Constructor method for GlobalReservation
     * @uses GlobalReservation::setUniqueID()
     * @uses GlobalReservation::setTravelerName()
     * @uses GlobalReservation::setItineraryName()
     * @uses GlobalReservation::setStart()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\PersonNameType $travelerName
     * @param string $itineraryName
     * @param string $start
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\PersonNameType $travelerName = null, $itineraryName = null, $start = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setTravelerName($travelerName)
            ->setItineraryName($itineraryName)
            ->setStart($start);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\GlobalReservation
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get TravelerName value
     * @return \StructType\PersonNameType|null
     */
    public function getTravelerName()
    {
        return $this->TravelerName;
    }
    /**
     * Set TravelerName value
     * @param \StructType\PersonNameType $travelerName
     * @return \StructType\GlobalReservation
     */
    public function setTravelerName(\StructType\PersonNameType $travelerName = null)
    {
        $this->TravelerName = $travelerName;
        return $this;
    }
    /**
     * Get ItineraryName value
     * @return string|null
     */
    public function getItineraryName()
    {
        return $this->ItineraryName;
    }
    /**
     * Set ItineraryName value
     * @param string $itineraryName
     * @return \StructType\GlobalReservation
     */
    public function setItineraryName($itineraryName = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryName) && !is_string($itineraryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itineraryName, true), gettype($itineraryName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($itineraryName) && mb_strlen($itineraryName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($itineraryName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($itineraryName) && mb_strlen($itineraryName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($itineraryName)), __LINE__);
        }
        $this->ItineraryName = $itineraryName;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\GlobalReservation
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GlobalReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
