<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FulfillmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment information relevant to a booking.
 * @subpackage Structs
 */
class FulfillmentType extends AbstractStructBase
{
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentDetails
     */
    public $PaymentDetails;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - documentation: Ticket delivery information for the booking request.
     * - minOccurs: 0
     * @var mixed
     */
    public $DeliveryAddress;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Purchaser name details.
     * - minOccurs: 0
     * @var mixed
     */
    public $Name;
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Receipt
     */
    public $Receipt;
    /**
     * The PaymentText
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PaymentText[]
     */
    public $PaymentText;
    /**
     * Constructor method for FulfillmentType
     * @uses FulfillmentType::setPaymentDetails()
     * @uses FulfillmentType::setDeliveryAddress()
     * @uses FulfillmentType::setName()
     * @uses FulfillmentType::setReceipt()
     * @uses FulfillmentType::setPaymentText()
     * @param \StructType\PaymentDetails $paymentDetails
     * @param mixed $deliveryAddress
     * @param mixed $name
     * @param \StructType\Receipt $receipt
     * @param \StructType\PaymentText[] $paymentText
     */
    public function __construct(\StructType\PaymentDetails $paymentDetails = null, $deliveryAddress = null, $name = null, \StructType\Receipt $receipt = null, array $paymentText = array())
    {
        $this
            ->setPaymentDetails($paymentDetails)
            ->setDeliveryAddress($deliveryAddress)
            ->setName($name)
            ->setReceipt($receipt)
            ->setPaymentText($paymentText);
    }
    /**
     * Get PaymentDetails value
     * @return \StructType\PaymentDetails|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \StructType\PaymentDetails $paymentDetails
     * @return \StructType\FulfillmentType
     */
    public function setPaymentDetails(\StructType\PaymentDetails $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return mixed|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param mixed $deliveryAddress
     * @return \StructType\FulfillmentType
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get Name value
     * @return mixed|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param mixed $name
     * @return \StructType\FulfillmentType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Receipt value
     * @return \StructType\Receipt|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * Set Receipt value
     * @param \StructType\Receipt $receipt
     * @return \StructType\FulfillmentType
     */
    public function setReceipt(\StructType\Receipt $receipt = null)
    {
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Get PaymentText value
     * @return \StructType\PaymentText[]|null
     */
    public function getPaymentText()
    {
        return $this->PaymentText;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentTextForArrayConstraintsFromSetPaymentText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fulfillmentTypePaymentTextItem) {
            // validation for constraint: itemType
            if (!$fulfillmentTypePaymentTextItem instanceof \StructType\PaymentText) {
                $invalidValues[] = is_object($fulfillmentTypePaymentTextItem) ? get_class($fulfillmentTypePaymentTextItem) : sprintf('%s(%s)', gettype($fulfillmentTypePaymentTextItem), var_export($fulfillmentTypePaymentTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentText property can only contain items of type \StructType\PaymentText, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentText value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentText[] $paymentText
     * @return \StructType\FulfillmentType
     */
    public function setPaymentText(array $paymentText = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentTextArrayErrorMessage = self::validatePaymentTextForArrayConstraintsFromSetPaymentText($paymentText))) {
            throw new \InvalidArgumentException($paymentTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($paymentText) && count($paymentText) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($paymentText)), __LINE__);
        }
        $this->PaymentText = $paymentText;
        return $this;
    }
    /**
     * Add item to PaymentText value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentText $item
     * @return \StructType\FulfillmentType
     */
    public function addToPaymentText(\StructType\PaymentText $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentText) {
            throw new \InvalidArgumentException(sprintf('The PaymentText property can only contain items of type \StructType\PaymentText, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PaymentText) && count($this->PaymentText) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PaymentText)), __LINE__);
        }
        $this->PaymentText[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FulfillmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
