<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrontOfficeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: The identifying fields for the front office for a Massive Good donation: Product Name, Product version, Office ID and Corporate ID.
 * @subpackage Structs
 */
class FrontOfficeInfo extends AbstractStructBase
{
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - documentation: The Massive Good/ Amadeus Donation Service product name.
     * - use: required
     * @var string
     */
    public $ProductName;
    /**
     * The ProductVersion
     * Meta information extracted from the WSDL
     * - documentation: The Massive Good/ Amadeus Donation Service product version.
     * - use: required
     * @var string
     */
    public $ProductVersion;
    /**
     * The OfficeID
     * Meta information extracted from the WSDL
     * - documentation: The Massive Good/ Amadeus Donation Service office ID.
     * - use: required
     * @var string
     */
    public $OfficeID;
    /**
     * The CorporateID
     * Meta information extracted from the WSDL
     * - documentation: The Massive Good/ Amadeus Donation Service corporate ID.
     * - use: required
     * @var string
     */
    public $CorporateID;
    /**
     * Constructor method for FrontOfficeInfo
     * @uses FrontOfficeInfo::setProductName()
     * @uses FrontOfficeInfo::setProductVersion()
     * @uses FrontOfficeInfo::setOfficeID()
     * @uses FrontOfficeInfo::setCorporateID()
     * @param string $productName
     * @param string $productVersion
     * @param string $officeID
     * @param string $corporateID
     */
    public function __construct($productName = null, $productVersion = null, $officeID = null, $corporateID = null)
    {
        $this
            ->setProductName($productName)
            ->setProductVersion($productVersion)
            ->setOfficeID($officeID)
            ->setCorporateID($corporateID);
    }
    /**
     * Get ProductName value
     * @return string
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\FrontOfficeInfo
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductVersion value
     * @return string
     */
    public function getProductVersion()
    {
        return $this->ProductVersion;
    }
    /**
     * Set ProductVersion value
     * @param string $productVersion
     * @return \StructType\FrontOfficeInfo
     */
    public function setProductVersion($productVersion = null)
    {
        // validation for constraint: string
        if (!is_null($productVersion) && !is_string($productVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productVersion, true), gettype($productVersion)), __LINE__);
        }
        $this->ProductVersion = $productVersion;
        return $this;
    }
    /**
     * Get OfficeID value
     * @return string
     */
    public function getOfficeID()
    {
        return $this->OfficeID;
    }
    /**
     * Set OfficeID value
     * @param string $officeID
     * @return \StructType\FrontOfficeInfo
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: string
        if (!is_null($officeID) && !is_string($officeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officeID, true), gettype($officeID)), __LINE__);
        }
        $this->OfficeID = $officeID;
        return $this;
    }
    /**
     * Get CorporateID value
     * @return string
     */
    public function getCorporateID()
    {
        return $this->CorporateID;
    }
    /**
     * Set CorporateID value
     * @param string $corporateID
     * @return \StructType\FrontOfficeInfo
     */
    public function setCorporateID($corporateID = null)
    {
        // validation for constraint: string
        if (!is_null($corporateID) && !is_string($corporateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateID, true), gettype($corporateID)), __LINE__);
        }
        $this->CorporateID = $corporateID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FrontOfficeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
