<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Frequency StructType
 * Meta information extracted from the WSDL
 * - documentation: Note: This is the timeframe used to apply the charge. | Example: Daily | Charge frequency.
 * @subpackage Structs
 */
class Frequency extends List_ChargeFrequency
{
    /**
     * The ExemptQty
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the frequency exemption quantity before charges are applied. | Example: 2 | Exempt quantity.
     * - use: optional
     * @var int
     */
    public $ExemptQty;
    /**
     * The MaximumQty
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the maximum number of times the charge will be applied (e.g. waive charges above 30 nights). | Example: 7 | Maximum quantity.
     * - use: optional
     * @var int
     */
    public $MaximumQty;
    /**
     * Constructor method for Frequency
     * @uses Frequency::setExemptQty()
     * @uses Frequency::setMaximumQty()
     * @param int $exemptQty
     * @param int $maximumQty
     */
    public function __construct($exemptQty = null, $maximumQty = null)
    {
        $this
            ->setExemptQty($exemptQty)
            ->setMaximumQty($maximumQty);
    }
    /**
     * Get ExemptQty value
     * @return int|null
     */
    public function getExemptQty()
    {
        return $this->ExemptQty;
    }
    /**
     * Set ExemptQty value
     * @param int $exemptQty
     * @return \StructType\Frequency
     */
    public function setExemptQty($exemptQty = null)
    {
        // validation for constraint: int
        if (!is_null($exemptQty) && !(is_int($exemptQty) || ctype_digit($exemptQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exemptQty, true), gettype($exemptQty)), __LINE__);
        }
        $this->ExemptQty = $exemptQty;
        return $this;
    }
    /**
     * Get MaximumQty value
     * @return int|null
     */
    public function getMaximumQty()
    {
        return $this->MaximumQty;
    }
    /**
     * Set MaximumQty value
     * @param int $maximumQty
     * @return \StructType\Frequency
     */
    public function setMaximumQty($maximumQty = null)
    {
        // validation for constraint: int
        if (!is_null($maximumQty) && !(is_int($maximumQty) || ctype_digit($maximumQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumQty, true), gettype($maximumQty)), __LINE__);
        }
        $this->MaximumQty = $maximumQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Frequency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
