<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeUpgrade StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines offers of the type "book A and get B".
 * @subpackage Structs
 */
class FreeUpgrade extends AbstractStructBase
{
    /**
     * The UpgradeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UpgradeFrom
     */
    public $UpgradeFrom;
    /**
     * The UpgradeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UpgradeTo
     */
    public $UpgradeTo;
    /**
     * The UpgradeBookingCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies the inventory item which must appear in the booking.
     * - use: optional
     * @var string
     */
    public $UpgradeBookingCode;
    /**
     * Constructor method for FreeUpgrade
     * @uses FreeUpgrade::setUpgradeFrom()
     * @uses FreeUpgrade::setUpgradeTo()
     * @uses FreeUpgrade::setUpgradeBookingCode()
     * @param \StructType\UpgradeFrom $upgradeFrom
     * @param \StructType\UpgradeTo $upgradeTo
     * @param string $upgradeBookingCode
     */
    public function __construct(\StructType\UpgradeFrom $upgradeFrom = null, \StructType\UpgradeTo $upgradeTo = null, $upgradeBookingCode = null)
    {
        $this
            ->setUpgradeFrom($upgradeFrom)
            ->setUpgradeTo($upgradeTo)
            ->setUpgradeBookingCode($upgradeBookingCode);
    }
    /**
     * Get UpgradeFrom value
     * @return \StructType\UpgradeFrom|null
     */
    public function getUpgradeFrom()
    {
        return $this->UpgradeFrom;
    }
    /**
     * Set UpgradeFrom value
     * @param \StructType\UpgradeFrom $upgradeFrom
     * @return \StructType\FreeUpgrade
     */
    public function setUpgradeFrom(\StructType\UpgradeFrom $upgradeFrom = null)
    {
        $this->UpgradeFrom = $upgradeFrom;
        return $this;
    }
    /**
     * Get UpgradeTo value
     * @return \StructType\UpgradeTo|null
     */
    public function getUpgradeTo()
    {
        return $this->UpgradeTo;
    }
    /**
     * Set UpgradeTo value
     * @param \StructType\UpgradeTo $upgradeTo
     * @return \StructType\FreeUpgrade
     */
    public function setUpgradeTo(\StructType\UpgradeTo $upgradeTo = null)
    {
        $this->UpgradeTo = $upgradeTo;
        return $this;
    }
    /**
     * Get UpgradeBookingCode value
     * @return string|null
     */
    public function getUpgradeBookingCode()
    {
        return $this->UpgradeBookingCode;
    }
    /**
     * Set UpgradeBookingCode value
     * @param string $upgradeBookingCode
     * @return \StructType\FreeUpgrade
     */
    public function setUpgradeBookingCode($upgradeBookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeBookingCode) && !is_string($upgradeBookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upgradeBookingCode, true), gettype($upgradeBookingCode)), __LINE__);
        }
        $this->UpgradeBookingCode = $upgradeBookingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FreeUpgrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
