<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedTextType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of formatted text sub sections.
 * @subpackage Structs
 */
class FormattedTextType extends AbstractStructBase
{
    /**
     * The SubSection
     * Meta information extracted from the WSDL
     * - documentation: Subsection formatted text information.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $SubSection;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: This attribute may be used to provide a title for the formatted free text, for example, Driving Directions. Each of the sub sections that are defined to be a part of the formatted text would provide detailed information about the
     * subject identified by the title.
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: The language in which the content is provided.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * Constructor method for FormattedTextType
     * @uses FormattedTextType::setSubSection()
     * @uses FormattedTextType::setTitle()
     * @uses FormattedTextType::setLanguage()
     * @param mixed[] $subSection
     * @param string $title
     * @param string $language
     */
    public function __construct(array $subSection = array(), $title = null, $language = null)
    {
        $this
            ->setSubSection($subSection)
            ->setTitle($title)
            ->setLanguage($language);
    }
    /**
     * Get SubSection value
     * @return mixed[]|null
     */
    public function getSubSection()
    {
        return $this->SubSection;
    }
    /**
     * This method is responsible for validating the values passed to the setSubSection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubSection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubSectionForArrayConstraintsFromSetSubSection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formattedTextTypeSubSectionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($formattedTextTypeSubSectionItem) ? get_class($formattedTextTypeSubSectionItem) : sprintf('%s(%s)', gettype($formattedTextTypeSubSectionItem), var_export($formattedTextTypeSubSectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubSection property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubSection value
     * @throws \InvalidArgumentException
     * @param mixed[] $subSection
     * @return \StructType\FormattedTextType
     */
    public function setSubSection(array $subSection = array())
    {
        // validation for constraint: array
        if ('' !== ($subSectionArrayErrorMessage = self::validateSubSectionForArrayConstraintsFromSetSubSection($subSection))) {
            throw new \InvalidArgumentException($subSectionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($subSection) && count($subSection) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($subSection)), __LINE__);
        }
        $this->SubSection = $subSection;
        return $this;
    }
    /**
     * Add item to SubSection value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FormattedTextType
     */
    public function addToSubSection($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SubSection property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SubSection) && count($this->SubSection) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SubSection)), __LINE__);
        }
        $this->SubSection[] = $item;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\FormattedTextType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\FormattedTextType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormattedTextType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
