<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: FlightSegmentType extends FlightSegmentBaseType to provide additional functionality.
 * @subpackage Structs
 */
class FlightSegmentType extends FlightSegmentBaseType
{
    /**
     * The MarketingAirline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MarketingAirline
     */
    public $MarketingAirline;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The flight number of the flight. This is required for use with scheduled airline messages but may be omitted for requests by tour operators.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The TourOperatorFlightID
     * Meta information extracted from the WSDL
     * - documentation: ID of a flight in the Tour Operator's inventory. This flight is not necessarily in the inventory of an airline. Rather, it is a code created by tour operators.
     * - use: optional
     * @var string
     */
    public $TourOperatorFlightID;
    /**
     * The GovernmentApprovalInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the flight is subject to government approval.
     * - use: optional
     * @var bool
     */
    public $GovernmentApprovalInd;
    /**
     * The GovernmentApprovalText
     * Meta information extracted from the WSDL
     * - documentation: Provides additional information concerning the flight being subject to government approval.
     * - use: optional
     * @var string
     */
    public $GovernmentApprovalText;
    /**
     * The FlownMileageQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of flown miles associated with this segment.
     * - use: optional
     * @var int
     */
    public $FlownMileageQty;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: The fare basis code for this flight leg.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Specific Booking Class for this segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for FlightSegmentType
     * @uses FlightSegmentType::setMarketingAirline()
     * @uses FlightSegmentType::setFlightNumber()
     * @uses FlightSegmentType::setTourOperatorFlightID()
     * @uses FlightSegmentType::setGovernmentApprovalInd()
     * @uses FlightSegmentType::setGovernmentApprovalText()
     * @uses FlightSegmentType::setFlownMileageQty()
     * @uses FlightSegmentType::setFareBasisCode()
     * @uses FlightSegmentType::setResBookDesigCode()
     * @param \StructType\MarketingAirline $marketingAirline
     * @param string $flightNumber
     * @param string $tourOperatorFlightID
     * @param bool $governmentApprovalInd
     * @param string $governmentApprovalText
     * @param int $flownMileageQty
     * @param string $fareBasisCode
     * @param string $resBookDesigCode
     */
    public function __construct(\StructType\MarketingAirline $marketingAirline = null, $flightNumber = null, $tourOperatorFlightID = null, $governmentApprovalInd = null, $governmentApprovalText = null, $flownMileageQty = null, $fareBasisCode = null, $resBookDesigCode = null)
    {
        $this
            ->setMarketingAirline($marketingAirline)
            ->setFlightNumber($flightNumber)
            ->setTourOperatorFlightID($tourOperatorFlightID)
            ->setGovernmentApprovalInd($governmentApprovalInd)
            ->setGovernmentApprovalText($governmentApprovalText)
            ->setFlownMileageQty($flownMileageQty)
            ->setFareBasisCode($fareBasisCode)
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get MarketingAirline value
     * @return \StructType\MarketingAirline|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \StructType\MarketingAirline $marketingAirline
     * @return \StructType\FlightSegmentType
     */
    public function setMarketingAirline(\StructType\MarketingAirline $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\FlightSegmentType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get TourOperatorFlightID value
     * @return string|null
     */
    public function getTourOperatorFlightID()
    {
        return $this->TourOperatorFlightID;
    }
    /**
     * Set TourOperatorFlightID value
     * @param string $tourOperatorFlightID
     * @return \StructType\FlightSegmentType
     */
    public function setTourOperatorFlightID($tourOperatorFlightID = null)
    {
        // validation for constraint: string
        if (!is_null($tourOperatorFlightID) && !is_string($tourOperatorFlightID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourOperatorFlightID, true), gettype($tourOperatorFlightID)), __LINE__);
        }
        $this->TourOperatorFlightID = $tourOperatorFlightID;
        return $this;
    }
    /**
     * Get GovernmentApprovalInd value
     * @return bool|null
     */
    public function getGovernmentApprovalInd()
    {
        return $this->GovernmentApprovalInd;
    }
    /**
     * Set GovernmentApprovalInd value
     * @param bool $governmentApprovalInd
     * @return \StructType\FlightSegmentType
     */
    public function setGovernmentApprovalInd($governmentApprovalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($governmentApprovalInd) && !is_bool($governmentApprovalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($governmentApprovalInd, true), gettype($governmentApprovalInd)), __LINE__);
        }
        $this->GovernmentApprovalInd = $governmentApprovalInd;
        return $this;
    }
    /**
     * Get GovernmentApprovalText value
     * @return string|null
     */
    public function getGovernmentApprovalText()
    {
        return $this->GovernmentApprovalText;
    }
    /**
     * Set GovernmentApprovalText value
     * @param string $governmentApprovalText
     * @return \StructType\FlightSegmentType
     */
    public function setGovernmentApprovalText($governmentApprovalText = null)
    {
        // validation for constraint: string
        if (!is_null($governmentApprovalText) && !is_string($governmentApprovalText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($governmentApprovalText, true), gettype($governmentApprovalText)), __LINE__);
        }
        $this->GovernmentApprovalText = $governmentApprovalText;
        return $this;
    }
    /**
     * Get FlownMileageQty value
     * @return int|null
     */
    public function getFlownMileageQty()
    {
        return $this->FlownMileageQty;
    }
    /**
     * Set FlownMileageQty value
     * @param int $flownMileageQty
     * @return \StructType\FlightSegmentType
     */
    public function setFlownMileageQty($flownMileageQty = null)
    {
        // validation for constraint: int
        if (!is_null($flownMileageQty) && !(is_int($flownMileageQty) || ctype_digit($flownMileageQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flownMileageQty, true), gettype($flownMileageQty)), __LINE__);
        }
        $this->FlownMileageQty = $flownMileageQty;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FlightSegmentType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\FlightSegmentType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
