<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentRPHs StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference pointers to flight segments
 * @subpackage Structs
 */
class FlightSegmentRPHs extends AbstractStructBase
{
    /**
     * The FlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to the flight segments for this traveler
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $FlightSegmentRPH;
    /**
     * Constructor method for FlightSegmentRPHs
     * @uses FlightSegmentRPHs::setFlightSegmentRPH()
     * @param mixed[] $flightSegmentRPH
     */
    public function __construct(array $flightSegmentRPH = array())
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH);
    }
    /**
     * Get FlightSegmentRPH value
     * @return mixed[]|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightSegmentRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightSegmentRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightSegmentRPHForArrayConstraintsFromSetFlightSegmentRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightSegmentRPHsFlightSegmentRPHItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($flightSegmentRPHsFlightSegmentRPHItem) ? get_class($flightSegmentRPHsFlightSegmentRPHItem) : sprintf('%s(%s)', gettype($flightSegmentRPHsFlightSegmentRPHItem), var_export($flightSegmentRPHsFlightSegmentRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightSegmentRPH property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightSegmentRPH value
     * @throws \InvalidArgumentException
     * @param mixed[] $flightSegmentRPH
     * @return \StructType\FlightSegmentRPHs
     */
    public function setFlightSegmentRPH(array $flightSegmentRPH = array())
    {
        // validation for constraint: array
        if ('' !== ($flightSegmentRPHArrayErrorMessage = self::validateFlightSegmentRPHForArrayConstraintsFromSetFlightSegmentRPH($flightSegmentRPH))) {
            throw new \InvalidArgumentException($flightSegmentRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($flightSegmentRPH) && count($flightSegmentRPH) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($flightSegmentRPH)), __LINE__);
        }
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Add item to FlightSegmentRPH value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FlightSegmentRPHs
     */
    public function addToFlightSegmentRPH($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The FlightSegmentRPH property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FlightSegmentRPH) && count($this->FlightSegmentRPH) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FlightSegmentRPH)), __LINE__);
        }
        $this->FlightSegmentRPH[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightSegmentRPHs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
