<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLoadInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information used by an airline employee to see the flight load and make decisions regarding non-revenue travel. This information may be used in the reservation process to determine if the flight is oversold or any additional
 * reservations could be made on this flight segment in a specific cabin.
 * @subpackage Structs
 */
class FlightLoadInfo extends AbstractStructBase
{
    /**
     * The AuthorizedSeatQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of seats authorized for sale for a cabin and flight leg.
     * - use: optional
     * @var int
     */
    public $AuthorizedSeatQty;
    /**
     * The NRSA_StandbyPaxQty
     * Meta information extracted from the WSDL
     * - documentation: The listed quantity of standby passengers (non-revenue PAX) for a cabin and flight leg.
     * - use: optional
     * @var int
     */
    public $NRSA_StandbyPaxQty;
    /**
     * The RevenuePaxQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of booked revenue passengers (revenue PAX) for each cabin and flight leg.
     * - use: optional
     * @var int
     */
    public $RevenuePaxQty;
    /**
     * Constructor method for FlightLoadInfo
     * @uses FlightLoadInfo::setAuthorizedSeatQty()
     * @uses FlightLoadInfo::setNRSA_StandbyPaxQty()
     * @uses FlightLoadInfo::setRevenuePaxQty()
     * @param int $authorizedSeatQty
     * @param int $nRSA_StandbyPaxQty
     * @param int $revenuePaxQty
     */
    public function __construct($authorizedSeatQty = null, $nRSA_StandbyPaxQty = null, $revenuePaxQty = null)
    {
        $this
            ->setAuthorizedSeatQty($authorizedSeatQty)
            ->setNRSA_StandbyPaxQty($nRSA_StandbyPaxQty)
            ->setRevenuePaxQty($revenuePaxQty);
    }
    /**
     * Get AuthorizedSeatQty value
     * @return int|null
     */
    public function getAuthorizedSeatQty()
    {
        return $this->AuthorizedSeatQty;
    }
    /**
     * Set AuthorizedSeatQty value
     * @param int $authorizedSeatQty
     * @return \StructType\FlightLoadInfo
     */
    public function setAuthorizedSeatQty($authorizedSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($authorizedSeatQty) && !(is_int($authorizedSeatQty) || ctype_digit($authorizedSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($authorizedSeatQty, true), gettype($authorizedSeatQty)), __LINE__);
        }
        $this->AuthorizedSeatQty = $authorizedSeatQty;
        return $this;
    }
    /**
     * Get NRSA_StandbyPaxQty value
     * @return int|null
     */
    public function getNRSA_StandbyPaxQty()
    {
        return $this->NRSA_StandbyPaxQty;
    }
    /**
     * Set NRSA_StandbyPaxQty value
     * @param int $nRSA_StandbyPaxQty
     * @return \StructType\FlightLoadInfo
     */
    public function setNRSA_StandbyPaxQty($nRSA_StandbyPaxQty = null)
    {
        // validation for constraint: int
        if (!is_null($nRSA_StandbyPaxQty) && !(is_int($nRSA_StandbyPaxQty) || ctype_digit($nRSA_StandbyPaxQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nRSA_StandbyPaxQty, true), gettype($nRSA_StandbyPaxQty)), __LINE__);
        }
        $this->NRSA_StandbyPaxQty = $nRSA_StandbyPaxQty;
        return $this;
    }
    /**
     * Get RevenuePaxQty value
     * @return int|null
     */
    public function getRevenuePaxQty()
    {
        return $this->RevenuePaxQty;
    }
    /**
     * Set RevenuePaxQty value
     * @param int $revenuePaxQty
     * @return \StructType\FlightLoadInfo
     */
    public function setRevenuePaxQty($revenuePaxQty = null)
    {
        // validation for constraint: int
        if (!is_null($revenuePaxQty) && !(is_int($revenuePaxQty) || ctype_digit($revenuePaxQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revenuePaxQty, true), gettype($revenuePaxQty)), __LINE__);
        }
        $this->RevenuePaxQty = $revenuePaxQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightLoadInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
