<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLegType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies minimal information about a flight.
 * @subpackage Structs
 */
class FlightLegType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepartureAirport
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: A flight number.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: The reservation booking designator for a flight.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: A date for the flight.
     * - use: optional
     * @var string
     */
    public $Date;
    /**
     * Constructor method for FlightLegType
     * @uses FlightLegType::setDepartureAirport()
     * @uses FlightLegType::setArrivalAirport()
     * @uses FlightLegType::setFlightNumber()
     * @uses FlightLegType::setResBookDesigCode()
     * @uses FlightLegType::setDate()
     * @param \StructType\DepartureAirport $departureAirport
     * @param \StructType\ArrivalAirport $arrivalAirport
     * @param string $flightNumber
     * @param string $resBookDesigCode
     * @param string $date
     */
    public function __construct(\StructType\DepartureAirport $departureAirport = null, \StructType\ArrivalAirport $arrivalAirport = null, $flightNumber = null, $resBookDesigCode = null, $date = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode)
            ->setDate($date);
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\DepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\DepartureAirport $departureAirport
     * @return \StructType\FlightLegType
     */
    public function setDepartureAirport(\StructType\DepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \StructType\ArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \StructType\ArrivalAirport $arrivalAirport
     * @return \StructType\FlightLegType
     */
    public function setArrivalAirport(\StructType\ArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\FlightLegType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\FlightLegType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\FlightLegType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightLegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
