<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightAndRail StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight and rail information.
 * @subpackage Structs
 */
class FlightAndRail extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Number
     */
    public $Number;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: Example: United | Flight carrier name or code.
     * - minOccurs: 0
     * @var mixed
     */
    public $Carrier;
    /**
     * The Class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\_Class
     */
    public $Class;
    /**
     * The FareCode
     * Meta information extracted from the WSDL
     * - documentation: Example: 1437 | Fare code.
     * - minOccurs: 0
     * @var mixed
     */
    public $FareCode;
    /**
     * Constructor method for FlightAndRail
     * @uses FlightAndRail::setNumber()
     * @uses FlightAndRail::setCarrier()
     * @uses FlightAndRail::setClass()
     * @uses FlightAndRail::setFareCode()
     * @param \StructType\Number $number
     * @param mixed $carrier
     * @param \StructType\_Class $class
     * @param mixed $fareCode
     */
    public function __construct(\StructType\Number $number = null, $carrier = null, \StructType\_Class $class = null, $fareCode = null)
    {
        $this
            ->setNumber($number)
            ->setCarrier($carrier)
            ->setClass($class)
            ->setFareCode($fareCode);
    }
    /**
     * Get Number value
     * @return \StructType\Number|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param \StructType\Number $number
     * @return \StructType\FlightAndRail
     */
    public function setNumber(\StructType\Number $number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Carrier value
     * @return mixed|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param mixed $carrier
     * @return \StructType\FlightAndRail
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get Class value
     * @return \StructType\_Class|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param \StructType\_Class $class
     * @return \StructType\FlightAndRail
     */
    public function setClass(\StructType\_Class $class = null)
    {
        $this->Class = $class;
        return $this;
    }
    /**
     * Get FareCode value
     * @return mixed|null
     */
    public function getFareCode()
    {
        return $this->FareCode;
    }
    /**
     * Set FareCode value
     * @param mixed $fareCode
     * @return \StructType\FlightAndRail
     */
    public function setFareCode($fareCode = null)
    {
        $this->FareCode = $fareCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightAndRail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
