<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: The from and to airport/city code for this carrier fee. | The type of fee being imposed by a carrier, the amount and other related information. | The amount of the no show fee if a reservation is not cancelled before the specified
 * deadline and the renter does not show up for the reservation.
 * @subpackage Structs
 */
class FeeAmount extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: 1 to 3 alpha numeric carrier fee code.
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The carrier fee amount.
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The ApplicationCode
     * Meta information extracted from the WSDL
     * - documentation: To specify if not interlineable, not refundable, commissionable or not commissionable. Refer to OpenTravel Code List "EMD Application Code PADIS 9988".
     * - use: required
     * @var list
     */
    public $ApplicationCode;
    /**
     * The RateConvertedInd
     * Meta information extracted from the WSDL
     * - documentation: When true indicates the amount was converted from another currency.
     * - use: optional
     * @var bool
     */
    public $RateConvertedInd;
    /**
     * The GuaranteeReqInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a credit card is required when a reservation is booked or modified.
     * - use: optional
     * @var bool
     */
    public $GuaranteeReqInd;
    /**
     * The EmailRequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When true, an email address is required when a reservation is booked or modified.
     * - use: optional
     * @var bool
     */
    public $EmailRequiredInd;
    /**
     * Constructor method for FeeAmount
     * @uses FeeAmount::setType()
     * @uses FeeAmount::setAmount()
     * @uses FeeAmount::setApplicationCode()
     * @uses FeeAmount::setRateConvertedInd()
     * @uses FeeAmount::setGuaranteeReqInd()
     * @uses FeeAmount::setEmailRequiredInd()
     * @param string $type
     * @param float $amount
     * @param list $applicationCode
     * @param bool $rateConvertedInd
     * @param bool $guaranteeReqInd
     * @param bool $emailRequiredInd
     */
    public function __construct($type = null, $amount = null, list $applicationCode = null, $rateConvertedInd = null, $guaranteeReqInd = null, $emailRequiredInd = null)
    {
        $this
            ->setType($type)
            ->setAmount($amount)
            ->setApplicationCode($applicationCode)
            ->setRateConvertedInd($rateConvertedInd)
            ->setGuaranteeReqInd($guaranteeReqInd)
            ->setEmailRequiredInd($emailRequiredInd);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\FeeAmount
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\FeeAmount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApplicationCode value
     * @return list
     */
    public function getApplicationCode()
    {
        return $this->ApplicationCode;
    }
    /**
     * Set ApplicationCode value
     * @param list $applicationCode
     * @return \StructType\FeeAmount
     */
    public function setApplicationCode(list $applicationCode = null)
    {
        $this->ApplicationCode = $applicationCode;
        return $this;
    }
    /**
     * Get RateConvertedInd value
     * @return bool|null
     */
    public function getRateConvertedInd()
    {
        return $this->RateConvertedInd;
    }
    /**
     * Set RateConvertedInd value
     * @param bool $rateConvertedInd
     * @return \StructType\FeeAmount
     */
    public function setRateConvertedInd($rateConvertedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateConvertedInd) && !is_bool($rateConvertedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateConvertedInd, true), gettype($rateConvertedInd)), __LINE__);
        }
        $this->RateConvertedInd = $rateConvertedInd;
        return $this;
    }
    /**
     * Get GuaranteeReqInd value
     * @return bool|null
     */
    public function getGuaranteeReqInd()
    {
        return $this->GuaranteeReqInd;
    }
    /**
     * Set GuaranteeReqInd value
     * @param bool $guaranteeReqInd
     * @return \StructType\FeeAmount
     */
    public function setGuaranteeReqInd($guaranteeReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteeReqInd) && !is_bool($guaranteeReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteeReqInd, true), gettype($guaranteeReqInd)), __LINE__);
        }
        $this->GuaranteeReqInd = $guaranteeReqInd;
        return $this;
    }
    /**
     * Get EmailRequiredInd value
     * @return bool|null
     */
    public function getEmailRequiredInd()
    {
        return $this->EmailRequiredInd;
    }
    /**
     * Set EmailRequiredInd value
     * @param bool $emailRequiredInd
     * @return \StructType\FeeAmount
     */
    public function setEmailRequiredInd($emailRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailRequiredInd) && !is_bool($emailRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailRequiredInd, true), gettype($emailRequiredInd)), __LINE__);
        }
        $this->EmailRequiredInd = $emailRequiredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeeAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
