<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to indicate a private fare and associated information. | Used to indicate a negotiated fare and associated information. | Holds a base fare, tax, total and currency information on a price | The type of fare required (e.g.
 * unrestricted, excursion). Refer to the Fare Qualifier OpenTravel Code list (FAQ).
 * - union: UpperCaseAlphaLength1to3 | OTA_CodeType
 * - use: required
 * @subpackage Structs
 */
class FareType extends AbstractStructBase
{
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseFare
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\EquivFare[]
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalFare
     */
    public $TotalFare;
    /**
     * The FareConstruction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareConstruction
     */
    public $FareConstruction;
    /**
     * The UnstructuredFareCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UnstructuredFareCalc
     */
    public $UnstructuredFareCalc;
    /**
     * The FareBaggageAllowance
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\FareBaggageAllowance[]
     */
    public $FareBaggageAllowance;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TourCode
     */
    public $TourCode;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\Remark[]
     */
    public $Remark;
    /**
     * The OriginalIssueInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginalIssueInfo
     */
    public $OriginalIssueInfo;
    /**
     * The ExchangeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExchangeInfo
     */
    public $ExchangeInfo;
    /**
     * The Discounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Discounts
     */
    public $Discounts;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies a discount code applicable to the fare.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The InputTicketDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies a fare related designator.
     * - use: optional
     * @var string
     */
    public $InputTicketDesigCode;
    /**
     * The TotalNbrTrips
     * Meta information extracted from the WSDL
     * - documentation: The total number of trips in this itinerary.
     * - use: optional
     * @var int
     */
    public $TotalNbrTrips;
    /**
     * The TotalNbrPTC
     * Meta information extracted from the WSDL
     * - documentation: The total number of passenger type codes in this priced itinerary.
     * - use: optional
     * @var int
     */
    public $TotalNbrPTC;
    /**
     * Constructor method for FareType
     * @uses FareType::setBaseFare()
     * @uses FareType::setEquivFare()
     * @uses FareType::setTaxes()
     * @uses FareType::setFees()
     * @uses FareType::setTotalFare()
     * @uses FareType::setFareConstruction()
     * @uses FareType::setUnstructuredFareCalc()
     * @uses FareType::setFareBaggageAllowance()
     * @uses FareType::setTourCode()
     * @uses FareType::setRemark()
     * @uses FareType::setOriginalIssueInfo()
     * @uses FareType::setExchangeInfo()
     * @uses FareType::setDiscounts()
     * @uses FareType::setTPA_Extensions()
     * @uses FareType::setTicketDesignatorCode()
     * @uses FareType::setInputTicketDesigCode()
     * @uses FareType::setTotalNbrTrips()
     * @uses FareType::setTotalNbrPTC()
     * @param \StructType\BaseFare $baseFare
     * @param \StructType\EquivFare[] $equivFare
     * @param \StructType\Taxes $taxes
     * @param \StructType\Fees $fees
     * @param \StructType\TotalFare $totalFare
     * @param \StructType\FareConstruction $fareConstruction
     * @param \StructType\UnstructuredFareCalc $unstructuredFareCalc
     * @param \StructType\FareBaggageAllowance[] $fareBaggageAllowance
     * @param \StructType\TourCode $tourCode
     * @param \StructType\Remark[] $remark
     * @param \StructType\OriginalIssueInfo $originalIssueInfo
     * @param \StructType\ExchangeInfo $exchangeInfo
     * @param \StructType\Discounts $discounts
     * @param mixed $tPA_Extensions
     * @param string $ticketDesignatorCode
     * @param string $inputTicketDesigCode
     * @param int $totalNbrTrips
     * @param int $totalNbrPTC
     */
    public function __construct(\StructType\BaseFare $baseFare = null, array $equivFare = array(), \StructType\Taxes $taxes = null, \StructType\Fees $fees = null, \StructType\TotalFare $totalFare = null, \StructType\FareConstruction $fareConstruction = null, \StructType\UnstructuredFareCalc $unstructuredFareCalc = null, array $fareBaggageAllowance = array(), \StructType\TourCode $tourCode = null, array $remark = array(), \StructType\OriginalIssueInfo $originalIssueInfo = null, \StructType\ExchangeInfo $exchangeInfo = null, \StructType\Discounts $discounts = null, $tPA_Extensions = null, $ticketDesignatorCode = null, $inputTicketDesigCode = null, $totalNbrTrips = null, $totalNbrPTC = null)
    {
        $this
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setTotalFare($totalFare)
            ->setFareConstruction($fareConstruction)
            ->setUnstructuredFareCalc($unstructuredFareCalc)
            ->setFareBaggageAllowance($fareBaggageAllowance)
            ->setTourCode($tourCode)
            ->setRemark($remark)
            ->setOriginalIssueInfo($originalIssueInfo)
            ->setExchangeInfo($exchangeInfo)
            ->setDiscounts($discounts)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setInputTicketDesigCode($inputTicketDesigCode)
            ->setTotalNbrTrips($totalNbrTrips)
            ->setTotalNbrPTC($totalNbrPTC);
    }
    /**
     * Get BaseFare value
     * @return \StructType\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \StructType\BaseFare $baseFare
     * @return \StructType\FareType
     */
    public function setBaseFare(\StructType\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \StructType\EquivFare[]|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * This method is responsible for validating the values passed to the setEquivFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquivFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquivFareForArrayConstraintsFromSetEquivFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareTypeEquivFareItem) {
            // validation for constraint: itemType
            if (!$fareTypeEquivFareItem instanceof \StructType\EquivFare) {
                $invalidValues[] = is_object($fareTypeEquivFareItem) ? get_class($fareTypeEquivFareItem) : sprintf('%s(%s)', gettype($fareTypeEquivFareItem), var_export($fareTypeEquivFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquivFare property can only contain items of type \StructType\EquivFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquivFare value
     * @throws \InvalidArgumentException
     * @param \StructType\EquivFare[] $equivFare
     * @return \StructType\FareType
     */
    public function setEquivFare(array $equivFare = array())
    {
        // validation for constraint: array
        if ('' !== ($equivFareArrayErrorMessage = self::validateEquivFareForArrayConstraintsFromSetEquivFare($equivFare))) {
            throw new \InvalidArgumentException($equivFareArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($equivFare) && count($equivFare) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($equivFare)), __LINE__);
        }
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Add item to EquivFare value
     * @throws \InvalidArgumentException
     * @param \StructType\EquivFare $item
     * @return \StructType\FareType
     */
    public function addToEquivFare(\StructType\EquivFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EquivFare) {
            throw new \InvalidArgumentException(sprintf('The EquivFare property can only contain items of type \StructType\EquivFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->EquivFare) && count($this->EquivFare) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->EquivFare)), __LINE__);
        }
        $this->EquivFare[] = $item;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\FareType
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\FareType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \StructType\TotalFare $totalFare
     * @return \StructType\FareType
     */
    public function setTotalFare(\StructType\TotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get FareConstruction value
     * @return \StructType\FareConstruction|null
     */
    public function getFareConstruction()
    {
        return $this->FareConstruction;
    }
    /**
     * Set FareConstruction value
     * @param \StructType\FareConstruction $fareConstruction
     * @return \StructType\FareType
     */
    public function setFareConstruction(\StructType\FareConstruction $fareConstruction = null)
    {
        $this->FareConstruction = $fareConstruction;
        return $this;
    }
    /**
     * Get UnstructuredFareCalc value
     * @return \StructType\UnstructuredFareCalc|null
     */
    public function getUnstructuredFareCalc()
    {
        return $this->UnstructuredFareCalc;
    }
    /**
     * Set UnstructuredFareCalc value
     * @param \StructType\UnstructuredFareCalc $unstructuredFareCalc
     * @return \StructType\FareType
     */
    public function setUnstructuredFareCalc(\StructType\UnstructuredFareCalc $unstructuredFareCalc = null)
    {
        $this->UnstructuredFareCalc = $unstructuredFareCalc;
        return $this;
    }
    /**
     * Get FareBaggageAllowance value
     * @return \StructType\FareBaggageAllowance[]|null
     */
    public function getFareBaggageAllowance()
    {
        return $this->FareBaggageAllowance;
    }
    /**
     * This method is responsible for validating the values passed to the setFareBaggageAllowance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareBaggageAllowance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareBaggageAllowanceForArrayConstraintsFromSetFareBaggageAllowance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareTypeFareBaggageAllowanceItem) {
            // validation for constraint: itemType
            if (!$fareTypeFareBaggageAllowanceItem instanceof \StructType\FareBaggageAllowance) {
                $invalidValues[] = is_object($fareTypeFareBaggageAllowanceItem) ? get_class($fareTypeFareBaggageAllowanceItem) : sprintf('%s(%s)', gettype($fareTypeFareBaggageAllowanceItem), var_export($fareTypeFareBaggageAllowanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareBaggageAllowance property can only contain items of type \StructType\FareBaggageAllowance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareBaggageAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\FareBaggageAllowance[] $fareBaggageAllowance
     * @return \StructType\FareType
     */
    public function setFareBaggageAllowance(array $fareBaggageAllowance = array())
    {
        // validation for constraint: array
        if ('' !== ($fareBaggageAllowanceArrayErrorMessage = self::validateFareBaggageAllowanceForArrayConstraintsFromSetFareBaggageAllowance($fareBaggageAllowance))) {
            throw new \InvalidArgumentException($fareBaggageAllowanceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fareBaggageAllowance) && count($fareBaggageAllowance) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fareBaggageAllowance)), __LINE__);
        }
        $this->FareBaggageAllowance = $fareBaggageAllowance;
        return $this;
    }
    /**
     * Add item to FareBaggageAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\FareBaggageAllowance $item
     * @return \StructType\FareType
     */
    public function addToFareBaggageAllowance(\StructType\FareBaggageAllowance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareBaggageAllowance) {
            throw new \InvalidArgumentException(sprintf('The FareBaggageAllowance property can only contain items of type \StructType\FareBaggageAllowance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FareBaggageAllowance) && count($this->FareBaggageAllowance) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FareBaggageAllowance)), __LINE__);
        }
        $this->FareBaggageAllowance[] = $item;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \StructType\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \StructType\TourCode $tourCode
     * @return \StructType\FareType
     */
    public function setTourCode(\StructType\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\Remark[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$fareTypeRemarkItem instanceof \StructType\Remark) {
                $invalidValues[] = is_object($fareTypeRemarkItem) ? get_class($fareTypeRemarkItem) : sprintf('%s(%s)', gettype($fareTypeRemarkItem), var_export($fareTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\Remark, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\Remark[] $remark
     * @return \StructType\FareType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($remark) && count($remark) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\Remark $item
     * @return \StructType\FareType
     */
    public function addToRemark(\StructType\Remark $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Remark) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\Remark, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Remark) && count($this->Remark) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Remark)), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get OriginalIssueInfo value
     * @return \StructType\OriginalIssueInfo|null
     */
    public function getOriginalIssueInfo()
    {
        return $this->OriginalIssueInfo;
    }
    /**
     * Set OriginalIssueInfo value
     * @param \StructType\OriginalIssueInfo $originalIssueInfo
     * @return \StructType\FareType
     */
    public function setOriginalIssueInfo(\StructType\OriginalIssueInfo $originalIssueInfo = null)
    {
        $this->OriginalIssueInfo = $originalIssueInfo;
        return $this;
    }
    /**
     * Get ExchangeInfo value
     * @return \StructType\ExchangeInfo|null
     */
    public function getExchangeInfo()
    {
        return $this->ExchangeInfo;
    }
    /**
     * Set ExchangeInfo value
     * @param \StructType\ExchangeInfo $exchangeInfo
     * @return \StructType\FareType
     */
    public function setExchangeInfo(\StructType\ExchangeInfo $exchangeInfo = null)
    {
        $this->ExchangeInfo = $exchangeInfo;
        return $this;
    }
    /**
     * Get Discounts value
     * @return \StructType\Discounts|null
     */
    public function getDiscounts()
    {
        return $this->Discounts;
    }
    /**
     * Set Discounts value
     * @param \StructType\Discounts $discounts
     * @return \StructType\FareType
     */
    public function setDiscounts(\StructType\Discounts $discounts = null)
    {
        $this->Discounts = $discounts;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\FareType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\FareType
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get InputTicketDesigCode value
     * @return string|null
     */
    public function getInputTicketDesigCode()
    {
        return $this->InputTicketDesigCode;
    }
    /**
     * Set InputTicketDesigCode value
     * @param string $inputTicketDesigCode
     * @return \StructType\FareType
     */
    public function setInputTicketDesigCode($inputTicketDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputTicketDesigCode) && !is_string($inputTicketDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputTicketDesigCode, true), gettype($inputTicketDesigCode)), __LINE__);
        }
        $this->InputTicketDesigCode = $inputTicketDesigCode;
        return $this;
    }
    /**
     * Get TotalNbrTrips value
     * @return int|null
     */
    public function getTotalNbrTrips()
    {
        return $this->TotalNbrTrips;
    }
    /**
     * Set TotalNbrTrips value
     * @param int $totalNbrTrips
     * @return \StructType\FareType
     */
    public function setTotalNbrTrips($totalNbrTrips = null)
    {
        // validation for constraint: int
        if (!is_null($totalNbrTrips) && !(is_int($totalNbrTrips) || ctype_digit($totalNbrTrips))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNbrTrips, true), gettype($totalNbrTrips)), __LINE__);
        }
        $this->TotalNbrTrips = $totalNbrTrips;
        return $this;
    }
    /**
     * Get TotalNbrPTC value
     * @return int|null
     */
    public function getTotalNbrPTC()
    {
        return $this->TotalNbrPTC;
    }
    /**
     * Set TotalNbrPTC value
     * @param int $totalNbrPTC
     * @return \StructType\FareType
     */
    public function setTotalNbrPTC($totalNbrPTC = null)
    {
        // validation for constraint: int
        if (!is_null($totalNbrPTC) && !(is_int($totalNbrPTC) || ctype_digit($totalNbrPTC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNbrPTC, true), gettype($totalNbrPTC)), __LINE__);
        }
        $this->TotalNbrPTC = $totalNbrPTC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
