<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Preferred fare restriction(s). | Container used for specifying or limiting acceptable fare restrictions. | Constrains a fare search to those with restrictions that satisfy user-imposed limitations. | Indicates preferred fare
 * restrictions to be used in search.
 * @subpackage Structs
 */
class FareRestrictPref extends AbstractStructBase
{
    /**
     * The AdvResTicketing
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether advance reservation or ticketing restrictions are acceptable in the search results.
     * - minOccurs: 0
     * @var mixed
     */
    public $AdvResTicketing;
    /**
     * The StayRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether restrictions on minimum or maximum stays should be included in the search results.
     * - minOccurs: 0
     * @var mixed
     */
    public $StayRestrictions;
    /**
     * The VoluntaryChanges
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether penalties associated with voluntary changes should be included in the search results.
     * - minOccurs: 0
     * @var mixed
     */
    public $VoluntaryChanges;
    /**
     * The FareDisplayCurrency
     * Meta information extracted from the WSDL
     * - documentation: Currency in which fare display is requested.
     * - use: optional
     * @var string
     */
    public $FareDisplayCurrency;
    /**
     * The CurrencyOverride
     * Meta information extracted from the WSDL
     * - documentation: Display fare published in other than local selling currency only.
     * - use: optional
     * @var string
     */
    public $CurrencyOverride;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate a level of preference for an associated item.
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * The FareRestriction
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of fare restriction, such as None, Advance Purchase and Change Penalties. Refer to OpenTravel Code List Fare Restriction (FAR).
     * - use: optional
     * @var string
     */
    public $FareRestriction;
    /**
     * The RefundableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, refundable fares are preferred.
     * - use: optional
     * @var bool
     */
    public $RefundableInd;
    /**
     * Constructor method for FareRestrictPref
     * @uses FareRestrictPref::setAdvResTicketing()
     * @uses FareRestrictPref::setStayRestrictions()
     * @uses FareRestrictPref::setVoluntaryChanges()
     * @uses FareRestrictPref::setFareDisplayCurrency()
     * @uses FareRestrictPref::setCurrencyOverride()
     * @uses FareRestrictPref::setPreferLevel()
     * @uses FareRestrictPref::setFareRestriction()
     * @uses FareRestrictPref::setRefundableInd()
     * @param mixed $advResTicketing
     * @param mixed $stayRestrictions
     * @param mixed $voluntaryChanges
     * @param string $fareDisplayCurrency
     * @param string $currencyOverride
     * @param string $preferLevel
     * @param string $fareRestriction
     * @param bool $refundableInd
     */
    public function __construct($advResTicketing = null, $stayRestrictions = null, $voluntaryChanges = null, $fareDisplayCurrency = null, $currencyOverride = null, $preferLevel = null, $fareRestriction = null, $refundableInd = null)
    {
        $this
            ->setAdvResTicketing($advResTicketing)
            ->setStayRestrictions($stayRestrictions)
            ->setVoluntaryChanges($voluntaryChanges)
            ->setFareDisplayCurrency($fareDisplayCurrency)
            ->setCurrencyOverride($currencyOverride)
            ->setPreferLevel($preferLevel)
            ->setFareRestriction($fareRestriction)
            ->setRefundableInd($refundableInd);
    }
    /**
     * Get AdvResTicketing value
     * @return mixed|null
     */
    public function getAdvResTicketing()
    {
        return $this->AdvResTicketing;
    }
    /**
     * Set AdvResTicketing value
     * @param mixed $advResTicketing
     * @return \StructType\FareRestrictPref
     */
    public function setAdvResTicketing($advResTicketing = null)
    {
        $this->AdvResTicketing = $advResTicketing;
        return $this;
    }
    /**
     * Get StayRestrictions value
     * @return mixed|null
     */
    public function getStayRestrictions()
    {
        return $this->StayRestrictions;
    }
    /**
     * Set StayRestrictions value
     * @param mixed $stayRestrictions
     * @return \StructType\FareRestrictPref
     */
    public function setStayRestrictions($stayRestrictions = null)
    {
        $this->StayRestrictions = $stayRestrictions;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return mixed|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param mixed $voluntaryChanges
     * @return \StructType\FareRestrictPref
     */
    public function setVoluntaryChanges($voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Get FareDisplayCurrency value
     * @return string|null
     */
    public function getFareDisplayCurrency()
    {
        return $this->FareDisplayCurrency;
    }
    /**
     * Set FareDisplayCurrency value
     * @param string $fareDisplayCurrency
     * @return \StructType\FareRestrictPref
     */
    public function setFareDisplayCurrency($fareDisplayCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($fareDisplayCurrency) && !is_string($fareDisplayCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareDisplayCurrency, true), gettype($fareDisplayCurrency)), __LINE__);
        }
        $this->FareDisplayCurrency = $fareDisplayCurrency;
        return $this;
    }
    /**
     * Get CurrencyOverride value
     * @return string|null
     */
    public function getCurrencyOverride()
    {
        return $this->CurrencyOverride;
    }
    /**
     * Set CurrencyOverride value
     * @param string $currencyOverride
     * @return \StructType\FareRestrictPref
     */
    public function setCurrencyOverride($currencyOverride = null)
    {
        // validation for constraint: string
        if (!is_null($currencyOverride) && !is_string($currencyOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyOverride, true), gettype($currencyOverride)), __LINE__);
        }
        $this->CurrencyOverride = $currencyOverride;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\FareRestrictPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get FareRestriction value
     * @return string|null
     */
    public function getFareRestriction()
    {
        return $this->FareRestriction;
    }
    /**
     * Set FareRestriction value
     * @param string $fareRestriction
     * @return \StructType\FareRestrictPref
     */
    public function setFareRestriction($fareRestriction = null)
    {
        // validation for constraint: string
        if (!is_null($fareRestriction) && !is_string($fareRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRestriction, true), gettype($fareRestriction)), __LINE__);
        }
        $this->FareRestriction = $fareRestriction;
        return $this;
    }
    /**
     * Get RefundableInd value
     * @return bool|null
     */
    public function getRefundableInd()
    {
        return $this->RefundableInd;
    }
    /**
     * Set RefundableInd value
     * @param bool $refundableInd
     * @return \StructType\FareRestrictPref
     */
    public function setRefundableInd($refundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundableInd) && !is_bool($refundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundableInd, true), gettype($refundableInd)), __LINE__);
        }
        $this->RefundableInd = $refundableInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareRestrictPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
