<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FarePref StructType
 * Meta information extracted from the WSDL
 * - documentation: Preferred fare preferences. | Indicates preferred fare.
 * @subpackage Structs
 */
class FarePref extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Code indicating the type of fare preference (e.g., FM=commission, FD=fare discount). May be used to represent a class code. | Code indicating the type of fare preference (e.g., FM=commission, FD=fare discount).
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free text describing the fare preference.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more airlines in AirlinePrefType/VendorPref.
     * - use: optional
     * @var list
     */
    public $AirlineVendorPrefRPH;
    /**
     * The RateCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Provides a rate category for the fare preference. Refer to OpenTravel code list Rate Category (RTC).
     * - use: optional
     * @var string
     */
    public $RateCategoryCode;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions this element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * The VendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more rail operators.
     * - use: optional
     * @var list
     */
    public $VendorPrefRPH;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate a level of preference for an associated item.
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: A fare basis code.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * Constructor method for FarePref
     * @uses FarePref::setCode()
     * @uses FarePref::setDescription()
     * @uses FarePref::setAirlineVendorPrefRPH()
     * @uses FarePref::setRateCategoryCode()
     * @uses FarePref::setTransferAction()
     * @uses FarePref::setVendorPrefRPH()
     * @uses FarePref::setPreferLevel()
     * @uses FarePref::setFareBasisCode()
     * @param string $code
     * @param string $description
     * @param list $airlineVendorPrefRPH
     * @param string $rateCategoryCode
     * @param string $transferAction
     * @param list $vendorPrefRPH
     * @param string $preferLevel
     * @param string $fareBasisCode
     */
    public function __construct($code = null, $description = null, list $airlineVendorPrefRPH = null, $rateCategoryCode = null, $transferAction = null, list $vendorPrefRPH = null, $preferLevel = null, $fareBasisCode = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setRateCategoryCode($rateCategoryCode)
            ->setTransferAction($transferAction)
            ->setVendorPrefRPH($vendorPrefRPH)
            ->setPreferLevel($preferLevel)
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\FarePref
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\FarePref
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return list|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param list $airlineVendorPrefRPH
     * @return \StructType\FarePref
     */
    public function setAirlineVendorPrefRPH(list $airlineVendorPrefRPH = null)
    {
        $this->AirlineVendorPrefRPH = $airlineVendorPrefRPH;
        return $this;
    }
    /**
     * Get RateCategoryCode value
     * @return string|null
     */
    public function getRateCategoryCode()
    {
        return $this->RateCategoryCode;
    }
    /**
     * Set RateCategoryCode value
     * @param string $rateCategoryCode
     * @return \StructType\FarePref
     */
    public function setRateCategoryCode($rateCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategoryCode) && !is_string($rateCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCategoryCode, true), gettype($rateCategoryCode)), __LINE__);
        }
        $this->RateCategoryCode = $rateCategoryCode;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\FarePref
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get VendorPrefRPH value
     * @return list|null
     */
    public function getVendorPrefRPH()
    {
        return $this->VendorPrefRPH;
    }
    /**
     * Set VendorPrefRPH value
     * @param list $vendorPrefRPH
     * @return \StructType\FarePref
     */
    public function setVendorPrefRPH(list $vendorPrefRPH = null)
    {
        $this->VendorPrefRPH = $vendorPrefRPH;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\FarePref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FarePref
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FarePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
