<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Rules for this priced option.
 * @subpackage Structs
 */
class FareInfoType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: Departure Date for this priced fare.
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The FareReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FareReference[]
     */
    public $FareReference;
    /**
     * The RuleInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RuleInfo
     */
    public $RuleInfo;
    /**
     * The FilingAirline
     * Meta information extracted from the WSDL
     * - documentation: The airline that filed the fare(s).
     * - minOccurs: 0
     * @var mixed
     */
    public $FilingAirline;
    /**
     * The MarketingAirline
     * Meta information extracted from the WSDL
     * - documentation: The marketing airline.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MarketingAirline;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * - minOccurs: 0
     * @var mixed
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * - minOccurs: 0
     * @var mixed
     */
    public $ArrivalAirport;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Date[]
     */
    public $Date;
    /**
     * The FareInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 15
     * - minOccurs: 0
     * @var \StructType\FareInfo[]
     */
    public $FareInfo;
    /**
     * The DiscountPricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DiscountPricing
     */
    public $DiscountPricing;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\City[]
     */
    public $City;
    /**
     * The Airport
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Airport[]
     */
    public $Airport;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The ISO 4217 currency code associated with the fare rule information.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The TariffNumber
     * Meta information extracted from the WSDL
     * - documentation: The tariff number for the rule.
     * - use: optional
     * @var string
     */
    public $TariffNumber;
    /**
     * The RuleNumber
     * Meta information extracted from the WSDL
     * - documentation: The number associated with the fare rule.
     * - use: optional
     * @var string
     */
    public $RuleNumber;
    /**
     * The RoutingNumber
     * Meta information extracted from the WSDL
     * - documentation: The routing number applicable to this fare.
     * - use: optional
     * @var int
     */
    public $RoutingNumber;
    /**
     * The NbrOfCities
     * Meta information extracted from the WSDL
     * - documentation: The number of cities applicable to this fare.
     * - use: optional
     * @var int
     */
    public $NbrOfCities;
    /**
     * Constructor method for FareInfoType
     * @uses FareInfoType::setDepartureDate()
     * @uses FareInfoType::setFareReference()
     * @uses FareInfoType::setRuleInfo()
     * @uses FareInfoType::setFilingAirline()
     * @uses FareInfoType::setMarketingAirline()
     * @uses FareInfoType::setDepartureAirport()
     * @uses FareInfoType::setArrivalAirport()
     * @uses FareInfoType::setDate()
     * @uses FareInfoType::setFareInfo()
     * @uses FareInfoType::setDiscountPricing()
     * @uses FareInfoType::setCity()
     * @uses FareInfoType::setAirport()
     * @uses FareInfoType::setCurrencyCode()
     * @uses FareInfoType::setTariffNumber()
     * @uses FareInfoType::setRuleNumber()
     * @uses FareInfoType::setRoutingNumber()
     * @uses FareInfoType::setNbrOfCities()
     * @param string $departureDate
     * @param \StructType\FareReference[] $fareReference
     * @param \StructType\RuleInfo $ruleInfo
     * @param mixed $filingAirline
     * @param mixed[] $marketingAirline
     * @param mixed $departureAirport
     * @param mixed $arrivalAirport
     * @param \StructType\Date[] $date
     * @param \StructType\FareInfo[] $fareInfo
     * @param \StructType\DiscountPricing $discountPricing
     * @param \StructType\City[] $city
     * @param \StructType\Airport[] $airport
     * @param string $currencyCode
     * @param string $tariffNumber
     * @param string $ruleNumber
     * @param int $routingNumber
     * @param int $nbrOfCities
     */
    public function __construct($departureDate = null, array $fareReference = array(), \StructType\RuleInfo $ruleInfo = null, $filingAirline = null, array $marketingAirline = array(), $departureAirport = null, $arrivalAirport = null, array $date = array(), array $fareInfo = array(), \StructType\DiscountPricing $discountPricing = null, array $city = array(), array $airport = array(), $currencyCode = null, $tariffNumber = null, $ruleNumber = null, $routingNumber = null, $nbrOfCities = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFareReference($fareReference)
            ->setRuleInfo($ruleInfo)
            ->setFilingAirline($filingAirline)
            ->setMarketingAirline($marketingAirline)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setDate($date)
            ->setFareInfo($fareInfo)
            ->setDiscountPricing($discountPricing)
            ->setCity($city)
            ->setAirport($airport)
            ->setCurrencyCode($currencyCode)
            ->setTariffNumber($tariffNumber)
            ->setRuleNumber($ruleNumber)
            ->setRoutingNumber($routingNumber)
            ->setNbrOfCities($nbrOfCities);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FareInfoType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FareReference value
     * @return \StructType\FareReference[]|null
     */
    public function getFareReference()
    {
        return $this->FareReference;
    }
    /**
     * This method is responsible for validating the values passed to the setFareReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareReferenceForArrayConstraintsFromSetFareReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoTypeFareReferenceItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeFareReferenceItem instanceof \StructType\FareReference) {
                $invalidValues[] = is_object($fareInfoTypeFareReferenceItem) ? get_class($fareInfoTypeFareReferenceItem) : sprintf('%s(%s)', gettype($fareInfoTypeFareReferenceItem), var_export($fareInfoTypeFareReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareReference property can only contain items of type \StructType\FareReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FareReference[] $fareReference
     * @return \StructType\FareInfoType
     */
    public function setFareReference(array $fareReference = array())
    {
        // validation for constraint: array
        if ('' !== ($fareReferenceArrayErrorMessage = self::validateFareReferenceForArrayConstraintsFromSetFareReference($fareReference))) {
            throw new \InvalidArgumentException($fareReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($fareReference) && count($fareReference) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($fareReference)), __LINE__);
        }
        $this->FareReference = $fareReference;
        return $this;
    }
    /**
     * Add item to FareReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FareReference $item
     * @return \StructType\FareInfoType
     */
    public function addToFareReference(\StructType\FareReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareReference) {
            throw new \InvalidArgumentException(sprintf('The FareReference property can only contain items of type \StructType\FareReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->FareReference) && count($this->FareReference) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->FareReference)), __LINE__);
        }
        $this->FareReference[] = $item;
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \StructType\RuleInfo|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \StructType\RuleInfo $ruleInfo
     * @return \StructType\FareInfoType
     */
    public function setRuleInfo(\StructType\RuleInfo $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get FilingAirline value
     * @return mixed|null
     */
    public function getFilingAirline()
    {
        return $this->FilingAirline;
    }
    /**
     * Set FilingAirline value
     * @param mixed $filingAirline
     * @return \StructType\FareInfoType
     */
    public function setFilingAirline($filingAirline = null)
    {
        $this->FilingAirline = $filingAirline;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return mixed[]|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingAirline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingAirline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingAirlineForArrayConstraintsFromSetMarketingAirline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoTypeMarketingAirlineItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($fareInfoTypeMarketingAirlineItem) ? get_class($fareInfoTypeMarketingAirlineItem) : sprintf('%s(%s)', gettype($fareInfoTypeMarketingAirlineItem), var_export($fareInfoTypeMarketingAirlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingAirline property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingAirline value
     * @throws \InvalidArgumentException
     * @param mixed[] $marketingAirline
     * @return \StructType\FareInfoType
     */
    public function setMarketingAirline(array $marketingAirline = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingAirlineArrayErrorMessage = self::validateMarketingAirlineForArrayConstraintsFromSetMarketingAirline($marketingAirline))) {
            throw new \InvalidArgumentException($marketingAirlineArrayErrorMessage, __LINE__);
        }
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Add item to MarketingAirline value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FareInfoType
     */
    public function addToMarketingAirline($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MarketingAirline property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingAirline[] = $item;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return mixed|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param mixed $departureAirport
     * @return \StructType\FareInfoType
     */
    public function setDepartureAirport($departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return mixed|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param mixed $arrivalAirport
     * @return \StructType\FareInfoType
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Date[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the values passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForArrayConstraintsFromSetDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoTypeDateItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeDateItem instanceof \StructType\Date) {
                $invalidValues[] = is_object($fareInfoTypeDateItem) ? get_class($fareInfoTypeDateItem) : sprintf('%s(%s)', gettype($fareInfoTypeDateItem), var_export($fareInfoTypeDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Date property can only contain items of type \StructType\Date, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $date
     * @return \StructType\FareInfoType
     */
    public function setDate(array $date = array())
    {
        // validation for constraint: array
        if ('' !== ($dateArrayErrorMessage = self::validateDateForArrayConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($date) && count($date) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\FareInfoType
     */
    public function addToDate(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of type \StructType\Date, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Date) && count($this->Date) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Date)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setFareInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareInfoForArrayConstraintsFromSetFareInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoTypeFareInfoItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeFareInfoItem instanceof \StructType\FareInfo) {
                $invalidValues[] = is_object($fareInfoTypeFareInfoItem) ? get_class($fareInfoTypeFareInfoItem) : sprintf('%s(%s)', gettype($fareInfoTypeFareInfoItem), var_export($fareInfoTypeFareInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareInfo property can only contain items of type \StructType\FareInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo[] $fareInfo
     * @return \StructType\FareInfoType
     */
    public function setFareInfo(array $fareInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($fareInfoArrayErrorMessage = self::validateFareInfoForArrayConstraintsFromSetFareInfo($fareInfo))) {
            throw new \InvalidArgumentException($fareInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($fareInfo) && count($fareInfo) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 15', count($fareInfo)), __LINE__);
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo $item
     * @return \StructType\FareInfoType
     */
    public function addToFareInfo(\StructType\FareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of type \StructType\FareInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($this->FareInfo) && count($this->FareInfo) >= 15) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 15', count($this->FareInfo)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Get DiscountPricing value
     * @return \StructType\DiscountPricing|null
     */
    public function getDiscountPricing()
    {
        return $this->DiscountPricing;
    }
    /**
     * Set DiscountPricing value
     * @param \StructType\DiscountPricing $discountPricing
     * @return \StructType\FareInfoType
     */
    public function setDiscountPricing(\StructType\DiscountPricing $discountPricing = null)
    {
        $this->DiscountPricing = $discountPricing;
        return $this;
    }
    /**
     * Get City value
     * @return \StructType\City[]|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * This method is responsible for validating the values passed to the setCity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCityForArrayConstraintsFromSetCity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoTypeCityItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeCityItem instanceof \StructType\City) {
                $invalidValues[] = is_object($fareInfoTypeCityItem) ? get_class($fareInfoTypeCityItem) : sprintf('%s(%s)', gettype($fareInfoTypeCityItem), var_export($fareInfoTypeCityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The City property can only contain items of type \StructType\City, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set City value
     * @throws \InvalidArgumentException
     * @param \StructType\City[] $city
     * @return \StructType\FareInfoType
     */
    public function setCity(array $city = array())
    {
        // validation for constraint: array
        if ('' !== ($cityArrayErrorMessage = self::validateCityForArrayConstraintsFromSetCity($city))) {
            throw new \InvalidArgumentException($cityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($city) && count($city) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Add item to City value
     * @throws \InvalidArgumentException
     * @param \StructType\City $item
     * @return \StructType\FareInfoType
     */
    public function addToCity(\StructType\City $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\City) {
            throw new \InvalidArgumentException(sprintf('The City property can only contain items of type \StructType\City, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->City) && count($this->City) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->City)), __LINE__);
        }
        $this->City[] = $item;
        return $this;
    }
    /**
     * Get Airport value
     * @return \StructType\Airport[]|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * This method is responsible for validating the values passed to the setAirport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirportForArrayConstraintsFromSetAirport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoTypeAirportItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeAirportItem instanceof \StructType\Airport) {
                $invalidValues[] = is_object($fareInfoTypeAirportItem) ? get_class($fareInfoTypeAirportItem) : sprintf('%s(%s)', gettype($fareInfoTypeAirportItem), var_export($fareInfoTypeAirportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airport property can only contain items of type \StructType\Airport, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airport value
     * @throws \InvalidArgumentException
     * @param \StructType\Airport[] $airport
     * @return \StructType\FareInfoType
     */
    public function setAirport(array $airport = array())
    {
        // validation for constraint: array
        if ('' !== ($airportArrayErrorMessage = self::validateAirportForArrayConstraintsFromSetAirport($airport))) {
            throw new \InvalidArgumentException($airportArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($airport) && count($airport) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($airport)), __LINE__);
        }
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Add item to Airport value
     * @throws \InvalidArgumentException
     * @param \StructType\Airport $item
     * @return \StructType\FareInfoType
     */
    public function addToAirport(\StructType\Airport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Airport) {
            throw new \InvalidArgumentException(sprintf('The Airport property can only contain items of type \StructType\Airport, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Airport) && count($this->Airport) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Airport)), __LINE__);
        }
        $this->Airport[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\FareInfoType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get TariffNumber value
     * @return string|null
     */
    public function getTariffNumber()
    {
        return $this->TariffNumber;
    }
    /**
     * Set TariffNumber value
     * @param string $tariffNumber
     * @return \StructType\FareInfoType
     */
    public function setTariffNumber($tariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tariffNumber) && !is_string($tariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffNumber, true), gettype($tariffNumber)), __LINE__);
        }
        $this->TariffNumber = $tariffNumber;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \StructType\FareInfoType
     */
    public function setRuleNumber($ruleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ruleNumber) && !is_string($ruleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleNumber, true), gettype($ruleNumber)), __LINE__);
        }
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return int|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param int $routingNumber
     * @return \StructType\FareInfoType
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: int
        if (!is_null($routingNumber) && !(is_int($routingNumber) || ctype_digit($routingNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routingNumber, true), gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get NbrOfCities value
     * @return int|null
     */
    public function getNbrOfCities()
    {
        return $this->NbrOfCities;
    }
    /**
     * Set NbrOfCities value
     * @param int $nbrOfCities
     * @return \StructType\FareInfoType
     */
    public function setNbrOfCities($nbrOfCities = null)
    {
        // validation for constraint: int
        if (!is_null($nbrOfCities) && !(is_int($nbrOfCities) || ctype_digit($nbrOfCities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbrOfCities, true), gettype($nbrOfCities)), __LINE__);
        }
        $this->NbrOfCities = $nbrOfCities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
