<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Fares and related information for this fare rule.
 * @subpackage Structs
 */
class FareDetails extends AbstractStructBase
{
    /**
     * The GlobalIndicatorCode
     * Meta information extracted from the WSDL
     * - documentation: Example: AP | Fare rule global direction.
     * - minOccurs: 0
     * @var mixed
     */
    public $GlobalIndicatorCode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Example: Create/Add | Required modification type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Operation;
    /**
     * The FareStatus
     * Meta information extracted from the WSDL
     * - documentation: Example: Published | Fare status.
     * - minOccurs: 0
     * @var mixed
     */
    public $FareStatus;
    /**
     * The TripType
     * Meta information extracted from the WSDL
     * - documentation: Example: OneWay | Trip type.
     * - minOccurs: 0
     * @var mixed
     */
    public $TripType;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Date[]
     */
    public $Date;
    /**
     * The Fare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fare
     */
    public $Fare;
    /**
     * The PassengerType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PassengerType[]
     */
    public $PassengerType;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Example: HL7LNR | Fare basis code.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareDescription
     * Meta information extracted from the WSDL
     * - documentation: Example: ORLLAS-AA | Fare description.
     * - use: optional
     * @var string
     */
    public $FareDescription;
    /**
     * The FareType
     * Meta information extracted from the WSDL
     * - documentation: Example: NLX | Fare type.
     * - use: optional
     * @var string
     */
    public $FareType;
    /**
     * The MaxPermittedMileage
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the maximum mileage (in miles) that can be travelled under this fare. | Example: 2317 | Description: Maximum miles.
     * - use: optional
     * @var int
     */
    public $MaxPermittedMileage;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Note: This is a reference to a specific FareInfo item between an air modification request and the existing air reservation. | Example: 1 | Fare reference.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for FareDetails
     * @uses FareDetails::setGlobalIndicatorCode()
     * @uses FareDetails::setOperation()
     * @uses FareDetails::setFareStatus()
     * @uses FareDetails::setTripType()
     * @uses FareDetails::setDate()
     * @uses FareDetails::setFare()
     * @uses FareDetails::setPassengerType()
     * @uses FareDetails::setFareBasisCode()
     * @uses FareDetails::setFareDescription()
     * @uses FareDetails::setFareType()
     * @uses FareDetails::setMaxPermittedMileage()
     * @uses FareDetails::setRPH()
     * @param mixed $globalIndicatorCode
     * @param mixed $operation
     * @param mixed $fareStatus
     * @param mixed $tripType
     * @param \StructType\Date[] $date
     * @param \StructType\Fare $fare
     * @param \StructType\PassengerType[] $passengerType
     * @param string $fareBasisCode
     * @param string $fareDescription
     * @param string $fareType
     * @param int $maxPermittedMileage
     * @param string $rPH
     */
    public function __construct($globalIndicatorCode = null, $operation = null, $fareStatus = null, $tripType = null, array $date = array(), \StructType\Fare $fare = null, array $passengerType = array(), $fareBasisCode = null, $fareDescription = null, $fareType = null, $maxPermittedMileage = null, $rPH = null)
    {
        $this
            ->setGlobalIndicatorCode($globalIndicatorCode)
            ->setOperation($operation)
            ->setFareStatus($fareStatus)
            ->setTripType($tripType)
            ->setDate($date)
            ->setFare($fare)
            ->setPassengerType($passengerType)
            ->setFareBasisCode($fareBasisCode)
            ->setFareDescription($fareDescription)
            ->setFareType($fareType)
            ->setMaxPermittedMileage($maxPermittedMileage)
            ->setRPH($rPH);
    }
    /**
     * Get GlobalIndicatorCode value
     * @return mixed|null
     */
    public function getGlobalIndicatorCode()
    {
        return $this->GlobalIndicatorCode;
    }
    /**
     * Set GlobalIndicatorCode value
     * @param mixed $globalIndicatorCode
     * @return \StructType\FareDetails
     */
    public function setGlobalIndicatorCode($globalIndicatorCode = null)
    {
        $this->GlobalIndicatorCode = $globalIndicatorCode;
        return $this;
    }
    /**
     * Get Operation value
     * @return mixed|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param mixed $operation
     * @return \StructType\FareDetails
     */
    public function setOperation($operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return mixed|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @param mixed $fareStatus
     * @return \StructType\FareDetails
     */
    public function setFareStatus($fareStatus = null)
    {
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Get TripType value
     * @return mixed|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @param mixed $tripType
     * @return \StructType\FareDetails
     */
    public function setTripType($tripType = null)
    {
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Date[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the values passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForArrayConstraintsFromSetDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareDetailsDateItem) {
            // validation for constraint: itemType
            if (!$fareDetailsDateItem instanceof \StructType\Date) {
                $invalidValues[] = is_object($fareDetailsDateItem) ? get_class($fareDetailsDateItem) : sprintf('%s(%s)', gettype($fareDetailsDateItem), var_export($fareDetailsDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Date property can only contain items of type \StructType\Date, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $date
     * @return \StructType\FareDetails
     */
    public function setDate(array $date = array())
    {
        // validation for constraint: array
        if ('' !== ($dateArrayErrorMessage = self::validateDateForArrayConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateArrayErrorMessage, __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\FareDetails
     */
    public function addToDate(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of type \StructType\Date, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get Fare value
     * @return \StructType\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \StructType\Fare $fare
     * @return \StructType\FareDetails
     */
    public function setFare(\StructType\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \StructType\PassengerType[]|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerTypeForArrayConstraintsFromSetPassengerType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareDetailsPassengerTypeItem) {
            // validation for constraint: itemType
            if (!$fareDetailsPassengerTypeItem instanceof \StructType\PassengerType) {
                $invalidValues[] = is_object($fareDetailsPassengerTypeItem) ? get_class($fareDetailsPassengerTypeItem) : sprintf('%s(%s)', gettype($fareDetailsPassengerTypeItem), var_export($fareDetailsPassengerTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerType property can only contain items of type \StructType\PassengerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerType value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerType[] $passengerType
     * @return \StructType\FareDetails
     */
    public function setPassengerType(array $passengerType = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerTypeArrayErrorMessage = self::validatePassengerTypeForArrayConstraintsFromSetPassengerType($passengerType))) {
            throw new \InvalidArgumentException($passengerTypeArrayErrorMessage, __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Add item to PassengerType value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerType $item
     * @return \StructType\FareDetails
     */
    public function addToPassengerType(\StructType\PassengerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerType) {
            throw new \InvalidArgumentException(sprintf('The PassengerType property can only contain items of type \StructType\PassengerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PassengerType[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareDetails
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareDescription value
     * @return string|null
     */
    public function getFareDescription()
    {
        return $this->FareDescription;
    }
    /**
     * Set FareDescription value
     * @param string $fareDescription
     * @return \StructType\FareDetails
     */
    public function setFareDescription($fareDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fareDescription) && !is_string($fareDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareDescription, true), gettype($fareDescription)), __LINE__);
        }
        $this->FareDescription = $fareDescription;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \StructType\FareDetails
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareType, true), gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get MaxPermittedMileage value
     * @return int|null
     */
    public function getMaxPermittedMileage()
    {
        return $this->MaxPermittedMileage;
    }
    /**
     * Set MaxPermittedMileage value
     * @param int $maxPermittedMileage
     * @return \StructType\FareDetails
     */
    public function setMaxPermittedMileage($maxPermittedMileage = null)
    {
        // validation for constraint: int
        if (!is_null($maxPermittedMileage) && !(is_int($maxPermittedMileage) || ctype_digit($maxPermittedMileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPermittedMileage, true), gettype($maxPermittedMileage)), __LINE__);
        }
        $this->MaxPermittedMileage = $maxPermittedMileage;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\FareDetails
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
