<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The total number of fare components within the fare component calculation. | Information representing sold data supporting the fare construction applicable to each fare component in a transaction.
 * @subpackage Structs
 */
class FareComponentType extends AbstractStructBase
{
    /**
     * The PriceableUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\PriceableUnit[]
     */
    public $PriceableUnit;
    /**
     * The TotalConstructionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * @var \StructType\TotalConstructionAmount[]
     */
    public $TotalConstructionAmount;
    /**
     * The PriceQuoteDate
     * Meta information extracted from the WSDL
     * - documentation: The date on which the fare was calculated and quoted.
     * - use: optional
     * @var string
     */
    public $PriceQuoteDate;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: A qualifier for pricing to select fares.
     * - use: optional
     * @var string
     */
    public $AccountCode;
    /**
     * The PricingDesignator
     * Meta information extracted from the WSDL
     * - documentation: A qualifier for pricing to select fares.
     * - use: optional
     * @var string
     */
    public $PricingDesignator;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - documentation: A published value used to convert a NUC amount to the currency of commencement of travel.
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * Constructor method for FareComponentType
     * @uses FareComponentType::setPriceableUnit()
     * @uses FareComponentType::setTotalConstructionAmount()
     * @uses FareComponentType::setPriceQuoteDate()
     * @uses FareComponentType::setAccountCode()
     * @uses FareComponentType::setPricingDesignator()
     * @uses FareComponentType::setExchangeRate()
     * @param \StructType\PriceableUnit[] $priceableUnit
     * @param \StructType\TotalConstructionAmount[] $totalConstructionAmount
     * @param string $priceQuoteDate
     * @param string $accountCode
     * @param string $pricingDesignator
     * @param float $exchangeRate
     */
    public function __construct(array $priceableUnit = array(), array $totalConstructionAmount = array(), $priceQuoteDate = null, $accountCode = null, $pricingDesignator = null, $exchangeRate = null)
    {
        $this
            ->setPriceableUnit($priceableUnit)
            ->setTotalConstructionAmount($totalConstructionAmount)
            ->setPriceQuoteDate($priceQuoteDate)
            ->setAccountCode($accountCode)
            ->setPricingDesignator($pricingDesignator)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get PriceableUnit value
     * @return \StructType\PriceableUnit[]|null
     */
    public function getPriceableUnit()
    {
        return $this->PriceableUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceableUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceableUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceableUnitForArrayConstraintsFromSetPriceableUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentTypePriceableUnitItem) {
            // validation for constraint: itemType
            if (!$fareComponentTypePriceableUnitItem instanceof \StructType\PriceableUnit) {
                $invalidValues[] = is_object($fareComponentTypePriceableUnitItem) ? get_class($fareComponentTypePriceableUnitItem) : sprintf('%s(%s)', gettype($fareComponentTypePriceableUnitItem), var_export($fareComponentTypePriceableUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceableUnit property can only contain items of type \StructType\PriceableUnit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceableUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceableUnit[] $priceableUnit
     * @return \StructType\FareComponentType
     */
    public function setPriceableUnit(array $priceableUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($priceableUnitArrayErrorMessage = self::validatePriceableUnitForArrayConstraintsFromSetPriceableUnit($priceableUnit))) {
            throw new \InvalidArgumentException($priceableUnitArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($priceableUnit) && count($priceableUnit) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($priceableUnit)), __LINE__);
        }
        $this->PriceableUnit = $priceableUnit;
        return $this;
    }
    /**
     * Add item to PriceableUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceableUnit $item
     * @return \StructType\FareComponentType
     */
    public function addToPriceableUnit(\StructType\PriceableUnit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceableUnit) {
            throw new \InvalidArgumentException(sprintf('The PriceableUnit property can only contain items of type \StructType\PriceableUnit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PriceableUnit) && count($this->PriceableUnit) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PriceableUnit)), __LINE__);
        }
        $this->PriceableUnit[] = $item;
        return $this;
    }
    /**
     * Get TotalConstructionAmount value
     * @return \StructType\TotalConstructionAmount[]|null
     */
    public function getTotalConstructionAmount()
    {
        return $this->TotalConstructionAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalConstructionAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalConstructionAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalConstructionAmountForArrayConstraintsFromSetTotalConstructionAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentTypeTotalConstructionAmountItem) {
            // validation for constraint: itemType
            if (!$fareComponentTypeTotalConstructionAmountItem instanceof \StructType\TotalConstructionAmount) {
                $invalidValues[] = is_object($fareComponentTypeTotalConstructionAmountItem) ? get_class($fareComponentTypeTotalConstructionAmountItem) : sprintf('%s(%s)', gettype($fareComponentTypeTotalConstructionAmountItem), var_export($fareComponentTypeTotalConstructionAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalConstructionAmount property can only contain items of type \StructType\TotalConstructionAmount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalConstructionAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalConstructionAmount[] $totalConstructionAmount
     * @return \StructType\FareComponentType
     */
    public function setTotalConstructionAmount(array $totalConstructionAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($totalConstructionAmountArrayErrorMessage = self::validateTotalConstructionAmountForArrayConstraintsFromSetTotalConstructionAmount($totalConstructionAmount))) {
            throw new \InvalidArgumentException($totalConstructionAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($totalConstructionAmount) && count($totalConstructionAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($totalConstructionAmount)), __LINE__);
        }
        $this->TotalConstructionAmount = $totalConstructionAmount;
        return $this;
    }
    /**
     * Add item to TotalConstructionAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalConstructionAmount $item
     * @return \StructType\FareComponentType
     */
    public function addToTotalConstructionAmount(\StructType\TotalConstructionAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalConstructionAmount) {
            throw new \InvalidArgumentException(sprintf('The TotalConstructionAmount property can only contain items of type \StructType\TotalConstructionAmount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TotalConstructionAmount) && count($this->TotalConstructionAmount) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TotalConstructionAmount)), __LINE__);
        }
        $this->TotalConstructionAmount[] = $item;
        return $this;
    }
    /**
     * Get PriceQuoteDate value
     * @return string|null
     */
    public function getPriceQuoteDate()
    {
        return $this->PriceQuoteDate;
    }
    /**
     * Set PriceQuoteDate value
     * @param string $priceQuoteDate
     * @return \StructType\FareComponentType
     */
    public function setPriceQuoteDate($priceQuoteDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceQuoteDate) && !is_string($priceQuoteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceQuoteDate, true), gettype($priceQuoteDate)), __LINE__);
        }
        $this->PriceQuoteDate = $priceQuoteDate;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\FareComponentType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get PricingDesignator value
     * @return string|null
     */
    public function getPricingDesignator()
    {
        return $this->PricingDesignator;
    }
    /**
     * Set PricingDesignator value
     * @param string $pricingDesignator
     * @return \StructType\FareComponentType
     */
    public function setPricingDesignator($pricingDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($pricingDesignator) && !is_string($pricingDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingDesignator, true), gettype($pricingDesignator)), __LINE__);
        }
        $this->PricingDesignator = $pricingDesignator;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\FareComponentType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareComponentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
