<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBaggageAllowance StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage allowance for this fare. | Checked baggage allowance for the fare.
 * @subpackage Structs
 */
class FareBaggageAllowance extends AbstractStructBase
{
    /**
     * The FlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: The segment this baggage allowance is associated with.
     * - use: optional
     * @var string
     */
    public $FlightSegmentRPH;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for FareBaggageAllowance
     * @uses FareBaggageAllowance::setFlightSegmentRPH()
     * @uses FareBaggageAllowance::setOperation()
     * @param string $flightSegmentRPH
     * @param string $operation
     */
    public function __construct($flightSegmentRPH = null, $operation = null)
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH)
            ->setOperation($operation);
    }
    /**
     * Get FlightSegmentRPH value
     * @return string|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @param string $flightSegmentRPH
     * @return \StructType\FareBaggageAllowance
     */
    public function setFlightSegmentRPH($flightSegmentRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightSegmentRPH) && !is_string($flightSegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightSegmentRPH, true), gettype($flightSegmentRPH)), __LINE__);
        }
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\FareBaggageAllowance
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareBaggageAllowance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
