<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fare StructType
 * Meta information extracted from the WSDL
 * - documentation: Fare amounts. | The base and total fare and tax amounts associated with the rule.
 * @subpackage Structs
 */
class Fare extends AbstractStructBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Example: 2450.00 | Base amount. | The base amount of the fare.
     * - use: optional
     * @var float
     */
    public $BaseAmount;
    /**
     * The BaseNUC_Amount
     * Meta information extracted from the WSDL
     * - documentation: Definition: A common denominator used to calculate a total when adding fares in different currencies. | Example: 1.25 | Base neutral unit of construction amount. | The base neutral unit of construction amount.
     * - use: optional
     * @var float
     */
    public $BaseNUC_Amount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Example: 25.00 | Tax amount. | The tax amount for the fare associated to the rule.
     * - use: optional
     * @var float
     */
    public $TaxAmount;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - documentation: Example: 2475.00 | Total fare. | The total fare associated to the rule.
     * - use: optional
     * @var float
     */
    public $TotalFare;
    /**
     * The FareDescription
     * Meta information extracted from the WSDL
     * - documentation: A description of the fare.
     * - use: optional
     * @var string
     */
    public $FareDescription;
    /**
     * Constructor method for Fare
     * @uses Fare::setBaseAmount()
     * @uses Fare::setBaseNUC_Amount()
     * @uses Fare::setTaxAmount()
     * @uses Fare::setTotalFare()
     * @uses Fare::setFareDescription()
     * @param float $baseAmount
     * @param float $baseNUC_Amount
     * @param float $taxAmount
     * @param float $totalFare
     * @param string $fareDescription
     */
    public function __construct($baseAmount = null, $baseNUC_Amount = null, $taxAmount = null, $totalFare = null, $fareDescription = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setBaseNUC_Amount($baseNUC_Amount)
            ->setTaxAmount($taxAmount)
            ->setTotalFare($totalFare)
            ->setFareDescription($fareDescription);
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \StructType\Fare
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get BaseNUC_Amount value
     * @return float|null
     */
    public function getBaseNUC_Amount()
    {
        return $this->BaseNUC_Amount;
    }
    /**
     * Set BaseNUC_Amount value
     * @param float $baseNUC_Amount
     * @return \StructType\Fare
     */
    public function setBaseNUC_Amount($baseNUC_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($baseNUC_Amount) && !(is_float($baseNUC_Amount) || is_numeric($baseNUC_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseNUC_Amount, true), gettype($baseNUC_Amount)), __LINE__);
        }
        $this->BaseNUC_Amount = $baseNUC_Amount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\Fare
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return float|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param float $totalFare
     * @return \StructType\Fare
     */
    public function setTotalFare($totalFare = null)
    {
        // validation for constraint: float
        if (!is_null($totalFare) && !(is_float($totalFare) || is_numeric($totalFare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFare, true), gettype($totalFare)), __LINE__);
        }
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get FareDescription value
     * @return string|null
     */
    public function getFareDescription()
    {
        return $this->FareDescription;
    }
    /**
     * Set FareDescription value
     * @param string $fareDescription
     * @return \StructType\Fare
     */
    public function setFareDescription($fareDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fareDescription) && !is_string($fareDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareDescription, true), gettype($fareDescription)), __LINE__);
        }
        $this->FareDescription = $fareDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
