<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Extras StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Extras requests. | A collection of requested/booked Extras.
 * @subpackage Structs
 */
class Extras extends AbstractStructBase
{
    /**
     * The Extra
     * Meta information extracted from the WSDL
     * - documentation: Describes an optional service which is not included in the standard package but may be booked in addition. | Describes an optional service which is not included in the standard package but has been requested in addition.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Extra;
    /**
     * Constructor method for Extras
     * @uses Extras::setExtra()
     * @param mixed[] $extra
     */
    public function __construct(array $extra = array())
    {
        $this
            ->setExtra($extra);
    }
    /**
     * Get Extra value
     * @return mixed[]|null
     */
    public function getExtra()
    {
        return $this->Extra;
    }
    /**
     * This method is responsible for validating the values passed to the setExtra method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtra method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtraForArrayConstraintsFromSetExtra(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extrasExtraItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($extrasExtraItem) ? get_class($extrasExtraItem) : sprintf('%s(%s)', gettype($extrasExtraItem), var_export($extrasExtraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Extra property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Extra value
     * @throws \InvalidArgumentException
     * @param mixed[] $extra
     * @return \StructType\Extras
     */
    public function setExtra(array $extra = array())
    {
        // validation for constraint: array
        if ('' !== ($extraArrayErrorMessage = self::validateExtraForArrayConstraintsFromSetExtra($extra))) {
            throw new \InvalidArgumentException($extraArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($extra) && count($extra) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($extra)), __LINE__);
        }
        $this->Extra = $extra;
        return $this;
    }
    /**
     * Add item to Extra value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Extras
     */
    public function addToExtra($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Extra property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Extra) && count($this->Extra) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Extra)), __LINE__);
        }
        $this->Extra[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Extras
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
