<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtraLocationInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates where the extra can be obtained and returned, (e.g., airport, property or resort).
 * @subpackage Structs
 */
class ExtraLocationInfo extends AbstractStructBase
{
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - documentation: Where the extra may be collected from and returned to. Refer to OpenTravel Code List Vehicle Where at Facility (VWF)
     * - use: optional
     * @var string
     */
    public $Location;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ExtraLocationInfo
     * @uses ExtraLocationInfo::setLocation()
     * @uses ExtraLocationInfo::setType()
     * @param string $location
     * @param string $type
     */
    public function __construct($location = null, $type = null)
    {
        $this
            ->setLocation($location)
            ->setType($type);
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\ExtraLocationInfo
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ExtraLocationInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtraLocationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
