<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncryptionTokenType StructType
 * Meta information extracted from the WSDL
 * - documentation: OpenTravel Best Practice: Use of Encrypted, Masked or Tokenized Information: Certain OpenTravel schema may have combinations payment and/or account information with other personally identifying information, such as customer name and
 * date of birth. For enhanced customer privacy and security, it is RECOMMENDED that the payment and account information be protected, using tokenization or some other encryption method and displayed in a masked format. | Secure information that
 * supports PCI tokens, data masking and other encryption methods.
 * @subpackage Structs
 */
class EncryptionTokenType extends AbstractStructBase
{
    /**
     * The PlainText
     * Meta information extracted from the WSDL
     * - documentation: Non-secure (plain text) value.
     * - minOccurs: 0
     * @var string
     */
    public $PlainText;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Identifies an error that occurred in the processing of the payment card.
     * - minOccurs: 0
     * @var mixed
     */
    public $Warning;
    /**
     * The EncryptionKey
     * Meta information extracted from the WSDL
     * - documentation: Note: This contains a key required to retrieve the full payment instrument details compliant with PCI DSS standards. | Example: KHC32198gt4 | Database key.
     * - use: optional
     * @var string
     */
    public $EncryptionKey;
    /**
     * The EncryptionKeyMethod
     * Meta information extracted from the WSDL
     * - documentation: Developer: This contains a reference to the key generation method being used - this is NOT the key value. | Example: RotatingKeyEnvironment_DailyKey | Encryption key method.
     * - use: optional
     * @var string
     */
    public $EncryptionKeyMethod;
    /**
     * The EncryptionMethod
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Encryption Method: When using the OpenTravel Encryption element, it is RECOMMENDED that all trading partners be informed of all encryption methods being used in advance of implementation to ensure message
     * processing compatibility. | Example: Triple DES | Encryption method.
     * - use: optional
     * @var string
     */
    public $EncryptionMethod;
    /**
     * The EncryptedValue
     * Meta information extracted from the WSDL
     * - documentation: Example: 5dfc52b51bd35553df8592078de921bc | Encrypted value.
     * - use: optional
     * @var string
     */
    public $EncryptedValue;
    /**
     * The Mask
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,32}
     * - use: optional
     * @var string
     */
    public $Mask;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,32}
     * - use: optional
     * @var string
     */
    public $Token;
    /**
     * The TokenProviderID
     * Meta information extracted from the WSDL
     * - documentation: Developer: This contains a provider ID if multiple providers are used for secure information exchange. | Example: Shift4 (payment) | Provider ID.
     * - use: optional
     * @var string
     */
    public $TokenProviderID;
    /**
     * Constructor method for EncryptionTokenType
     * @uses EncryptionTokenType::setPlainText()
     * @uses EncryptionTokenType::setTPA_Extensions()
     * @uses EncryptionTokenType::setWarning()
     * @uses EncryptionTokenType::setEncryptionKey()
     * @uses EncryptionTokenType::setEncryptionKeyMethod()
     * @uses EncryptionTokenType::setEncryptionMethod()
     * @uses EncryptionTokenType::setEncryptedValue()
     * @uses EncryptionTokenType::setMask()
     * @uses EncryptionTokenType::setToken()
     * @uses EncryptionTokenType::setTokenProviderID()
     * @param string $plainText
     * @param mixed $tPA_Extensions
     * @param mixed $warning
     * @param string $encryptionKey
     * @param string $encryptionKeyMethod
     * @param string $encryptionMethod
     * @param string $encryptedValue
     * @param string $mask
     * @param string $token
     * @param string $tokenProviderID
     */
    public function __construct($plainText = null, $tPA_Extensions = null, $warning = null, $encryptionKey = null, $encryptionKeyMethod = null, $encryptionMethod = null, $encryptedValue = null, $mask = null, $token = null, $tokenProviderID = null)
    {
        $this
            ->setPlainText($plainText)
            ->setTPA_Extensions($tPA_Extensions)
            ->setWarning($warning)
            ->setEncryptionKey($encryptionKey)
            ->setEncryptionKeyMethod($encryptionKeyMethod)
            ->setEncryptionMethod($encryptionMethod)
            ->setEncryptedValue($encryptedValue)
            ->setMask($mask)
            ->setToken($token)
            ->setTokenProviderID($tokenProviderID);
    }
    /**
     * Get PlainText value
     * @return string|null
     */
    public function getPlainText()
    {
        return $this->PlainText;
    }
    /**
     * Set PlainText value
     * @param string $plainText
     * @return \StructType\EncryptionTokenType
     */
    public function setPlainText($plainText = null)
    {
        // validation for constraint: string
        if (!is_null($plainText) && !is_string($plainText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plainText, true), gettype($plainText)), __LINE__);
        }
        $this->PlainText = $plainText;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\EncryptionTokenType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Warning value
     * @return mixed|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @param mixed $warning
     * @return \StructType\EncryptionTokenType
     */
    public function setWarning($warning = null)
    {
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Get EncryptionKey value
     * @return string|null
     */
    public function getEncryptionKey()
    {
        return $this->EncryptionKey;
    }
    /**
     * Set EncryptionKey value
     * @param string $encryptionKey
     * @return \StructType\EncryptionTokenType
     */
    public function setEncryptionKey($encryptionKey = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionKey) && !is_string($encryptionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptionKey, true), gettype($encryptionKey)), __LINE__);
        }
        $this->EncryptionKey = $encryptionKey;
        return $this;
    }
    /**
     * Get EncryptionKeyMethod value
     * @return string|null
     */
    public function getEncryptionKeyMethod()
    {
        return $this->EncryptionKeyMethod;
    }
    /**
     * Set EncryptionKeyMethod value
     * @param string $encryptionKeyMethod
     * @return \StructType\EncryptionTokenType
     */
    public function setEncryptionKeyMethod($encryptionKeyMethod = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionKeyMethod) && !is_string($encryptionKeyMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptionKeyMethod, true), gettype($encryptionKeyMethod)), __LINE__);
        }
        $this->EncryptionKeyMethod = $encryptionKeyMethod;
        return $this;
    }
    /**
     * Get EncryptionMethod value
     * @return string|null
     */
    public function getEncryptionMethod()
    {
        return $this->EncryptionMethod;
    }
    /**
     * Set EncryptionMethod value
     * @param string $encryptionMethod
     * @return \StructType\EncryptionTokenType
     */
    public function setEncryptionMethod($encryptionMethod = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionMethod) && !is_string($encryptionMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptionMethod, true), gettype($encryptionMethod)), __LINE__);
        }
        $this->EncryptionMethod = $encryptionMethod;
        return $this;
    }
    /**
     * Get EncryptedValue value
     * @return string|null
     */
    public function getEncryptedValue()
    {
        return $this->EncryptedValue;
    }
    /**
     * Set EncryptedValue value
     * @param string $encryptedValue
     * @return \StructType\EncryptionTokenType
     */
    public function setEncryptedValue($encryptedValue = null)
    {
        // validation for constraint: string
        if (!is_null($encryptedValue) && !is_string($encryptedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptedValue, true), gettype($encryptedValue)), __LINE__);
        }
        $this->EncryptedValue = $encryptedValue;
        return $this;
    }
    /**
     * Get Mask value
     * @return string|null
     */
    public function getMask()
    {
        return $this->Mask;
    }
    /**
     * Set Mask value
     * @param string $mask
     * @return \StructType\EncryptionTokenType
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mask, true), gettype($mask)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,32})
        if (!is_null($mask) && !preg_match('/[0-9a-zA-Z]{1,32}/', $mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,32}', var_export($mask, true)), __LINE__);
        }
        $this->Mask = $mask;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\EncryptionTokenType
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,32})
        if (!is_null($token) && !preg_match('/[0-9a-zA-Z]{1,32}/', $token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,32}', var_export($token, true)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get TokenProviderID value
     * @return string|null
     */
    public function getTokenProviderID()
    {
        return $this->TokenProviderID;
    }
    /**
     * Set TokenProviderID value
     * @param string $tokenProviderID
     * @return \StructType\EncryptionTokenType
     */
    public function setTokenProviderID($tokenProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($tokenProviderID) && !is_string($tokenProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenProviderID, true), gettype($tokenProviderID)), __LINE__);
        }
        $this->TokenProviderID = $tokenProviderID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EncryptionTokenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
