<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EarliestStart StructType
 * Meta information extracted from the WSDL
 * - documentation: Earliest start date/ time for offer availability.
 * @subpackage Structs
 */
class EarliestStart extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - documentation: Example: 2013-01-13T22:00 | Start date or date and time.
     * - use: required
     * @var string
     */
    public $DateTime;
    /**
     * The CalculationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CalculationMethod
     */
    public $CalculationMethod;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for EarliestStart
     * @uses EarliestStart::setDateTime()
     * @uses EarliestStart::setCalculationMethod()
     * @uses EarliestStart::setOntologyExtension()
     * @uses EarliestStart::setOntologyRefID()
     * @param string $dateTime
     * @param \StructType\CalculationMethod $calculationMethod
     * @param mixed $ontologyExtension
     * @param string $ontologyRefID
     */
    public function __construct($dateTime = null, \StructType\CalculationMethod $calculationMethod = null, $ontologyExtension = null, $ontologyRefID = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setCalculationMethod($calculationMethod)
            ->setOntologyExtension($ontologyExtension)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\EarliestStart
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get CalculationMethod value
     * @return \StructType\CalculationMethod|null
     */
    public function getCalculationMethod()
    {
        return $this->CalculationMethod;
    }
    /**
     * Set CalculationMethod value
     * @param \StructType\CalculationMethod $calculationMethod
     * @return \StructType\EarliestStart
     */
    public function setCalculationMethod(\StructType\CalculationMethod $calculationMethod = null)
    {
        $this->CalculationMethod = $calculationMethod;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\EarliestStart
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\EarliestStart
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EarliestStart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
