<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMD_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for electronic miscellaneous document information
 * @subpackage Structs
 */
class EMD_Type extends AbstractStructBase
{
    /**
     * The TotalFltSegQty
     * Meta information extracted from the WSDL
     * - documentation: Total number of flight segments.
     * - use: required
     * @var int
     */
    public $TotalFltSegQty;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber
     */
    public $TravelerRefNumber;
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - documentation: The agent numeric code, booking agent id, issuing agent id and/or servicing airline/system provider ID.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AgentID;
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - documentation: The payment information.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PaymentDetail;
    /**
     * The OriginDestination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginDestination
     */
    public $OriginDestination;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Endorsement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Endorsement
     */
    public $Endorsement;
    /**
     * The AddReferenceID
     * Meta information extracted from the WSDL
     * - documentation: ID contains the actual identifier (e.g. invoice, airline confirmation number, customer id or airline indexing field.)
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AddReferenceID;
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BaseFare[]
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\EquivFare[]
     */
    public $EquivFare;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\TotalFare[]
     */
    public $TotalFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The UnstructuredFareCalc
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\UnstructuredFareCalc[]
     */
    public $UnstructuredFareCalc;
    /**
     * The FareInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareInfo
     */
    public $FareInfo;
    /**
     * The TicketDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\TicketDocument[]
     */
    public $TicketDocument;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Commission
     */
    public $Commission;
    /**
     * The FareComponent
     * Meta information extracted from the WSDL
     * - documentation: Price quote date, account code, input designator, component count and bank exchange rate.
     * - minOccurs: 0
     * @var mixed
     */
    public $FareComponent;
    /**
     * The CarrierFeeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CarrierFeeInfo
     */
    public $CarrierFeeInfo;
    /**
     * The ExchResidualFareComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ExchResidualFareComponent[]
     */
    public $ExchResidualFareComponent;
    /**
     * The OriginalIssueInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginalIssueInfo
     */
    public $OriginalIssueInfo;
    /**
     * The ReissuedFlown
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ReissuedFlown[]
     */
    public $ReissuedFlown;
    /**
     * The ResponseComment
     * Meta information extracted from the WSDL
     * - documentation: A response message from the controlling carrier.
     * - minOccurs: 0
     * @var mixed
     */
    public $ResponseComment;
    /**
     * The PresentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PresentInfo
     */
    public $PresentInfo;
    /**
     * The ReasonForIssuance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReasonForIssuance
     */
    public $ReasonForIssuance;
    /**
     * The ValidatingAirline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValidatingAirline
     */
    public $ValidatingAirline;
    /**
     * The TaxCouponInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxCouponInformation
     */
    public $TaxCouponInformation;
    /**
     * The SpecificData
     * Meta information extracted from the WSDL
     * - documentation: Passenger specific data.
     * - use: optional
     * @var string
     */
    public $SpecificData;
    /**
     * The TaxOnCommissionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a tax is to be calculated by the BSP Processing Centre.
     * - use: optional
     * @var bool
     */
    public $TaxOnCommissionInd;
    /**
     * The TicketingModeCode
     * Meta information extracted from the WSDL
     * - documentation: An indication of the method of ticket generation. Refer to OpenTravel Code List EMD Ticketing Mode Code-5387 (ETM).
     * - use: optional
     * @var string
     */
    public $TicketingModeCode;
    /**
     * The EMD_Type
     * @var string
     */
    public $EMD_Type;
    /**
     * The QuoteInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that it is a quote type EMD or if false is an issued EMD.
     * @var bool
     */
    public $QuoteInd;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a reference to a specific EMD.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for EMD_Type
     * @uses EMD_Type::setTotalFltSegQty()
     * @uses EMD_Type::setTravelerRefNumber()
     * @uses EMD_Type::setAgentID()
     * @uses EMD_Type::setPaymentDetail()
     * @uses EMD_Type::setOriginDestination()
     * @uses EMD_Type::setCustLoyalty()
     * @uses EMD_Type::setEndorsement()
     * @uses EMD_Type::setAddReferenceID()
     * @uses EMD_Type::setBaseFare()
     * @uses EMD_Type::setEquivFare()
     * @uses EMD_Type::setTotalFare()
     * @uses EMD_Type::setTaxes()
     * @uses EMD_Type::setUnstructuredFareCalc()
     * @uses EMD_Type::setFareInfo()
     * @uses EMD_Type::setTicketDocument()
     * @uses EMD_Type::setCommission()
     * @uses EMD_Type::setFareComponent()
     * @uses EMD_Type::setCarrierFeeInfo()
     * @uses EMD_Type::setExchResidualFareComponent()
     * @uses EMD_Type::setOriginalIssueInfo()
     * @uses EMD_Type::setReissuedFlown()
     * @uses EMD_Type::setResponseComment()
     * @uses EMD_Type::setPresentInfo()
     * @uses EMD_Type::setReasonForIssuance()
     * @uses EMD_Type::setValidatingAirline()
     * @uses EMD_Type::setTaxCouponInformation()
     * @uses EMD_Type::setSpecificData()
     * @uses EMD_Type::setTaxOnCommissionInd()
     * @uses EMD_Type::setTicketingModeCode()
     * @uses EMD_Type::setEMD_Type()
     * @uses EMD_Type::setQuoteInd()
     * @uses EMD_Type::setOperation()
     * @uses EMD_Type::setRPH()
     * @param int $totalFltSegQty
     * @param \StructType\TravelerRefNumber $travelerRefNumber
     * @param mixed[] $agentID
     * @param mixed[] $paymentDetail
     * @param \StructType\OriginDestination $originDestination
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param \StructType\Endorsement $endorsement
     * @param mixed[] $addReferenceID
     * @param \StructType\BaseFare[] $baseFare
     * @param \StructType\EquivFare[] $equivFare
     * @param \StructType\TotalFare[] $totalFare
     * @param \StructType\Taxes $taxes
     * @param \StructType\UnstructuredFareCalc[] $unstructuredFareCalc
     * @param \StructType\FareInfo $fareInfo
     * @param \StructType\TicketDocument[] $ticketDocument
     * @param \StructType\Commission $commission
     * @param mixed $fareComponent
     * @param \StructType\CarrierFeeInfo $carrierFeeInfo
     * @param \StructType\ExchResidualFareComponent[] $exchResidualFareComponent
     * @param \StructType\OriginalIssueInfo $originalIssueInfo
     * @param \StructType\ReissuedFlown[] $reissuedFlown
     * @param mixed $responseComment
     * @param \StructType\PresentInfo $presentInfo
     * @param \StructType\ReasonForIssuance $reasonForIssuance
     * @param \StructType\ValidatingAirline $validatingAirline
     * @param \StructType\TaxCouponInformation $taxCouponInformation
     * @param string $specificData
     * @param bool $taxOnCommissionInd
     * @param string $ticketingModeCode
     * @param string $eMD_Type
     * @param bool $quoteInd
     * @param string $operation
     * @param string $rPH
     */
    public function __construct($totalFltSegQty = null, \StructType\TravelerRefNumber $travelerRefNumber = null, array $agentID = array(), array $paymentDetail = array(), \StructType\OriginDestination $originDestination = null, array $custLoyalty = array(), \StructType\Endorsement $endorsement = null, array $addReferenceID = array(), array $baseFare = array(), array $equivFare = array(), array $totalFare = array(), \StructType\Taxes $taxes = null, array $unstructuredFareCalc = array(), \StructType\FareInfo $fareInfo = null, array $ticketDocument = array(), \StructType\Commission $commission = null, $fareComponent = null, \StructType\CarrierFeeInfo $carrierFeeInfo = null, array $exchResidualFareComponent = array(), \StructType\OriginalIssueInfo $originalIssueInfo = null, array $reissuedFlown = array(), $responseComment = null, \StructType\PresentInfo $presentInfo = null, \StructType\ReasonForIssuance $reasonForIssuance = null, \StructType\ValidatingAirline $validatingAirline = null, \StructType\TaxCouponInformation $taxCouponInformation = null, $specificData = null, $taxOnCommissionInd = null, $ticketingModeCode = null, $eMD_Type = null, $quoteInd = null, $operation = null, $rPH = null)
    {
        $this
            ->setTotalFltSegQty($totalFltSegQty)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setAgentID($agentID)
            ->setPaymentDetail($paymentDetail)
            ->setOriginDestination($originDestination)
            ->setCustLoyalty($custLoyalty)
            ->setEndorsement($endorsement)
            ->setAddReferenceID($addReferenceID)
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setTotalFare($totalFare)
            ->setTaxes($taxes)
            ->setUnstructuredFareCalc($unstructuredFareCalc)
            ->setFareInfo($fareInfo)
            ->setTicketDocument($ticketDocument)
            ->setCommission($commission)
            ->setFareComponent($fareComponent)
            ->setCarrierFeeInfo($carrierFeeInfo)
            ->setExchResidualFareComponent($exchResidualFareComponent)
            ->setOriginalIssueInfo($originalIssueInfo)
            ->setReissuedFlown($reissuedFlown)
            ->setResponseComment($responseComment)
            ->setPresentInfo($presentInfo)
            ->setReasonForIssuance($reasonForIssuance)
            ->setValidatingAirline($validatingAirline)
            ->setTaxCouponInformation($taxCouponInformation)
            ->setSpecificData($specificData)
            ->setTaxOnCommissionInd($taxOnCommissionInd)
            ->setTicketingModeCode($ticketingModeCode)
            ->setEMD_Type($eMD_Type)
            ->setQuoteInd($quoteInd)
            ->setOperation($operation)
            ->setRPH($rPH);
    }
    /**
     * Get TotalFltSegQty value
     * @return int
     */
    public function getTotalFltSegQty()
    {
        return $this->TotalFltSegQty;
    }
    /**
     * Set TotalFltSegQty value
     * @param int $totalFltSegQty
     * @return \StructType\EMD_Type
     */
    public function setTotalFltSegQty($totalFltSegQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalFltSegQty) && !(is_int($totalFltSegQty) || ctype_digit($totalFltSegQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalFltSegQty, true), gettype($totalFltSegQty)), __LINE__);
        }
        $this->TotalFltSegQty = $totalFltSegQty;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param \StructType\TravelerRefNumber $travelerRefNumber
     * @return \StructType\EMD_Type
     */
    public function setTravelerRefNumber(\StructType\TravelerRefNumber $travelerRefNumber = null)
    {
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get AgentID value
     * @return mixed[]|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * This method is responsible for validating the values passed to the setAgentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgentID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentIDForArrayConstraintsFromSetAgentID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeAgentIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($eMD_TypeAgentIDItem) ? get_class($eMD_TypeAgentIDItem) : sprintf('%s(%s)', gettype($eMD_TypeAgentIDItem), var_export($eMD_TypeAgentIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AgentID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AgentID value
     * @throws \InvalidArgumentException
     * @param mixed[] $agentID
     * @return \StructType\EMD_Type
     */
    public function setAgentID(array $agentID = array())
    {
        // validation for constraint: array
        if ('' !== ($agentIDArrayErrorMessage = self::validateAgentIDForArrayConstraintsFromSetAgentID($agentID))) {
            throw new \InvalidArgumentException($agentIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($agentID) && count($agentID) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Add item to AgentID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\EMD_Type
     */
    public function addToAgentID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AgentID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->AgentID) && count($this->AgentID) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->AgentID)), __LINE__);
        }
        $this->AgentID[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetail value
     * @return mixed[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDetailForArrayConstraintsFromSetPaymentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypePaymentDetailItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($eMD_TypePaymentDetailItem) ? get_class($eMD_TypePaymentDetailItem) : sprintf('%s(%s)', gettype($eMD_TypePaymentDetailItem), var_export($eMD_TypePaymentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentDetail property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentDetail
     * @return \StructType\EMD_Type
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDetailArrayErrorMessage = self::validatePaymentDetailForArrayConstraintsFromSetPaymentDetail($paymentDetail))) {
            throw new \InvalidArgumentException($paymentDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($paymentDetail) && count($paymentDetail) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($paymentDetail)), __LINE__);
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\EMD_Type
     */
    public function addToPaymentDetail($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PaymentDetail) && count($this->PaymentDetail) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PaymentDetail)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Get OriginDestination value
     * @return \StructType\OriginDestination|null
     */
    public function getOriginDestination()
    {
        return $this->OriginDestination;
    }
    /**
     * Set OriginDestination value
     * @param \StructType\OriginDestination $originDestination
     * @return \StructType\EMD_Type
     */
    public function setOriginDestination(\StructType\OriginDestination $originDestination = null)
    {
        $this->OriginDestination = $originDestination;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($eMD_TypeCustLoyaltyItem) ? get_class($eMD_TypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($eMD_TypeCustLoyaltyItem), var_export($eMD_TypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\EMD_Type
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($custLoyalty) && count($custLoyalty) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($custLoyalty)), __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\EMD_Type
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CustLoyalty) && count($this->CustLoyalty) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CustLoyalty)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Endorsement value
     * @return \StructType\Endorsement|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @param \StructType\Endorsement $endorsement
     * @return \StructType\EMD_Type
     */
    public function setEndorsement(\StructType\Endorsement $endorsement = null)
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Get AddReferenceID value
     * @return mixed[]|null
     */
    public function getAddReferenceID()
    {
        return $this->AddReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setAddReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddReferenceIDForArrayConstraintsFromSetAddReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeAddReferenceIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($eMD_TypeAddReferenceIDItem) ? get_class($eMD_TypeAddReferenceIDItem) : sprintf('%s(%s)', gettype($eMD_TypeAddReferenceIDItem), var_export($eMD_TypeAddReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddReferenceID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed[] $addReferenceID
     * @return \StructType\EMD_Type
     */
    public function setAddReferenceID(array $addReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($addReferenceIDArrayErrorMessage = self::validateAddReferenceIDForArrayConstraintsFromSetAddReferenceID($addReferenceID))) {
            throw new \InvalidArgumentException($addReferenceIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($addReferenceID) && count($addReferenceID) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($addReferenceID)), __LINE__);
        }
        $this->AddReferenceID = $addReferenceID;
        return $this;
    }
    /**
     * Add item to AddReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\EMD_Type
     */
    public function addToAddReferenceID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AddReferenceID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->AddReferenceID) && count($this->AddReferenceID) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->AddReferenceID)), __LINE__);
        }
        $this->AddReferenceID[] = $item;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \StructType\BaseFare[]|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseFareForArrayConstraintsFromSetBaseFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeBaseFareItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeBaseFareItem instanceof \StructType\BaseFare) {
                $invalidValues[] = is_object($eMD_TypeBaseFareItem) ? get_class($eMD_TypeBaseFareItem) : sprintf('%s(%s)', gettype($eMD_TypeBaseFareItem), var_export($eMD_TypeBaseFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaseFare property can only contain items of type \StructType\BaseFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaseFare value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseFare[] $baseFare
     * @return \StructType\EMD_Type
     */
    public function setBaseFare(array $baseFare = array())
    {
        // validation for constraint: array
        if ('' !== ($baseFareArrayErrorMessage = self::validateBaseFareForArrayConstraintsFromSetBaseFare($baseFare))) {
            throw new \InvalidArgumentException($baseFareArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($baseFare) && count($baseFare) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($baseFare)), __LINE__);
        }
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Add item to BaseFare value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseFare $item
     * @return \StructType\EMD_Type
     */
    public function addToBaseFare(\StructType\BaseFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaseFare) {
            throw new \InvalidArgumentException(sprintf('The BaseFare property can only contain items of type \StructType\BaseFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BaseFare) && count($this->BaseFare) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BaseFare)), __LINE__);
        }
        $this->BaseFare[] = $item;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \StructType\EquivFare[]|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * This method is responsible for validating the values passed to the setEquivFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquivFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquivFareForArrayConstraintsFromSetEquivFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeEquivFareItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeEquivFareItem instanceof \StructType\EquivFare) {
                $invalidValues[] = is_object($eMD_TypeEquivFareItem) ? get_class($eMD_TypeEquivFareItem) : sprintf('%s(%s)', gettype($eMD_TypeEquivFareItem), var_export($eMD_TypeEquivFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquivFare property can only contain items of type \StructType\EquivFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquivFare value
     * @throws \InvalidArgumentException
     * @param \StructType\EquivFare[] $equivFare
     * @return \StructType\EMD_Type
     */
    public function setEquivFare(array $equivFare = array())
    {
        // validation for constraint: array
        if ('' !== ($equivFareArrayErrorMessage = self::validateEquivFareForArrayConstraintsFromSetEquivFare($equivFare))) {
            throw new \InvalidArgumentException($equivFareArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($equivFare) && count($equivFare) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($equivFare)), __LINE__);
        }
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Add item to EquivFare value
     * @throws \InvalidArgumentException
     * @param \StructType\EquivFare $item
     * @return \StructType\EMD_Type
     */
    public function addToEquivFare(\StructType\EquivFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EquivFare) {
            throw new \InvalidArgumentException(sprintf('The EquivFare property can only contain items of type \StructType\EquivFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->EquivFare) && count($this->EquivFare) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->EquivFare)), __LINE__);
        }
        $this->EquivFare[] = $item;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare[]|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalFareForArrayConstraintsFromSetTotalFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeTotalFareItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeTotalFareItem instanceof \StructType\TotalFare) {
                $invalidValues[] = is_object($eMD_TypeTotalFareItem) ? get_class($eMD_TypeTotalFareItem) : sprintf('%s(%s)', gettype($eMD_TypeTotalFareItem), var_export($eMD_TypeTotalFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalFare property can only contain items of type \StructType\TotalFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalFare value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalFare[] $totalFare
     * @return \StructType\EMD_Type
     */
    public function setTotalFare(array $totalFare = array())
    {
        // validation for constraint: array
        if ('' !== ($totalFareArrayErrorMessage = self::validateTotalFareForArrayConstraintsFromSetTotalFare($totalFare))) {
            throw new \InvalidArgumentException($totalFareArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($totalFare) && count($totalFare) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($totalFare)), __LINE__);
        }
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Add item to TotalFare value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalFare $item
     * @return \StructType\EMD_Type
     */
    public function addToTotalFare(\StructType\TotalFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalFare) {
            throw new \InvalidArgumentException(sprintf('The TotalFare property can only contain items of type \StructType\TotalFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TotalFare) && count($this->TotalFare) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TotalFare)), __LINE__);
        }
        $this->TotalFare[] = $item;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\EMD_Type
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get UnstructuredFareCalc value
     * @return \StructType\UnstructuredFareCalc[]|null
     */
    public function getUnstructuredFareCalc()
    {
        return $this->UnstructuredFareCalc;
    }
    /**
     * This method is responsible for validating the values passed to the setUnstructuredFareCalc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnstructuredFareCalc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnstructuredFareCalcForArrayConstraintsFromSetUnstructuredFareCalc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeUnstructuredFareCalcItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeUnstructuredFareCalcItem instanceof \StructType\UnstructuredFareCalc) {
                $invalidValues[] = is_object($eMD_TypeUnstructuredFareCalcItem) ? get_class($eMD_TypeUnstructuredFareCalcItem) : sprintf('%s(%s)', gettype($eMD_TypeUnstructuredFareCalcItem), var_export($eMD_TypeUnstructuredFareCalcItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnstructuredFareCalc property can only contain items of type \StructType\UnstructuredFareCalc, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnstructuredFareCalc value
     * @throws \InvalidArgumentException
     * @param \StructType\UnstructuredFareCalc[] $unstructuredFareCalc
     * @return \StructType\EMD_Type
     */
    public function setUnstructuredFareCalc(array $unstructuredFareCalc = array())
    {
        // validation for constraint: array
        if ('' !== ($unstructuredFareCalcArrayErrorMessage = self::validateUnstructuredFareCalcForArrayConstraintsFromSetUnstructuredFareCalc($unstructuredFareCalc))) {
            throw new \InvalidArgumentException($unstructuredFareCalcArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($unstructuredFareCalc) && count($unstructuredFareCalc) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($unstructuredFareCalc)), __LINE__);
        }
        $this->UnstructuredFareCalc = $unstructuredFareCalc;
        return $this;
    }
    /**
     * Add item to UnstructuredFareCalc value
     * @throws \InvalidArgumentException
     * @param \StructType\UnstructuredFareCalc $item
     * @return \StructType\EMD_Type
     */
    public function addToUnstructuredFareCalc(\StructType\UnstructuredFareCalc $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnstructuredFareCalc) {
            throw new \InvalidArgumentException(sprintf('The UnstructuredFareCalc property can only contain items of type \StructType\UnstructuredFareCalc, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->UnstructuredFareCalc) && count($this->UnstructuredFareCalc) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->UnstructuredFareCalc)), __LINE__);
        }
        $this->UnstructuredFareCalc[] = $item;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @param \StructType\FareInfo $fareInfo
     * @return \StructType\EMD_Type
     */
    public function setFareInfo(\StructType\FareInfo $fareInfo = null)
    {
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Get TicketDocument value
     * @return \StructType\TicketDocument[]|null
     */
    public function getTicketDocument()
    {
        return $this->TicketDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDocumentForArrayConstraintsFromSetTicketDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeTicketDocumentItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeTicketDocumentItem instanceof \StructType\TicketDocument) {
                $invalidValues[] = is_object($eMD_TypeTicketDocumentItem) ? get_class($eMD_TypeTicketDocumentItem) : sprintf('%s(%s)', gettype($eMD_TypeTicketDocumentItem), var_export($eMD_TypeTicketDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDocument property can only contain items of type \StructType\TicketDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocument[] $ticketDocument
     * @return \StructType\EMD_Type
     */
    public function setTicketDocument(array $ticketDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDocumentArrayErrorMessage = self::validateTicketDocumentForArrayConstraintsFromSetTicketDocument($ticketDocument))) {
            throw new \InvalidArgumentException($ticketDocumentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ticketDocument) && count($ticketDocument) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ticketDocument)), __LINE__);
        }
        $this->TicketDocument = $ticketDocument;
        return $this;
    }
    /**
     * Add item to TicketDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocument $item
     * @return \StructType\EMD_Type
     */
    public function addToTicketDocument(\StructType\TicketDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDocument) {
            throw new \InvalidArgumentException(sprintf('The TicketDocument property can only contain items of type \StructType\TicketDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TicketDocument) && count($this->TicketDocument) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TicketDocument)), __LINE__);
        }
        $this->TicketDocument[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\Commission $commission
     * @return \StructType\EMD_Type
     */
    public function setCommission(\StructType\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return mixed|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @param mixed $fareComponent
     * @return \StructType\EMD_Type
     */
    public function setFareComponent($fareComponent = null)
    {
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Get CarrierFeeInfo value
     * @return \StructType\CarrierFeeInfo|null
     */
    public function getCarrierFeeInfo()
    {
        return $this->CarrierFeeInfo;
    }
    /**
     * Set CarrierFeeInfo value
     * @param \StructType\CarrierFeeInfo $carrierFeeInfo
     * @return \StructType\EMD_Type
     */
    public function setCarrierFeeInfo(\StructType\CarrierFeeInfo $carrierFeeInfo = null)
    {
        $this->CarrierFeeInfo = $carrierFeeInfo;
        return $this;
    }
    /**
     * Get ExchResidualFareComponent value
     * @return \StructType\ExchResidualFareComponent[]|null
     */
    public function getExchResidualFareComponent()
    {
        return $this->ExchResidualFareComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setExchResidualFareComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExchResidualFareComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExchResidualFareComponentForArrayConstraintsFromSetExchResidualFareComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeExchResidualFareComponentItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeExchResidualFareComponentItem instanceof \StructType\ExchResidualFareComponent) {
                $invalidValues[] = is_object($eMD_TypeExchResidualFareComponentItem) ? get_class($eMD_TypeExchResidualFareComponentItem) : sprintf('%s(%s)', gettype($eMD_TypeExchResidualFareComponentItem), var_export($eMD_TypeExchResidualFareComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExchResidualFareComponent property can only contain items of type \StructType\ExchResidualFareComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExchResidualFareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\ExchResidualFareComponent[] $exchResidualFareComponent
     * @return \StructType\EMD_Type
     */
    public function setExchResidualFareComponent(array $exchResidualFareComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($exchResidualFareComponentArrayErrorMessage = self::validateExchResidualFareComponentForArrayConstraintsFromSetExchResidualFareComponent($exchResidualFareComponent))) {
            throw new \InvalidArgumentException($exchResidualFareComponentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($exchResidualFareComponent) && count($exchResidualFareComponent) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($exchResidualFareComponent)), __LINE__);
        }
        $this->ExchResidualFareComponent = $exchResidualFareComponent;
        return $this;
    }
    /**
     * Add item to ExchResidualFareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\ExchResidualFareComponent $item
     * @return \StructType\EMD_Type
     */
    public function addToExchResidualFareComponent(\StructType\ExchResidualFareComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExchResidualFareComponent) {
            throw new \InvalidArgumentException(sprintf('The ExchResidualFareComponent property can only contain items of type \StructType\ExchResidualFareComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ExchResidualFareComponent) && count($this->ExchResidualFareComponent) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ExchResidualFareComponent)), __LINE__);
        }
        $this->ExchResidualFareComponent[] = $item;
        return $this;
    }
    /**
     * Get OriginalIssueInfo value
     * @return \StructType\OriginalIssueInfo|null
     */
    public function getOriginalIssueInfo()
    {
        return $this->OriginalIssueInfo;
    }
    /**
     * Set OriginalIssueInfo value
     * @param \StructType\OriginalIssueInfo $originalIssueInfo
     * @return \StructType\EMD_Type
     */
    public function setOriginalIssueInfo(\StructType\OriginalIssueInfo $originalIssueInfo = null)
    {
        $this->OriginalIssueInfo = $originalIssueInfo;
        return $this;
    }
    /**
     * Get ReissuedFlown value
     * @return \StructType\ReissuedFlown[]|null
     */
    public function getReissuedFlown()
    {
        return $this->ReissuedFlown;
    }
    /**
     * This method is responsible for validating the values passed to the setReissuedFlown method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReissuedFlown method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReissuedFlownForArrayConstraintsFromSetReissuedFlown(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_TypeReissuedFlownItem) {
            // validation for constraint: itemType
            if (!$eMD_TypeReissuedFlownItem instanceof \StructType\ReissuedFlown) {
                $invalidValues[] = is_object($eMD_TypeReissuedFlownItem) ? get_class($eMD_TypeReissuedFlownItem) : sprintf('%s(%s)', gettype($eMD_TypeReissuedFlownItem), var_export($eMD_TypeReissuedFlownItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReissuedFlown property can only contain items of type \StructType\ReissuedFlown, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReissuedFlown value
     * @throws \InvalidArgumentException
     * @param \StructType\ReissuedFlown[] $reissuedFlown
     * @return \StructType\EMD_Type
     */
    public function setReissuedFlown(array $reissuedFlown = array())
    {
        // validation for constraint: array
        if ('' !== ($reissuedFlownArrayErrorMessage = self::validateReissuedFlownForArrayConstraintsFromSetReissuedFlown($reissuedFlown))) {
            throw new \InvalidArgumentException($reissuedFlownArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($reissuedFlown) && count($reissuedFlown) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($reissuedFlown)), __LINE__);
        }
        $this->ReissuedFlown = $reissuedFlown;
        return $this;
    }
    /**
     * Add item to ReissuedFlown value
     * @throws \InvalidArgumentException
     * @param \StructType\ReissuedFlown $item
     * @return \StructType\EMD_Type
     */
    public function addToReissuedFlown(\StructType\ReissuedFlown $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReissuedFlown) {
            throw new \InvalidArgumentException(sprintf('The ReissuedFlown property can only contain items of type \StructType\ReissuedFlown, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ReissuedFlown) && count($this->ReissuedFlown) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ReissuedFlown)), __LINE__);
        }
        $this->ReissuedFlown[] = $item;
        return $this;
    }
    /**
     * Get ResponseComment value
     * @return mixed|null
     */
    public function getResponseComment()
    {
        return $this->ResponseComment;
    }
    /**
     * Set ResponseComment value
     * @param mixed $responseComment
     * @return \StructType\EMD_Type
     */
    public function setResponseComment($responseComment = null)
    {
        $this->ResponseComment = $responseComment;
        return $this;
    }
    /**
     * Get PresentInfo value
     * @return \StructType\PresentInfo|null
     */
    public function getPresentInfo()
    {
        return $this->PresentInfo;
    }
    /**
     * Set PresentInfo value
     * @param \StructType\PresentInfo $presentInfo
     * @return \StructType\EMD_Type
     */
    public function setPresentInfo(\StructType\PresentInfo $presentInfo = null)
    {
        $this->PresentInfo = $presentInfo;
        return $this;
    }
    /**
     * Get ReasonForIssuance value
     * @return \StructType\ReasonForIssuance|null
     */
    public function getReasonForIssuance()
    {
        return $this->ReasonForIssuance;
    }
    /**
     * Set ReasonForIssuance value
     * @param \StructType\ReasonForIssuance $reasonForIssuance
     * @return \StructType\EMD_Type
     */
    public function setReasonForIssuance(\StructType\ReasonForIssuance $reasonForIssuance = null)
    {
        $this->ReasonForIssuance = $reasonForIssuance;
        return $this;
    }
    /**
     * Get ValidatingAirline value
     * @return \StructType\ValidatingAirline|null
     */
    public function getValidatingAirline()
    {
        return $this->ValidatingAirline;
    }
    /**
     * Set ValidatingAirline value
     * @param \StructType\ValidatingAirline $validatingAirline
     * @return \StructType\EMD_Type
     */
    public function setValidatingAirline(\StructType\ValidatingAirline $validatingAirline = null)
    {
        $this->ValidatingAirline = $validatingAirline;
        return $this;
    }
    /**
     * Get TaxCouponInformation value
     * @return \StructType\TaxCouponInformation|null
     */
    public function getTaxCouponInformation()
    {
        return $this->TaxCouponInformation;
    }
    /**
     * Set TaxCouponInformation value
     * @param \StructType\TaxCouponInformation $taxCouponInformation
     * @return \StructType\EMD_Type
     */
    public function setTaxCouponInformation(\StructType\TaxCouponInformation $taxCouponInformation = null)
    {
        $this->TaxCouponInformation = $taxCouponInformation;
        return $this;
    }
    /**
     * Get SpecificData value
     * @return string|null
     */
    public function getSpecificData()
    {
        return $this->SpecificData;
    }
    /**
     * Set SpecificData value
     * @param string $specificData
     * @return \StructType\EMD_Type
     */
    public function setSpecificData($specificData = null)
    {
        // validation for constraint: string
        if (!is_null($specificData) && !is_string($specificData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificData, true), gettype($specificData)), __LINE__);
        }
        $this->SpecificData = $specificData;
        return $this;
    }
    /**
     * Get TaxOnCommissionInd value
     * @return bool|null
     */
    public function getTaxOnCommissionInd()
    {
        return $this->TaxOnCommissionInd;
    }
    /**
     * Set TaxOnCommissionInd value
     * @param bool $taxOnCommissionInd
     * @return \StructType\EMD_Type
     */
    public function setTaxOnCommissionInd($taxOnCommissionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxOnCommissionInd) && !is_bool($taxOnCommissionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxOnCommissionInd, true), gettype($taxOnCommissionInd)), __LINE__);
        }
        $this->TaxOnCommissionInd = $taxOnCommissionInd;
        return $this;
    }
    /**
     * Get TicketingModeCode value
     * @return string|null
     */
    public function getTicketingModeCode()
    {
        return $this->TicketingModeCode;
    }
    /**
     * Set TicketingModeCode value
     * @param string $ticketingModeCode
     * @return \StructType\EMD_Type
     */
    public function setTicketingModeCode($ticketingModeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingModeCode) && !is_string($ticketingModeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingModeCode, true), gettype($ticketingModeCode)), __LINE__);
        }
        $this->TicketingModeCode = $ticketingModeCode;
        return $this;
    }
    /**
     * Get EMD_Type value
     * @return string|null
     */
    public function getEMD_Type()
    {
        return $this->EMD_Type;
    }
    /**
     * Set EMD_Type value
     * @param string $eMD_Type
     * @return \StructType\EMD_Type
     */
    public function setEMD_Type($eMD_Type = null)
    {
        // validation for constraint: string
        if (!is_null($eMD_Type) && !is_string($eMD_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMD_Type, true), gettype($eMD_Type)), __LINE__);
        }
        $this->EMD_Type = $eMD_Type;
        return $this;
    }
    /**
     * Get QuoteInd value
     * @return bool|null
     */
    public function getQuoteInd()
    {
        return $this->QuoteInd;
    }
    /**
     * Set QuoteInd value
     * @param bool $quoteInd
     * @return \StructType\EMD_Type
     */
    public function setQuoteInd($quoteInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($quoteInd) && !is_bool($quoteInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quoteInd, true), gettype($quoteInd)), __LINE__);
        }
        $this->QuoteInd = $quoteInd;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\EMD_Type
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\EMD_Type
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EMD_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
