<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMD_LiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for summarized electronic miscellaneous document information
 * @subpackage Structs
 */
class EMD_LiteType extends AbstractStructBase
{
    /**
     * The TotalFltSegQty
     * Meta information extracted from the WSDL
     * - documentation: Total number of flight segments.
     * - use: required
     * @var int
     */
    public $TotalFltSegQty;
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - documentation: The agent numeric code, booking agent id, issuing agent id and/or servicing airline/system provider ID.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AgentID;
    /**
     * The Endorsement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Endorsement
     */
    public $Endorsement;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TotalFare[]
     */
    public $TotalFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The FareInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareInfo
     */
    public $FareInfo;
    /**
     * The TicketDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TicketDocument[]
     */
    public $TicketDocument;
    /**
     * The OriginalIssueInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginalIssueInfo
     */
    public $OriginalIssueInfo;
    /**
     * The ReasonForIssuance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReasonForIssuance
     */
    public $ReasonForIssuance;
    /**
     * The TicketingModeCode
     * Meta information extracted from the WSDL
     * - documentation: An indication of the method of ticket generation. Refer to OpenTravel Code List EMD Ticketing Mode Code-5387 (ETM).
     * - use: optional
     * @var string
     */
    public $TicketingModeCode;
    /**
     * The EMD_Type
     * @var string
     */
    public $EMD_Type;
    /**
     * Constructor method for EMD_LiteType
     * @uses EMD_LiteType::setTotalFltSegQty()
     * @uses EMD_LiteType::setAgentID()
     * @uses EMD_LiteType::setEndorsement()
     * @uses EMD_LiteType::setTotalFare()
     * @uses EMD_LiteType::setTaxes()
     * @uses EMD_LiteType::setFareInfo()
     * @uses EMD_LiteType::setTicketDocument()
     * @uses EMD_LiteType::setOriginalIssueInfo()
     * @uses EMD_LiteType::setReasonForIssuance()
     * @uses EMD_LiteType::setTicketingModeCode()
     * @uses EMD_LiteType::setEMD_Type()
     * @param int $totalFltSegQty
     * @param mixed[] $agentID
     * @param \StructType\Endorsement $endorsement
     * @param \StructType\TotalFare[] $totalFare
     * @param \StructType\Taxes $taxes
     * @param \StructType\FareInfo $fareInfo
     * @param \StructType\TicketDocument[] $ticketDocument
     * @param \StructType\OriginalIssueInfo $originalIssueInfo
     * @param \StructType\ReasonForIssuance $reasonForIssuance
     * @param string $ticketingModeCode
     * @param string $eMD_Type
     */
    public function __construct($totalFltSegQty = null, array $agentID = array(), \StructType\Endorsement $endorsement = null, array $totalFare = array(), \StructType\Taxes $taxes = null, \StructType\FareInfo $fareInfo = null, array $ticketDocument = array(), \StructType\OriginalIssueInfo $originalIssueInfo = null, \StructType\ReasonForIssuance $reasonForIssuance = null, $ticketingModeCode = null, $eMD_Type = null)
    {
        $this
            ->setTotalFltSegQty($totalFltSegQty)
            ->setAgentID($agentID)
            ->setEndorsement($endorsement)
            ->setTotalFare($totalFare)
            ->setTaxes($taxes)
            ->setFareInfo($fareInfo)
            ->setTicketDocument($ticketDocument)
            ->setOriginalIssueInfo($originalIssueInfo)
            ->setReasonForIssuance($reasonForIssuance)
            ->setTicketingModeCode($ticketingModeCode)
            ->setEMD_Type($eMD_Type);
    }
    /**
     * Get TotalFltSegQty value
     * @return int
     */
    public function getTotalFltSegQty()
    {
        return $this->TotalFltSegQty;
    }
    /**
     * Set TotalFltSegQty value
     * @param int $totalFltSegQty
     * @return \StructType\EMD_LiteType
     */
    public function setTotalFltSegQty($totalFltSegQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalFltSegQty) && !(is_int($totalFltSegQty) || ctype_digit($totalFltSegQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalFltSegQty, true), gettype($totalFltSegQty)), __LINE__);
        }
        $this->TotalFltSegQty = $totalFltSegQty;
        return $this;
    }
    /**
     * Get AgentID value
     * @return mixed[]|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * This method is responsible for validating the values passed to the setAgentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgentID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentIDForArrayConstraintsFromSetAgentID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_LiteTypeAgentIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($eMD_LiteTypeAgentIDItem) ? get_class($eMD_LiteTypeAgentIDItem) : sprintf('%s(%s)', gettype($eMD_LiteTypeAgentIDItem), var_export($eMD_LiteTypeAgentIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AgentID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AgentID value
     * @throws \InvalidArgumentException
     * @param mixed[] $agentID
     * @return \StructType\EMD_LiteType
     */
    public function setAgentID(array $agentID = array())
    {
        // validation for constraint: array
        if ('' !== ($agentIDArrayErrorMessage = self::validateAgentIDForArrayConstraintsFromSetAgentID($agentID))) {
            throw new \InvalidArgumentException($agentIDArrayErrorMessage, __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Add item to AgentID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\EMD_LiteType
     */
    public function addToAgentID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AgentID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AgentID[] = $item;
        return $this;
    }
    /**
     * Get Endorsement value
     * @return \StructType\Endorsement|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @param \StructType\Endorsement $endorsement
     * @return \StructType\EMD_LiteType
     */
    public function setEndorsement(\StructType\Endorsement $endorsement = null)
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare[]|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalFareForArrayConstraintsFromSetTotalFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_LiteTypeTotalFareItem) {
            // validation for constraint: itemType
            if (!$eMD_LiteTypeTotalFareItem instanceof \StructType\TotalFare) {
                $invalidValues[] = is_object($eMD_LiteTypeTotalFareItem) ? get_class($eMD_LiteTypeTotalFareItem) : sprintf('%s(%s)', gettype($eMD_LiteTypeTotalFareItem), var_export($eMD_LiteTypeTotalFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalFare property can only contain items of type \StructType\TotalFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalFare value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalFare[] $totalFare
     * @return \StructType\EMD_LiteType
     */
    public function setTotalFare(array $totalFare = array())
    {
        // validation for constraint: array
        if ('' !== ($totalFareArrayErrorMessage = self::validateTotalFareForArrayConstraintsFromSetTotalFare($totalFare))) {
            throw new \InvalidArgumentException($totalFareArrayErrorMessage, __LINE__);
        }
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Add item to TotalFare value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalFare $item
     * @return \StructType\EMD_LiteType
     */
    public function addToTotalFare(\StructType\TotalFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalFare) {
            throw new \InvalidArgumentException(sprintf('The TotalFare property can only contain items of type \StructType\TotalFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TotalFare[] = $item;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\EMD_LiteType
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @param \StructType\FareInfo $fareInfo
     * @return \StructType\EMD_LiteType
     */
    public function setFareInfo(\StructType\FareInfo $fareInfo = null)
    {
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Get TicketDocument value
     * @return \StructType\TicketDocument[]|null
     */
    public function getTicketDocument()
    {
        return $this->TicketDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDocumentForArrayConstraintsFromSetTicketDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_LiteTypeTicketDocumentItem) {
            // validation for constraint: itemType
            if (!$eMD_LiteTypeTicketDocumentItem instanceof \StructType\TicketDocument) {
                $invalidValues[] = is_object($eMD_LiteTypeTicketDocumentItem) ? get_class($eMD_LiteTypeTicketDocumentItem) : sprintf('%s(%s)', gettype($eMD_LiteTypeTicketDocumentItem), var_export($eMD_LiteTypeTicketDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDocument property can only contain items of type \StructType\TicketDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocument[] $ticketDocument
     * @return \StructType\EMD_LiteType
     */
    public function setTicketDocument(array $ticketDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDocumentArrayErrorMessage = self::validateTicketDocumentForArrayConstraintsFromSetTicketDocument($ticketDocument))) {
            throw new \InvalidArgumentException($ticketDocumentArrayErrorMessage, __LINE__);
        }
        $this->TicketDocument = $ticketDocument;
        return $this;
    }
    /**
     * Add item to TicketDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocument $item
     * @return \StructType\EMD_LiteType
     */
    public function addToTicketDocument(\StructType\TicketDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDocument) {
            throw new \InvalidArgumentException(sprintf('The TicketDocument property can only contain items of type \StructType\TicketDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDocument[] = $item;
        return $this;
    }
    /**
     * Get OriginalIssueInfo value
     * @return \StructType\OriginalIssueInfo|null
     */
    public function getOriginalIssueInfo()
    {
        return $this->OriginalIssueInfo;
    }
    /**
     * Set OriginalIssueInfo value
     * @param \StructType\OriginalIssueInfo $originalIssueInfo
     * @return \StructType\EMD_LiteType
     */
    public function setOriginalIssueInfo(\StructType\OriginalIssueInfo $originalIssueInfo = null)
    {
        $this->OriginalIssueInfo = $originalIssueInfo;
        return $this;
    }
    /**
     * Get ReasonForIssuance value
     * @return \StructType\ReasonForIssuance|null
     */
    public function getReasonForIssuance()
    {
        return $this->ReasonForIssuance;
    }
    /**
     * Set ReasonForIssuance value
     * @param \StructType\ReasonForIssuance $reasonForIssuance
     * @return \StructType\EMD_LiteType
     */
    public function setReasonForIssuance(\StructType\ReasonForIssuance $reasonForIssuance = null)
    {
        $this->ReasonForIssuance = $reasonForIssuance;
        return $this;
    }
    /**
     * Get TicketingModeCode value
     * @return string|null
     */
    public function getTicketingModeCode()
    {
        return $this->TicketingModeCode;
    }
    /**
     * Set TicketingModeCode value
     * @param string $ticketingModeCode
     * @return \StructType\EMD_LiteType
     */
    public function setTicketingModeCode($ticketingModeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingModeCode) && !is_string($ticketingModeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingModeCode, true), gettype($ticketingModeCode)), __LINE__);
        }
        $this->TicketingModeCode = $ticketingModeCode;
        return $this;
    }
    /**
     * Get EMD_Type value
     * @return string|null
     */
    public function getEMD_Type()
    {
        return $this->EMD_Type;
    }
    /**
     * Set EMD_Type value
     * @param string $eMD_Type
     * @return \StructType\EMD_LiteType
     */
    public function setEMD_Type($eMD_Type = null)
    {
        // validation for constraint: string
        if (!is_null($eMD_Type) && !is_string($eMD_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMD_Type, true), gettype($eMD_Type)), __LINE__);
        }
        $this->EMD_Type = $eMD_Type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EMD_LiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
