<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DonorInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Donor information, including Email Address, First Name, Last Name, Street Address, City and Zip Code.
 * @subpackage Structs
 */
class DonorInfo extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Name
     */
    public $Name;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactInfo
     */
    public $ContactInfo;
    /**
     * Constructor method for DonorInfo
     * @uses DonorInfo::setName()
     * @uses DonorInfo::setContactInfo()
     * @param \StructType\Name $name
     * @param \StructType\ContactInfo $contactInfo
     */
    public function __construct(\StructType\Name $name = null, \StructType\ContactInfo $contactInfo = null)
    {
        $this
            ->setName($name)
            ->setContactInfo($contactInfo);
    }
    /**
     * Get Name value
     * @return \StructType\Name|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\Name $name
     * @return \StructType\DonorInfo
     */
    public function setName(\StructType\Name $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfo|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\ContactInfo $contactInfo
     * @return \StructType\DonorInfo
     */
    public function setContactInfo(\StructType\ContactInfo $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DonorInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
