<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DonationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information about donations made during a booking.
 * @subpackage Structs
 */
class DonationType extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: The localized error response language.
     * - use: required
     * @var string
     */
    public $Language;
    /**
     * The AskForReceiptInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the donor wants a donation receipt.
     * - use: required
     * @var bool
     */
    public $AskForReceiptInd;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: The 2 character ISO3166 country code of the donor.
     * - use: required
     * @var string
     */
    public $CountryCode;
    /**
     * The FrontOfficeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FrontOfficeInfo
     */
    public $FrontOfficeInfo;
    /**
     * The CreditCardInfo
     * @var \StructType\CreditCardInfo
     */
    public $CreditCardInfo;
    /**
     * The DonorInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DonorInfo
     */
    public $DonorInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The GDS_ID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $GDS_ID;
    /**
     * The StateCode
     * Meta information extracted from the WSDL
     * - documentation: The origin state of the donor.
     * - use: optional
     * @var mixed
     */
    public $StateCode;
    /**
     * Constructor method for DonationType
     * @uses DonationType::setLanguage()
     * @uses DonationType::setAskForReceiptInd()
     * @uses DonationType::setCountryCode()
     * @uses DonationType::setFrontOfficeInfo()
     * @uses DonationType::setCreditCardInfo()
     * @uses DonationType::setDonorInfo()
     * @uses DonationType::setTPA_Extensions()
     * @uses DonationType::setGDS_ID()
     * @uses DonationType::setStateCode()
     * @param string $language
     * @param bool $askForReceiptInd
     * @param string $countryCode
     * @param \StructType\FrontOfficeInfo $frontOfficeInfo
     * @param \StructType\CreditCardInfo $creditCardInfo
     * @param \StructType\DonorInfo $donorInfo
     * @param mixed $tPA_Extensions
     * @param string $gDS_ID
     * @param mixed $stateCode
     */
    public function __construct($language = null, $askForReceiptInd = null, $countryCode = null, \StructType\FrontOfficeInfo $frontOfficeInfo = null, \StructType\CreditCardInfo $creditCardInfo = null, \StructType\DonorInfo $donorInfo = null, $tPA_Extensions = null, $gDS_ID = null, $stateCode = null)
    {
        $this
            ->setLanguage($language)
            ->setAskForReceiptInd($askForReceiptInd)
            ->setCountryCode($countryCode)
            ->setFrontOfficeInfo($frontOfficeInfo)
            ->setCreditCardInfo($creditCardInfo)
            ->setDonorInfo($donorInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setGDS_ID($gDS_ID)
            ->setStateCode($stateCode);
    }
    /**
     * Get Language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\DonationType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get AskForReceiptInd value
     * @return bool
     */
    public function getAskForReceiptInd()
    {
        return $this->AskForReceiptInd;
    }
    /**
     * Set AskForReceiptInd value
     * @param bool $askForReceiptInd
     * @return \StructType\DonationType
     */
    public function setAskForReceiptInd($askForReceiptInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($askForReceiptInd) && !is_bool($askForReceiptInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($askForReceiptInd, true), gettype($askForReceiptInd)), __LINE__);
        }
        $this->AskForReceiptInd = $askForReceiptInd;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\DonationType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get FrontOfficeInfo value
     * @return \StructType\FrontOfficeInfo|null
     */
    public function getFrontOfficeInfo()
    {
        return $this->FrontOfficeInfo;
    }
    /**
     * Set FrontOfficeInfo value
     * @param \StructType\FrontOfficeInfo $frontOfficeInfo
     * @return \StructType\DonationType
     */
    public function setFrontOfficeInfo(\StructType\FrontOfficeInfo $frontOfficeInfo = null)
    {
        $this->FrontOfficeInfo = $frontOfficeInfo;
        return $this;
    }
    /**
     * Get CreditCardInfo value
     * @return \StructType\CreditCardInfo|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \StructType\CreditCardInfo $creditCardInfo
     * @return \StructType\DonationType
     */
    public function setCreditCardInfo(\StructType\CreditCardInfo $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get DonorInfo value
     * @return \StructType\DonorInfo|null
     */
    public function getDonorInfo()
    {
        return $this->DonorInfo;
    }
    /**
     * Set DonorInfo value
     * @param \StructType\DonorInfo $donorInfo
     * @return \StructType\DonationType
     */
    public function setDonorInfo(\StructType\DonorInfo $donorInfo = null)
    {
        $this->DonorInfo = $donorInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\DonationType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get GDS_ID value
     * @return string|null
     */
    public function getGDS_ID()
    {
        return $this->GDS_ID;
    }
    /**
     * Set GDS_ID value
     * @param string $gDS_ID
     * @return \StructType\DonationType
     */
    public function setGDS_ID($gDS_ID = null)
    {
        // validation for constraint: string
        if (!is_null($gDS_ID) && !is_string($gDS_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDS_ID, true), gettype($gDS_ID)), __LINE__);
        }
        $this->GDS_ID = $gDS_ID;
        return $this;
    }
    /**
     * Get StateCode value
     * @return mixed|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param mixed $stateCode
     * @return \StructType\DonationType
     */
    public function setStateCode($stateCode = null)
    {
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DonationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
