<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Details StructType
 * Meta information extracted from the WSDL
 * - documentation: Recycling details.
 * @subpackage Structs
 */
class Details extends AbstractStructBase
{
    /**
     * The RecycledProducts
     * Meta information extracted from the WSDL
     * - documentation: Example: Paper | Products recycled.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RecycledProducts;
    /**
     * The RecyclingLocations
     * Meta information extracted from the WSDL
     * - documentation: Example: GuestRooms | Recycling facility locations.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RecyclingLocations;
    /**
     * Constructor method for Details
     * @uses Details::setRecycledProducts()
     * @uses Details::setRecyclingLocations()
     * @param mixed[] $recycledProducts
     * @param mixed[] $recyclingLocations
     */
    public function __construct(array $recycledProducts = array(), array $recyclingLocations = array())
    {
        $this
            ->setRecycledProducts($recycledProducts)
            ->setRecyclingLocations($recyclingLocations);
    }
    /**
     * Get RecycledProducts value
     * @return mixed[]|null
     */
    public function getRecycledProducts()
    {
        return $this->RecycledProducts;
    }
    /**
     * This method is responsible for validating the values passed to the setRecycledProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecycledProducts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecycledProductsForArrayConstraintsFromSetRecycledProducts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsRecycledProductsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($detailsRecycledProductsItem) ? get_class($detailsRecycledProductsItem) : sprintf('%s(%s)', gettype($detailsRecycledProductsItem), var_export($detailsRecycledProductsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecycledProducts property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecycledProducts value
     * @throws \InvalidArgumentException
     * @param mixed[] $recycledProducts
     * @return \StructType\Details
     */
    public function setRecycledProducts(array $recycledProducts = array())
    {
        // validation for constraint: array
        if ('' !== ($recycledProductsArrayErrorMessage = self::validateRecycledProductsForArrayConstraintsFromSetRecycledProducts($recycledProducts))) {
            throw new \InvalidArgumentException($recycledProductsArrayErrorMessage, __LINE__);
        }
        $this->RecycledProducts = $recycledProducts;
        return $this;
    }
    /**
     * Add item to RecycledProducts value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Details
     */
    public function addToRecycledProducts($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RecycledProducts property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecycledProducts[] = $item;
        return $this;
    }
    /**
     * Get RecyclingLocations value
     * @return mixed[]|null
     */
    public function getRecyclingLocations()
    {
        return $this->RecyclingLocations;
    }
    /**
     * This method is responsible for validating the values passed to the setRecyclingLocations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecyclingLocations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecyclingLocationsForArrayConstraintsFromSetRecyclingLocations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsRecyclingLocationsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($detailsRecyclingLocationsItem) ? get_class($detailsRecyclingLocationsItem) : sprintf('%s(%s)', gettype($detailsRecyclingLocationsItem), var_export($detailsRecyclingLocationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecyclingLocations property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecyclingLocations value
     * @throws \InvalidArgumentException
     * @param mixed[] $recyclingLocations
     * @return \StructType\Details
     */
    public function setRecyclingLocations(array $recyclingLocations = array())
    {
        // validation for constraint: array
        if ('' !== ($recyclingLocationsArrayErrorMessage = self::validateRecyclingLocationsForArrayConstraintsFromSetRecyclingLocations($recyclingLocations))) {
            throw new \InvalidArgumentException($recyclingLocationsArrayErrorMessage, __LINE__);
        }
        $this->RecyclingLocations = $recyclingLocations;
        return $this;
    }
    /**
     * Add item to RecyclingLocations value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Details
     */
    public function addToRecyclingLocations($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RecyclingLocations property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecyclingLocations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Details
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
