<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Detailed traveler information.
 * @subpackage Structs
 */
class DetailInfo extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Identification
     */
    public $Identification;
    /**
     * The CustomerValue
     * Meta information extracted from the WSDL
     * - documentation: Offer requestor assessed customer value.
     * - minOccurs: 0
     * @var mixed
     */
    public $CustomerValue;
    /**
     * The ServiceAnimalInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler has a service animal. | Example: true | Service animal indicator.
     * - use: optional
     * @var bool
     */
    public $ServiceAnimalInd;
    /**
     * The DisabledInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler has a disability. | Example: true | Disabled traveler indicator.
     * - use: optional
     * @var bool
     */
    public $DisabledInd;
    /**
     * The FemaleInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler is female. | Example: true | Female traveler indicator.
     * - use: optional
     * @var bool
     */
    public $FemaleInd;
    /**
     * The MaleInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler is male. | Example: true | Male traveler indicator.
     * - use: optional
     * @var bool
     */
    public $MaleInd;
    /**
     * Constructor method for DetailInfo
     * @uses DetailInfo::setIdentification()
     * @uses DetailInfo::setCustomerValue()
     * @uses DetailInfo::setServiceAnimalInd()
     * @uses DetailInfo::setDisabledInd()
     * @uses DetailInfo::setFemaleInd()
     * @uses DetailInfo::setMaleInd()
     * @param \StructType\Identification $identification
     * @param mixed $customerValue
     * @param bool $serviceAnimalInd
     * @param bool $disabledInd
     * @param bool $femaleInd
     * @param bool $maleInd
     */
    public function __construct(\StructType\Identification $identification = null, $customerValue = null, $serviceAnimalInd = null, $disabledInd = null, $femaleInd = null, $maleInd = null)
    {
        $this
            ->setIdentification($identification)
            ->setCustomerValue($customerValue)
            ->setServiceAnimalInd($serviceAnimalInd)
            ->setDisabledInd($disabledInd)
            ->setFemaleInd($femaleInd)
            ->setMaleInd($maleInd);
    }
    /**
     * Get Identification value
     * @return \StructType\Identification|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\Identification $identification
     * @return \StructType\DetailInfo
     */
    public function setIdentification(\StructType\Identification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return mixed|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param mixed $customerValue
     * @return \StructType\DetailInfo
     */
    public function setCustomerValue($customerValue = null)
    {
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get ServiceAnimalInd value
     * @return bool|null
     */
    public function getServiceAnimalInd()
    {
        return $this->ServiceAnimalInd;
    }
    /**
     * Set ServiceAnimalInd value
     * @param bool $serviceAnimalInd
     * @return \StructType\DetailInfo
     */
    public function setServiceAnimalInd($serviceAnimalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceAnimalInd) && !is_bool($serviceAnimalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceAnimalInd, true), gettype($serviceAnimalInd)), __LINE__);
        }
        $this->ServiceAnimalInd = $serviceAnimalInd;
        return $this;
    }
    /**
     * Get DisabledInd value
     * @return bool|null
     */
    public function getDisabledInd()
    {
        return $this->DisabledInd;
    }
    /**
     * Set DisabledInd value
     * @param bool $disabledInd
     * @return \StructType\DetailInfo
     */
    public function setDisabledInd($disabledInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($disabledInd) && !is_bool($disabledInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disabledInd, true), gettype($disabledInd)), __LINE__);
        }
        $this->DisabledInd = $disabledInd;
        return $this;
    }
    /**
     * Get FemaleInd value
     * @return bool|null
     */
    public function getFemaleInd()
    {
        return $this->FemaleInd;
    }
    /**
     * Set FemaleInd value
     * @param bool $femaleInd
     * @return \StructType\DetailInfo
     */
    public function setFemaleInd($femaleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($femaleInd) && !is_bool($femaleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($femaleInd, true), gettype($femaleInd)), __LINE__);
        }
        $this->FemaleInd = $femaleInd;
        return $this;
    }
    /**
     * Get MaleInd value
     * @return bool|null
     */
    public function getMaleInd()
    {
        return $this->MaleInd;
    }
    /**
     * Set MaleInd value
     * @param bool $maleInd
     * @return \StructType\DetailInfo
     */
    public function setMaleInd($maleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maleInd) && !is_bool($maleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maleInd, true), gettype($maleInd)), __LINE__);
        }
        $this->MaleInd = $maleInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetailInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
