<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Description StructType
 * Meta information extracted from the WSDL
 * - documentation: Repeated descriptions may be used to accommodate information categories. | Rule description(s). | A description of the Blackout Date, which may be multilingual. | The description associated with the video in a specific language. |
 * The text in a specific language. | The description associated with the image in a specific language.
 * - type: StringLength1to128
 * - use: optional
 * @subpackage Structs
 */
class Description extends FormattedTextTextType
{
    /**
     * The Caption
     * Meta information extracted from the WSDL
     * - documentation: Example: The Empire State Building at sunset. | The caption associated with the image in a specific language. | The caption associated to a specific image category which can be provided in different languages.
     * - use: optional
     * @var string
     */
    public $Caption;
    /**
     * The ListItem
     * Meta information extracted from the WSDL
     * - documentation: Sequence number associated with this description.
     * - use: optional
     * @var int
     */
    public $ListItem;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: A short description of the rule text with a language identifier.
     * - minOccurs: 0
     * @var mixed
     */
    public $ShortDescription;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - documentation: A long description of the rule text with a language identifier.
     * - minOccurs: 0
     * @var mixed
     */
    public $LongDescription;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: The language associated with the description.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * Constructor method for Description
     * @uses Description::setCaption()
     * @uses Description::setListItem()
     * @uses Description::setShortDescription()
     * @uses Description::setLongDescription()
     * @uses Description::setLanguage()
     * @param string $caption
     * @param int $listItem
     * @param mixed $shortDescription
     * @param mixed $longDescription
     * @param string $language
     */
    public function __construct($caption = null, $listItem = null, $shortDescription = null, $longDescription = null, $language = null)
    {
        $this
            ->setCaption($caption)
            ->setListItem($listItem)
            ->setShortDescription($shortDescription)
            ->setLongDescription($longDescription)
            ->setLanguage($language);
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \StructType\Description
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ListItem value
     * @return int|null
     */
    public function getListItem()
    {
        return $this->ListItem;
    }
    /**
     * Set ListItem value
     * @param int $listItem
     * @return \StructType\Description
     */
    public function setListItem($listItem = null)
    {
        // validation for constraint: int
        if (!is_null($listItem) && !(is_int($listItem) || ctype_digit($listItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listItem, true), gettype($listItem)), __LINE__);
        }
        $this->ListItem = $listItem;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return mixed|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param mixed $shortDescription
     * @return \StructType\Description
     */
    public function setShortDescription($shortDescription = null)
    {
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return mixed|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param mixed $longDescription
     * @return \StructType\Description
     */
    public function setLongDescription($longDescription = null)
    {
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Description
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Description
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
