<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeSpanType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the date and/or time span. | Used to specify a time window range by either specifying an earliest and latest date for the start date and end date or by giving a date with a time period that can be applied before and/or after
 * the start date.
 * @subpackage Structs
 */
class DateTimeSpanType extends AbstractStructBase
{
    /**
     * The DateWindowRange
     * Meta information extracted from the WSDL
     * - documentation: Specifies a time period that can be applied before and/or after the start date.
     * - choice: DateWindowRange | StartDateWindow | EndDateWindow
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $DateWindowRange;
    /**
     * The StartDateWindow
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | StartDateWindow | EndDateWindow
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StartDateWindow
     */
    public $StartDateWindow;
    /**
     * The EndDateWindow
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | StartDateWindow | EndDateWindow
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EndDateWindow
     */
    public $EndDateWindow;
    /**
     * Constructor method for DateTimeSpanType
     * @uses DateTimeSpanType::setDateWindowRange()
     * @uses DateTimeSpanType::setStartDateWindow()
     * @uses DateTimeSpanType::setEndDateWindow()
     * @param mixed $dateWindowRange
     * @param \StructType\StartDateWindow $startDateWindow
     * @param \StructType\EndDateWindow $endDateWindow
     */
    public function __construct($dateWindowRange = null, \StructType\StartDateWindow $startDateWindow = null, \StructType\EndDateWindow $endDateWindow = null)
    {
        $this
            ->setDateWindowRange($dateWindowRange)
            ->setStartDateWindow($startDateWindow)
            ->setEndDateWindow($endDateWindow);
    }
    /**
     * Get DateWindowRange value
     * @return mixed|null
     */
    public function getDateWindowRange()
    {
        return isset($this->DateWindowRange) ? $this->DateWindowRange : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateWindowRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateWindowRange method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateWindowRangeForChoiceConstraintsFromSetDateWindowRange($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'StartDateWindow',
            'EndDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateWindowRange can\'t be set as the property %s is already set. Only one property must be set among these properties: DateWindowRange, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateWindowRange value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $dateWindowRange
     * @return \StructType\DateTimeSpanType
     */
    public function setDateWindowRange($dateWindowRange = null)
    {
        // validation for constraint: choice(DateWindowRange, StartDateWindow, EndDateWindow)
        if ('' !== ($dateWindowRangeChoiceErrorMessage = self::validateDateWindowRangeForChoiceConstraintsFromSetDateWindowRange($dateWindowRange))) {
            throw new \InvalidArgumentException($dateWindowRangeChoiceErrorMessage, __LINE__);
        }
        if (is_null($dateWindowRange) || (is_array($dateWindowRange) && empty($dateWindowRange))) {
            unset($this->DateWindowRange);
        } else {
            $this->DateWindowRange = $dateWindowRange;
        }
        return $this;
    }
    /**
     * Get StartDateWindow value
     * @return \StructType\StartDateWindow|null
     */
    public function getStartDateWindow()
    {
        return isset($this->StartDateWindow) ? $this->StartDateWindow : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStartDateWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDateWindow method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStartDateWindowForChoiceConstraintsFromSetStartDateWindow($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateWindowRange',
            'EndDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property StartDateWindow can\'t be set as the property %s is already set. Only one property must be set among these properties: StartDateWindow, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set StartDateWindow value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StartDateWindow $startDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setStartDateWindow(\StructType\StartDateWindow $startDateWindow = null)
    {
        // validation for constraint: choice(DateWindowRange, StartDateWindow, EndDateWindow)
        if ('' !== ($startDateWindowChoiceErrorMessage = self::validateStartDateWindowForChoiceConstraintsFromSetStartDateWindow($startDateWindow))) {
            throw new \InvalidArgumentException($startDateWindowChoiceErrorMessage, __LINE__);
        }
        if (is_null($startDateWindow) || (is_array($startDateWindow) && empty($startDateWindow))) {
            unset($this->StartDateWindow);
        } else {
            $this->StartDateWindow = $startDateWindow;
        }
        return $this;
    }
    /**
     * Get EndDateWindow value
     * @return \StructType\EndDateWindow|null
     */
    public function getEndDateWindow()
    {
        return isset($this->EndDateWindow) ? $this->EndDateWindow : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEndDateWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDateWindow method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEndDateWindowForChoiceConstraintsFromSetEndDateWindow($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateWindowRange',
            'StartDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property EndDateWindow can\'t be set as the property %s is already set. Only one property must be set among these properties: EndDateWindow, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set EndDateWindow value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EndDateWindow $endDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setEndDateWindow(\StructType\EndDateWindow $endDateWindow = null)
    {
        // validation for constraint: choice(DateWindowRange, StartDateWindow, EndDateWindow)
        if ('' !== ($endDateWindowChoiceErrorMessage = self::validateEndDateWindowForChoiceConstraintsFromSetEndDateWindow($endDateWindow))) {
            throw new \InvalidArgumentException($endDateWindowChoiceErrorMessage, __LINE__);
        }
        if (is_null($endDateWindow) || (is_array($endDateWindow) && empty($endDateWindow))) {
            unset($this->EndDateWindow);
        } else {
            $this->EndDateWindow = $endDateWindow;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateTimeSpanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
