<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCountsType StructType
 * Meta information extracted from the WSDL
 * - documentation: CustomerCounts- Categorization of all Customers in a reservation or request. The total number of Customers will equal the sum of the Count attribute of all CustomerCount objects in this collection and assumes that the
 * AgeQualifyingCode will be used to determine how each Customer should be billed. Each booking segment has its own CustomerCount attribute to help determine billing, headcount, etc. The CustomerCount collection cannot be modified using a delta. It must
 * be resent in its entirety if modified.
 * @subpackage Structs
 */
class CustomerCountsType extends AbstractStructBase
{
    /**
     * The CustomerCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CustomerCount[]
     */
    public $CustomerCount;
    /**
     * Constructor method for CustomerCountsType
     * @uses CustomerCountsType::setCustomerCount()
     * @param \StructType\CustomerCount[] $customerCount
     */
    public function __construct(array $customerCount = array())
    {
        $this
            ->setCustomerCount($customerCount);
    }
    /**
     * Get CustomerCount value
     * @return \StructType\CustomerCount[]|null
     */
    public function getCustomerCount()
    {
        return $this->CustomerCount;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerCountForArrayConstraintsFromSetCustomerCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerCountsTypeCustomerCountItem) {
            // validation for constraint: itemType
            if (!$customerCountsTypeCustomerCountItem instanceof \StructType\CustomerCount) {
                $invalidValues[] = is_object($customerCountsTypeCustomerCountItem) ? get_class($customerCountsTypeCustomerCountItem) : sprintf('%s(%s)', gettype($customerCountsTypeCustomerCountItem), var_export($customerCountsTypeCustomerCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerCount property can only contain items of type \StructType\CustomerCount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerCount value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCount[] $customerCount
     * @return \StructType\CustomerCountsType
     */
    public function setCustomerCount(array $customerCount = array())
    {
        // validation for constraint: array
        if ('' !== ($customerCountArrayErrorMessage = self::validateCustomerCountForArrayConstraintsFromSetCustomerCount($customerCount))) {
            throw new \InvalidArgumentException($customerCountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($customerCount) && count($customerCount) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($customerCount)), __LINE__);
        }
        $this->CustomerCount = $customerCount;
        return $this;
    }
    /**
     * Add item to CustomerCount value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCount $item
     * @return \StructType\CustomerCountsType
     */
    public function addToCustomerCount(\StructType\CustomerCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerCount) {
            throw new \InvalidArgumentException(sprintf('The CustomerCount property can only contain items of type \StructType\CustomerCount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CustomerCount) && count($this->CustomerCount) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CustomerCount)), __LINE__);
        }
        $this->CustomerCount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerCountsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
