<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * Meta information extracted from the WSDL
 * - documentation: Frequent flyer reference. ProgramID=airline code, MembershipID=FF number. | Identifies the loyalty program(s) that the customer belongs to and associated information. | A frequent renter number associated with the reservation. |
 * Details of the customer loyalty membership. | Loyalty program information. | Card holder loyalty program. | Program rewarding frequent use by accumulating credits for services provided by vendors. | Loyalty program information for the customer. |
 * Request booking records based on frequent flyer information.
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The MemberPreferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MemberPreferences
     */
    public $MemberPreferences;
    /**
     * The SecurityInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SecurityInfo
     */
    public $SecurityInfo;
    /**
     * The SubAccountBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\SubAccountBalance[]
     */
    public $SubAccountBalance;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with the customer's loyalty program.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The ProgramID
     * Meta information extracted from the WSDL
     * - documentation: Identifier to indicate the company owner of the loyalty program.
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the member in the program (membership number, account number, etc.).
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Identifies the travel sector. Refer to OpenTravel Code List Travel Sector (TVS).
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - documentation: Indicate the partner(s)/vendor(s) for which the customer loyalty number is valid.
     * - type: ListOfStringLength1to8
     * - use: optional
     * @var string
     */
    public $VendorCode;
    /**
     * The PrimaryLoyaltyIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates this is the primary customer loyalty program and when false, indicates this is not the primary customer loyalty program.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $PrimaryLoyaltyIndicator;
    /**
     * The AllianceLoyaltyLevelName
     * Meta information extracted from the WSDL
     * - documentation: Name of the alliance loyalty level (e.g.,OneWorld uses Emerald, Ruby, etc and SkyTeam uses Elite, etc.)
     * - type: StringLength1to128
     * - use: optional
     * @var string
     */
    public $AllianceLoyaltyLevelName;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - documentation: Original assessment of the customer by the travel agent.
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $CustomerType;
    /**
     * The CustomerValue
     * Meta information extracted from the WSDL
     * - documentation: The supplier's ranking of the customer (e.g., VIP, numerical ranking).
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $CustomerValue;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - documentation: The password for the member in the program.
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $Password;
    /**
     * The LoyalLevel
     * Meta information extracted from the WSDL
     * - documentation: Indicates special privileges in program assigned to individual.
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $LoyalLevel;
    /**
     * The LoyalLevelCode
     * Meta information extracted from the WSDL
     * - documentation: Provides a numeric code assigned to a particular loyalty level.
     * - type: Numeric1to3
     * - use: optional
     * @var string
     */
    public $LoyalLevelCode;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * The SignupDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates when the member signed up for the loyalty program.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $SignupDate;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the ExpireDate is the first day after the applicable period (e.g. when expire date is Oct 15 the last date of the period is Oct 14).
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A reference placeholder for this loyalty membership.
     * - type: RPH_Type
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setMemberPreferences()
     * @uses CustLoyalty::setSecurityInfo()
     * @uses CustLoyalty::setSubAccountBalance()
     * @uses CustLoyalty::setRemark()
     * @uses CustLoyalty::setOperation()
     * @uses CustLoyalty::setShareSynchInd()
     * @uses CustLoyalty::setShareMarketInd()
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setTravelSector()
     * @uses CustLoyalty::setVendorCode()
     * @uses CustLoyalty::setPrimaryLoyaltyIndicator()
     * @uses CustLoyalty::setAllianceLoyaltyLevelName()
     * @uses CustLoyalty::setCustomerType()
     * @uses CustLoyalty::setCustomerValue()
     * @uses CustLoyalty::setPassword()
     * @uses CustLoyalty::setLoyalLevel()
     * @uses CustLoyalty::setLoyalLevelCode()
     * @uses CustLoyalty::setSingleVendorInd()
     * @uses CustLoyalty::setSignupDate()
     * @uses CustLoyalty::setEffectiveDate()
     * @uses CustLoyalty::setExpireDate()
     * @uses CustLoyalty::setExpireDateExclusiveIndicator()
     * @uses CustLoyalty::setRPH()
     * @param \StructType\MemberPreferences $memberPreferences
     * @param \StructType\SecurityInfo $securityInfo
     * @param \StructType\SubAccountBalance[] $subAccountBalance
     * @param string $remark
     * @param string $operation
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $vendorCode
     * @param bool $primaryLoyaltyIndicator
     * @param string $allianceLoyaltyLevelName
     * @param string $customerType
     * @param string $customerValue
     * @param string $password
     * @param string $loyalLevel
     * @param string $loyalLevelCode
     * @param string $singleVendorInd
     * @param string $signupDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $rPH
     */
    public function __construct(\StructType\MemberPreferences $memberPreferences = null, \StructType\SecurityInfo $securityInfo = null, array $subAccountBalance = array(), $remark = null, $operation = null, $shareSynchInd = null, $shareMarketInd = null, $programID = null, $membershipID = null, $travelSector = null, $vendorCode = null, $primaryLoyaltyIndicator = null, $allianceLoyaltyLevelName = null, $customerType = null, $customerValue = null, $password = null, $loyalLevel = null, $loyalLevelCode = null, $singleVendorInd = null, $signupDate = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $rPH = null)
    {
        $this
            ->setMemberPreferences($memberPreferences)
            ->setSecurityInfo($securityInfo)
            ->setSubAccountBalance($subAccountBalance)
            ->setRemark($remark)
            ->setOperation($operation)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setVendorCode($vendorCode)
            ->setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator)
            ->setAllianceLoyaltyLevelName($allianceLoyaltyLevelName)
            ->setCustomerType($customerType)
            ->setCustomerValue($customerValue)
            ->setPassword($password)
            ->setLoyalLevel($loyalLevel)
            ->setLoyalLevelCode($loyalLevelCode)
            ->setSingleVendorInd($singleVendorInd)
            ->setSignupDate($signupDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setRPH($rPH);
    }
    /**
     * Get MemberPreferences value
     * @return \StructType\MemberPreferences|null
     */
    public function getMemberPreferences()
    {
        return $this->MemberPreferences;
    }
    /**
     * Set MemberPreferences value
     * @param \StructType\MemberPreferences $memberPreferences
     * @return \StructType\CustLoyalty
     */
    public function setMemberPreferences(\StructType\MemberPreferences $memberPreferences = null)
    {
        $this->MemberPreferences = $memberPreferences;
        return $this;
    }
    /**
     * Get SecurityInfo value
     * @return \StructType\SecurityInfo|null
     */
    public function getSecurityInfo()
    {
        return $this->SecurityInfo;
    }
    /**
     * Set SecurityInfo value
     * @param \StructType\SecurityInfo $securityInfo
     * @return \StructType\CustLoyalty
     */
    public function setSecurityInfo(\StructType\SecurityInfo $securityInfo = null)
    {
        $this->SecurityInfo = $securityInfo;
        return $this;
    }
    /**
     * Get SubAccountBalance value
     * @return \StructType\SubAccountBalance[]|null
     */
    public function getSubAccountBalance()
    {
        return $this->SubAccountBalance;
    }
    /**
     * This method is responsible for validating the values passed to the setSubAccountBalance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubAccountBalance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubAccountBalanceForArrayConstraintsFromSetSubAccountBalance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $custLoyaltySubAccountBalanceItem) {
            // validation for constraint: itemType
            if (!$custLoyaltySubAccountBalanceItem instanceof \StructType\SubAccountBalance) {
                $invalidValues[] = is_object($custLoyaltySubAccountBalanceItem) ? get_class($custLoyaltySubAccountBalanceItem) : sprintf('%s(%s)', gettype($custLoyaltySubAccountBalanceItem), var_export($custLoyaltySubAccountBalanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubAccountBalance property can only contain items of type \StructType\SubAccountBalance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubAccountBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubAccountBalance[] $subAccountBalance
     * @return \StructType\CustLoyalty
     */
    public function setSubAccountBalance(array $subAccountBalance = array())
    {
        // validation for constraint: array
        if ('' !== ($subAccountBalanceArrayErrorMessage = self::validateSubAccountBalanceForArrayConstraintsFromSetSubAccountBalance($subAccountBalance))) {
            throw new \InvalidArgumentException($subAccountBalanceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($subAccountBalance) && count($subAccountBalance) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($subAccountBalance)), __LINE__);
        }
        $this->SubAccountBalance = $subAccountBalance;
        return $this;
    }
    /**
     * Add item to SubAccountBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubAccountBalance $item
     * @return \StructType\CustLoyalty
     */
    public function addToSubAccountBalance(\StructType\SubAccountBalance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubAccountBalance) {
            throw new \InvalidArgumentException(sprintf('The SubAccountBalance property can only contain items of type \StructType\SubAccountBalance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SubAccountBalance) && count($this->SubAccountBalance) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SubAccountBalance)), __LINE__);
        }
        $this->SubAccountBalance[] = $item;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\CustLoyalty
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\CustLoyalty
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\CustLoyalty
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\CustLoyalty
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \StructType\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \StructType\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\CustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\CustLoyalty
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get PrimaryLoyaltyIndicator value
     * @return bool|null
     */
    public function getPrimaryLoyaltyIndicator()
    {
        return $this->PrimaryLoyaltyIndicator;
    }
    /**
     * Set PrimaryLoyaltyIndicator value
     * @param bool $primaryLoyaltyIndicator
     * @return \StructType\CustLoyalty
     */
    public function setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryLoyaltyIndicator) && !is_bool($primaryLoyaltyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryLoyaltyIndicator, true), gettype($primaryLoyaltyIndicator)), __LINE__);
        }
        $this->PrimaryLoyaltyIndicator = $primaryLoyaltyIndicator;
        return $this;
    }
    /**
     * Get AllianceLoyaltyLevelName value
     * @return string|null
     */
    public function getAllianceLoyaltyLevelName()
    {
        return $this->AllianceLoyaltyLevelName;
    }
    /**
     * Set AllianceLoyaltyLevelName value
     * @param string $allianceLoyaltyLevelName
     * @return \StructType\CustLoyalty
     */
    public function setAllianceLoyaltyLevelName($allianceLoyaltyLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($allianceLoyaltyLevelName) && !is_string($allianceLoyaltyLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceLoyaltyLevelName, true), gettype($allianceLoyaltyLevelName)), __LINE__);
        }
        $this->AllianceLoyaltyLevelName = $allianceLoyaltyLevelName;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param string $customerType
     * @return \StructType\CustLoyalty
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: string
        if (!is_null($customerType) && !is_string($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \StructType\CustLoyalty
     */
    public function setCustomerValue($customerValue = null)
    {
        // validation for constraint: string
        if (!is_null($customerValue) && !is_string($customerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerValue, true), gettype($customerValue)), __LINE__);
        }
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\CustLoyalty
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get LoyalLevel value
     * @return string|null
     */
    public function getLoyalLevel()
    {
        return $this->LoyalLevel;
    }
    /**
     * Set LoyalLevel value
     * @param string $loyalLevel
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevel($loyalLevel = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevel) && !is_string($loyalLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevel, true), gettype($loyalLevel)), __LINE__);
        }
        $this->LoyalLevel = $loyalLevel;
        return $this;
    }
    /**
     * Get LoyalLevelCode value
     * @return string|null
     */
    public function getLoyalLevelCode()
    {
        return $this->LoyalLevelCode;
    }
    /**
     * Set LoyalLevelCode value
     * @param string $loyalLevelCode
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevelCode($loyalLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevelCode) && !is_string($loyalLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevelCode, true), gettype($loyalLevelCode)), __LINE__);
        }
        $this->LoyalLevelCode = $loyalLevelCode;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \StructType\CustLoyalty
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        // validation for constraint: string
        if (!is_null($singleVendorInd) && !is_string($singleVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleVendorInd, true), gettype($singleVendorInd)), __LINE__);
        }
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \StructType\CustLoyalty
     */
    public function setSignupDate($signupDate = null)
    {
        // validation for constraint: string
        if (!is_null($signupDate) && !is_string($signupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupDate, true), gettype($signupDate)), __LINE__);
        }
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CustLoyalty
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\CustLoyalty
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\CustLoyalty
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\CustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
