<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseReservationType StructType
 * @subpackage Structs
 */
class CruiseReservationType extends AbstractStructBase
{
    /**
     * The SailingInfo
     * Meta information extracted from the WSDL
     * - documentation: Specifies the selected category to book. Contains information related to the selected sailing. Typically the selected sailing is one of the sailings returned in the previous sailing availability response.
     * @var mixed
     */
    public $SailingInfo;
    /**
     * The SailingProfile
     * Meta information extracted from the WSDL
     * - documentation: Specifies the profile information at the sailing level.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SailingProfile;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - documentation: Specifies reservation and guest information about the booking.
     * @var mixed
     */
    public $ReservationInfo;
    /**
     * The PaymentsDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentsDue
     */
    public $PaymentsDue;
    /**
     * The Information
     * Meta information extracted from the WSDL
     * - documentation: Contains information such as advisories or marketing messages returned by the cruise line.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Information;
    /**
     * Constructor method for CruiseReservationType
     * @uses CruiseReservationType::setSailingInfo()
     * @uses CruiseReservationType::setSailingProfile()
     * @uses CruiseReservationType::setReservationInfo()
     * @uses CruiseReservationType::setPaymentsDue()
     * @uses CruiseReservationType::setInformation()
     * @param mixed $sailingInfo
     * @param mixed[] $sailingProfile
     * @param mixed $reservationInfo
     * @param \StructType\PaymentsDue $paymentsDue
     * @param mixed[] $information
     */
    public function __construct($sailingInfo = null, array $sailingProfile = array(), $reservationInfo = null, \StructType\PaymentsDue $paymentsDue = null, array $information = array())
    {
        $this
            ->setSailingInfo($sailingInfo)
            ->setSailingProfile($sailingProfile)
            ->setReservationInfo($reservationInfo)
            ->setPaymentsDue($paymentsDue)
            ->setInformation($information);
    }
    /**
     * Get SailingInfo value
     * @return mixed|null
     */
    public function getSailingInfo()
    {
        return $this->SailingInfo;
    }
    /**
     * Set SailingInfo value
     * @param mixed $sailingInfo
     * @return \StructType\CruiseReservationType
     */
    public function setSailingInfo($sailingInfo = null)
    {
        $this->SailingInfo = $sailingInfo;
        return $this;
    }
    /**
     * Get SailingProfile value
     * @return mixed[]|null
     */
    public function getSailingProfile()
    {
        return $this->SailingProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setSailingProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSailingProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSailingProfileForArrayConstraintsFromSetSailingProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseReservationTypeSailingProfileItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseReservationTypeSailingProfileItem) ? get_class($cruiseReservationTypeSailingProfileItem) : sprintf('%s(%s)', gettype($cruiseReservationTypeSailingProfileItem), var_export($cruiseReservationTypeSailingProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SailingProfile property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SailingProfile value
     * @throws \InvalidArgumentException
     * @param mixed[] $sailingProfile
     * @return \StructType\CruiseReservationType
     */
    public function setSailingProfile(array $sailingProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($sailingProfileArrayErrorMessage = self::validateSailingProfileForArrayConstraintsFromSetSailingProfile($sailingProfile))) {
            throw new \InvalidArgumentException($sailingProfileArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($sailingProfile) && count($sailingProfile) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($sailingProfile)), __LINE__);
        }
        $this->SailingProfile = $sailingProfile;
        return $this;
    }
    /**
     * Add item to SailingProfile value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseReservationType
     */
    public function addToSailingProfile($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SailingProfile property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->SailingProfile) && count($this->SailingProfile) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->SailingProfile)), __LINE__);
        }
        $this->SailingProfile[] = $item;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return mixed|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param mixed $reservationInfo
     * @return \StructType\CruiseReservationType
     */
    public function setReservationInfo($reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get PaymentsDue value
     * @return \StructType\PaymentsDue|null
     */
    public function getPaymentsDue()
    {
        return $this->PaymentsDue;
    }
    /**
     * Set PaymentsDue value
     * @param \StructType\PaymentsDue $paymentsDue
     * @return \StructType\CruiseReservationType
     */
    public function setPaymentsDue(\StructType\PaymentsDue $paymentsDue = null)
    {
        $this->PaymentsDue = $paymentsDue;
        return $this;
    }
    /**
     * Get Information value
     * @return mixed[]|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * This method is responsible for validating the values passed to the setInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformationForArrayConstraintsFromSetInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseReservationTypeInformationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseReservationTypeInformationItem) ? get_class($cruiseReservationTypeInformationItem) : sprintf('%s(%s)', gettype($cruiseReservationTypeInformationItem), var_export($cruiseReservationTypeInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Information property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Information value
     * @throws \InvalidArgumentException
     * @param mixed[] $information
     * @return \StructType\CruiseReservationType
     */
    public function setInformation(array $information = array())
    {
        // validation for constraint: array
        if ('' !== ($informationArrayErrorMessage = self::validateInformationForArrayConstraintsFromSetInformation($information))) {
            throw new \InvalidArgumentException($informationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($information) && count($information) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($information)), __LINE__);
        }
        $this->Information = $information;
        return $this;
    }
    /**
     * Add item to Information value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseReservationType
     */
    public function addToInformation($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Information property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Information) && count($this->Information) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Information)), __LINE__);
        }
        $this->Information[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruiseReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
