<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: To retrieve cruise booking information when the confirmation number is not known.
 * @subpackage Structs
 */
class CruiseReadRequest extends AbstractStructBase
{
    /**
     * The SelectedSailing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SelectedSailing
     */
    public $SelectedSailing;
    /**
     * The GuestInfo
     * Meta information extracted from the WSDL
     * - documentation: Contains the guest information such as last name and first name.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $GuestInfo;
    /**
     * The HistoryRequestedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the history of the reservation should be returned.
     * - use: optional
     * @var bool
     */
    public $HistoryRequestedInd;
    /**
     * Constructor method for CruiseReadRequest
     * @uses CruiseReadRequest::setSelectedSailing()
     * @uses CruiseReadRequest::setGuestInfo()
     * @uses CruiseReadRequest::setHistoryRequestedInd()
     * @param \StructType\SelectedSailing $selectedSailing
     * @param \StructType\PersonNameType $guestInfo
     * @param bool $historyRequestedInd
     */
    public function __construct(\StructType\SelectedSailing $selectedSailing = null, \StructType\PersonNameType $guestInfo = null, $historyRequestedInd = null)
    {
        $this
            ->setSelectedSailing($selectedSailing)
            ->setGuestInfo($guestInfo)
            ->setHistoryRequestedInd($historyRequestedInd);
    }
    /**
     * Get SelectedSailing value
     * @return \StructType\SelectedSailing|null
     */
    public function getSelectedSailing()
    {
        return $this->SelectedSailing;
    }
    /**
     * Set SelectedSailing value
     * @param \StructType\SelectedSailing $selectedSailing
     * @return \StructType\CruiseReadRequest
     */
    public function setSelectedSailing(\StructType\SelectedSailing $selectedSailing = null)
    {
        $this->SelectedSailing = $selectedSailing;
        return $this;
    }
    /**
     * Get GuestInfo value
     * @return \StructType\PersonNameType|null
     */
    public function getGuestInfo()
    {
        return $this->GuestInfo;
    }
    /**
     * Set GuestInfo value
     * @param \StructType\PersonNameType $guestInfo
     * @return \StructType\CruiseReadRequest
     */
    public function setGuestInfo(\StructType\PersonNameType $guestInfo = null)
    {
        $this->GuestInfo = $guestInfo;
        return $this;
    }
    /**
     * Get HistoryRequestedInd value
     * @return bool|null
     */
    public function getHistoryRequestedInd()
    {
        return $this->HistoryRequestedInd;
    }
    /**
     * Set HistoryRequestedInd value
     * @param bool $historyRequestedInd
     * @return \StructType\CruiseReadRequest
     */
    public function setHistoryRequestedInd($historyRequestedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($historyRequestedInd) && !is_bool($historyRequestedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($historyRequestedInd, true), gettype($historyRequestedInd)), __LINE__);
        }
        $this->HistoryRequestedInd = $historyRequestedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruiseReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
