<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the data requirements.
 * @subpackage Structs
 */
class CruiseProfileType extends AbstractStructBase
{
    /**
     * The ProfileTypeIdentifier
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ProfileTypeIdentifier;
    /**
     * The CruiseProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CruiseProfile[]
     */
    public $CruiseProfile;
    /**
     * Constructor method for CruiseProfileType
     * @uses CruiseProfileType::setProfileTypeIdentifier()
     * @uses CruiseProfileType::setCruiseProfile()
     * @param string $profileTypeIdentifier
     * @param \StructType\CruiseProfile[] $cruiseProfile
     */
    public function __construct($profileTypeIdentifier = null, array $cruiseProfile = array())
    {
        $this
            ->setProfileTypeIdentifier($profileTypeIdentifier)
            ->setCruiseProfile($cruiseProfile);
    }
    /**
     * Get ProfileTypeIdentifier value
     * @return string
     */
    public function getProfileTypeIdentifier()
    {
        return $this->ProfileTypeIdentifier;
    }
    /**
     * Set ProfileTypeIdentifier value
     * @param string $profileTypeIdentifier
     * @return \StructType\CruiseProfileType
     */
    public function setProfileTypeIdentifier($profileTypeIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($profileTypeIdentifier) && !is_string($profileTypeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileTypeIdentifier, true), gettype($profileTypeIdentifier)), __LINE__);
        }
        $this->ProfileTypeIdentifier = $profileTypeIdentifier;
        return $this;
    }
    /**
     * Get CruiseProfile value
     * @return \StructType\CruiseProfile[]|null
     */
    public function getCruiseProfile()
    {
        return $this->CruiseProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setCruiseProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCruiseProfileForArrayConstraintsFromSetCruiseProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseProfileTypeCruiseProfileItem) {
            // validation for constraint: itemType
            if (!$cruiseProfileTypeCruiseProfileItem instanceof \StructType\CruiseProfile) {
                $invalidValues[] = is_object($cruiseProfileTypeCruiseProfileItem) ? get_class($cruiseProfileTypeCruiseProfileItem) : sprintf('%s(%s)', gettype($cruiseProfileTypeCruiseProfileItem), var_export($cruiseProfileTypeCruiseProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CruiseProfile property can only contain items of type \StructType\CruiseProfile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CruiseProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseProfile[] $cruiseProfile
     * @return \StructType\CruiseProfileType
     */
    public function setCruiseProfile(array $cruiseProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($cruiseProfileArrayErrorMessage = self::validateCruiseProfileForArrayConstraintsFromSetCruiseProfile($cruiseProfile))) {
            throw new \InvalidArgumentException($cruiseProfileArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($cruiseProfile) && count($cruiseProfile) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($cruiseProfile)), __LINE__);
        }
        $this->CruiseProfile = $cruiseProfile;
        return $this;
    }
    /**
     * Add item to CruiseProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseProfile $item
     * @return \StructType\CruiseProfileType
     */
    public function addToCruiseProfile(\StructType\CruiseProfile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CruiseProfile) {
            throw new \InvalidArgumentException(sprintf('The CruiseProfile property can only contain items of type \StructType\CruiseProfile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CruiseProfile) && count($this->CruiseProfile) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CruiseProfile)), __LINE__);
        }
        $this->CruiseProfile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruiseProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
