<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruisePackageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines pre/post/shorex/bus/transfers packages.
 * @subpackage Structs
 */
class CruisePackageType extends AbstractStructBase
{
    /**
     * The PackageTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the type of the package. Refer to OpenTravel Codelist Cruise Package Type (CPK).
     * - use: required
     * @var string
     */
    public $PackageTypeCode;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \StructType\Location[]
     */
    public $Location;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Status of the package. Refer to OpenTravel Code table Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for CruisePackageType
     * @uses CruisePackageType::setPackageTypeCode()
     * @uses CruisePackageType::setLocation()
     * @uses CruisePackageType::setStatus()
     * @param string $packageTypeCode
     * @param \StructType\Location[] $location
     * @param string $status
     */
    public function __construct($packageTypeCode = null, array $location = array(), $status = null)
    {
        $this
            ->setPackageTypeCode($packageTypeCode)
            ->setLocation($location)
            ->setStatus($status);
    }
    /**
     * Get PackageTypeCode value
     * @return string
     */
    public function getPackageTypeCode()
    {
        return $this->PackageTypeCode;
    }
    /**
     * Set PackageTypeCode value
     * @param string $packageTypeCode
     * @return \StructType\CruisePackageType
     */
    public function setPackageTypeCode($packageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageTypeCode) && !is_string($packageTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageTypeCode, true), gettype($packageTypeCode)), __LINE__);
        }
        $this->PackageTypeCode = $packageTypeCode;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruisePackageTypeLocationItem) {
            // validation for constraint: itemType
            if (!$cruisePackageTypeLocationItem instanceof \StructType\Location) {
                $invalidValues[] = is_object($cruisePackageTypeLocationItem) ? get_class($cruisePackageTypeLocationItem) : sprintf('%s(%s)', gettype($cruisePackageTypeLocationItem), var_export($cruisePackageTypeLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $location
     * @return \StructType\CruisePackageType
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($location) && count($location) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \StructType\CruisePackageType
     */
    public function addToLocation(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->Location) && count($this->Location) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->Location)), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\CruisePackageType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruisePackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
